/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.expression.CharacterExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.query.StatementText;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.query.QueryStatement;

public class Oracle99QueryStatement
extends QueryStatement {
    private String nlsSortOrder = "LATIN";

    public Oracle99QueryStatement(DatastoreContainerObject initialTable, ClassLoaderResolver clr) {
        this(initialTable, null, clr);
    }

    public Oracle99QueryStatement(DatastoreContainerObject initialTable, DatastoreIdentifier alias, ClassLoaderResolver clr) {
        super(initialTable, alias, clr);
        String sortOrder = this.storeMgr.getOMFContext().getPersistenceConfiguration().getStringProperty("datanucleus.rdbms.oracleNlsSortOrder");
        if (sortOrder != null) {
            this.nlsSortOrder = sortOrder.toUpperCase();
        }
    }

    protected StatementText generateOrderingStatement() {
        StatementText orderByStmt = null;
        if (this.orderingExpressions != null && this.orderingExpressions.length > 0) {
            RDBMSAdapter dba = (RDBMSAdapter)this.storeMgr.getDatastoreAdapter();
            orderByStmt = new StatementText();
            boolean needsSelect = dba.supportsOption("IncludeOrderByColumnsInSelect");
            for (int i = 0; i < this.orderingExpressions.length; ++i) {
                String orderExpr = "JPOXORDER" + i;
                if (i > 0) {
                    orderByStmt.append(',');
                }
                if (needsSelect && !this.hasAggregateExpression) {
                    if (this.orderingExpressions[i] instanceof CharacterExpression && !this.nlsSortOrder.equals("BINARY")) {
                        orderByStmt.append("NLSSORT(").append(orderExpr).append(", 'NLS_SORT = ").append(this.nlsSortOrder).append("')");
                    } else {
                        orderByStmt.append(orderExpr);
                    }
                } else if (this.orderingExpressions[i] instanceof CharacterExpression && !this.nlsSortOrder.equals("BINARY")) {
                    orderByStmt.append("NLSSORT(").append(this.orderingExpressions[i].toStatementText(ScalarExpression.PROJECTION).toStatementString(ScalarExpression.PROJECTION)).append(", 'NLS_SORT = ").append(this.nlsSortOrder).append("')");
                } else {
                    orderByStmt.append(this.orderingExpressions[i].toStatementText(ScalarExpression.PROJECTION).toStatementString(ScalarExpression.PROJECTION));
                }
                if (!this.orderingDirections[i]) continue;
                orderByStmt.append(" DESC");
            }
        }
        return orderByStmt;
    }
}

