/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.sql.DatabaseMetaData;
import org.datanucleus.ManagedConnection;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.TableExprAsJoins;
import org.datanucleus.store.rdbms.adapter.DatabaseAdapter;
import org.datanucleus.store.rdbms.schema.JDBCTypeInfo;
import org.datanucleus.store.rdbms.schema.RDBMSTypesInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.schema.StoreSchemaHandler;

public class PointbaseAdapter
extends DatabaseAdapter {
    public PointbaseAdapter(DatabaseMetaData metadata) {
        super(metadata);
        this.supportedOptions.remove("BooleanExpression");
        this.supportedOptions.remove("DeferredConstraints");
    }

    public void initialiseTypes(StoreSchemaHandler handler, ManagedConnection mconn) {
        SQLTypeInfo sqlType;
        SQLTypeInfo dfltTypeInfo;
        super.initialiseTypes(handler, mconn);
        RDBMSTypesInfo typesInfo = (RDBMSTypesInfo)handler.getSchemaData(mconn.getConnection(), "types", null);
        JDBCTypeInfo jdbcType = (JDBCTypeInfo)typesInfo.getChild("9");
        if (jdbcType != null && jdbcType.getNumberOfChildren() > 0) {
            dfltTypeInfo = (SQLTypeInfo)jdbcType.getChild("DEFAULT");
            sqlType = new SQLTypeInfo(dfltTypeInfo.getTypeName(), -5, dfltTypeInfo.getPrecision(), dfltTypeInfo.getLiteralPrefix(), dfltTypeInfo.getLiteralSuffix(), dfltTypeInfo.getCreateParams(), dfltTypeInfo.getNullable(), dfltTypeInfo.isCaseSensitive(), dfltTypeInfo.getSearchable(), dfltTypeInfo.isUnsignedAttribute(), dfltTypeInfo.isFixedPrecScale(), dfltTypeInfo.isAutoIncrement(), dfltTypeInfo.getLocalTypeName(), dfltTypeInfo.getMinimumScale(), dfltTypeInfo.getMaximumScale(), dfltTypeInfo.getNumPrecRadix());
            this.addSQLTypeForJDBCType(handler, mconn, (short)-5, sqlType, true);
        }
        if ((jdbcType = (JDBCTypeInfo)typesInfo.getChild("16")) != null) {
            dfltTypeInfo = (SQLTypeInfo)jdbcType.getChild("DEFAULT");
            sqlType = new SQLTypeInfo(dfltTypeInfo.getTypeName(), 16, dfltTypeInfo.getPrecision(), dfltTypeInfo.getLiteralPrefix(), dfltTypeInfo.getLiteralSuffix(), dfltTypeInfo.getCreateParams(), dfltTypeInfo.getNullable(), dfltTypeInfo.isCaseSensitive(), dfltTypeInfo.getSearchable(), dfltTypeInfo.isUnsignedAttribute(), dfltTypeInfo.isFixedPrecScale(), dfltTypeInfo.isAutoIncrement(), dfltTypeInfo.getLocalTypeName(), dfltTypeInfo.getMinimumScale(), dfltTypeInfo.getMaximumScale(), dfltTypeInfo.getNumPrecRadix());
            this.addSQLTypeForJDBCType(handler, mconn, (short)16, sqlType, true);
        }
    }

    public String getVendorID() {
        return "pointbase";
    }

    public int getUnlimitedLengthPrecisionValue(SQLTypeInfo typeInfo) {
        if (typeInfo.getDataType() == 2004 || typeInfo.getDataType() == 2005) {
            return Integer.MIN_VALUE;
        }
        return super.getUnlimitedLengthPrecisionValue(typeInfo);
    }

    public LogicSetExpression newTableExpression(QueryExpression qs, DatastoreContainerObject table, DatastoreIdentifier rangeVar) {
        return new TableExprAsJoins(qs, table, rangeVar);
    }
}

