/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.TableExprAsJoins;
import org.datanucleus.store.rdbms.adapter.DatabaseAdapter;
import org.datanucleus.store.rdbms.key.PrimaryKey;
import org.datanucleus.store.rdbms.schema.H2TypeInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;

public class H2Adapter
extends DatabaseAdapter {
    private String schemaName;

    public H2Adapter(DatabaseMetaData metadata) {
        super(metadata);
        try {
            ResultSet rs = metadata.getSchemas();
            while (rs.next()) {
                if (!rs.getBoolean("IS_DEFAULT")) continue;
                this.schemaName = rs.getString("TABLE_SCHEM");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.supportedOptions.add("PrimaryKeyInCreateStatements");
        this.supportedOptions.add("LockWithSelectForUpdate");
        this.supportedOptions.add("IdentityColumns");
        this.supportedOptions.add("CheckInEndCreateStatements");
        this.supportedOptions.add("UniqueInEndCreateStatements");
        this.supportedOptions.remove("DeferredConstraints");
        this.supportedOptions.remove("AnalysisMethods");
    }

    public String getVendorID() {
        return "h2";
    }

    public SQLTypeInfo newSQLTypeInfo(ResultSet rs) {
        return new H2TypeInfo(rs);
    }

    public int getMaxTableNameLength() {
        return 128;
    }

    public int getMaxConstraintNameLength() {
        return 128;
    }

    public int getMaxIndexNameLength() {
        return 128;
    }

    public int getMaxColumnNameLength() {
        return 128;
    }

    public String getAddColumnStatement(DatastoreContainerObject table, Column col) {
        return "ALTER TABLE " + table.toString() + " ADD COLUMN " + col.getSQLDefinition();
    }

    public String getRangeByLimitSelectClause(long offset, long count) {
        if (offset >= 0L && count > 0L) {
            return " LIMIT " + offset + " " + count + " ";
        }
        if (offset <= 0L && count > 0L) {
            return " LIMIT 0 " + count + " ";
        }
        if (offset >= 0L && count < 0L) {
            return " LIMIT " + offset + "," + Long.MAX_VALUE;
        }
        return "";
    }

    public boolean supportsTransactionIsolationLevel(int isolationLevel) {
        return isolationLevel == 2 || isolationLevel == 8 || isolationLevel == 1;
    }

    public String getSchemaName(Connection conn) throws SQLException {
        return this.schemaName;
    }

    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        return null;
    }

    public String getDropTableStatement(DatastoreContainerObject table) {
        return "DROP TABLE " + table.toString();
    }

    public String getAutoIncrementStmt(Table table, String columnName) {
        return "CALL IDENTITY()";
    }

    public String getAutoIncrementKeyword() {
        return "IDENTITY";
    }

    public String getInsertStatementForNoColumns(Table table) {
        return "INSERT INTO " + table.toString() + " VALUES(NULL)";
    }

    public boolean isValidPrimaryKeyType(int datatype) {
        return true;
    }

    public NumericExpression modOperator(ScalarExpression operand1, ScalarExpression operand2) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(operand1);
        args.add(operand2);
        return new NumericExpression("MOD", args);
    }

    public LogicSetExpression newTableExpression(QueryExpression qs, DatastoreContainerObject table, DatastoreIdentifier rangeVar) {
        return new TableExprAsJoins(qs, table, rangeVar);
    }
}

