/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.jdo.JDODataStoreException;
import javax.jdo.datastore.Sequence;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.ExtensionMetaData;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.store.NucleusSequence;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.valuegenerator.ValueGenerationConnectionProvider;
import org.datanucleus.store.valuegenerator.ValueGenerationManager;
import org.datanucleus.store.valuegenerator.ValueGenerator;
import org.datanucleus.transaction.TransactionUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class JDOSequenceImpl
implements Sequence,
NucleusSequence {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)(class$org$datanucleus$ObjectManager == null ? (class$org$datanucleus$ObjectManager = JDOSequenceImpl.class$("org.datanucleus.ObjectManager")) : class$org$datanucleus$ObjectManager).getClassLoader());
    protected final MappedStoreManager storeManager;
    protected final SequenceMetaData seqMetaData;
    protected final ValueGenerator generator;
    protected final ObjectManager om;
    static /* synthetic */ Class class$org$datanucleus$ObjectManager;

    public JDOSequenceImpl(ObjectManager objectMgr, MappedStoreManager storeMgr, SequenceMetaData seqmd) {
        this.om = objectMgr;
        this.storeManager = storeMgr;
        this.seqMetaData = seqmd;
        String poidGeneratorName = null;
        poidGeneratorName = storeMgr.getDatastoreAdapter().supportsOption("Sequences") ? "sequence" : "table-sequence";
        Properties props = new Properties();
        ExtensionMetaData[] seqExtensions = seqmd.getExtensions();
        if (seqExtensions != null && seqExtensions.length > 0) {
            for (int i = 0; i < seqExtensions.length; ++i) {
                ((Hashtable)props).put(seqExtensions[i].getKey(), seqExtensions[i].getValue());
            }
        }
        if (poidGeneratorName.equals("sequence")) {
            ((Hashtable)props).put("sequence-name", this.seqMetaData.getDatastoreSequence());
        } else if (poidGeneratorName.equals("table-sequence")) {
            ((Hashtable)props).put("sequence-name", this.seqMetaData.getDatastoreSequence());
        }
        ValueGenerationManager mgr = storeMgr.getPoidManager();
        ValueGenerationConnectionProvider connProvider = new ValueGenerationConnectionProvider(){
            ManagedConnection mconn;

            public ManagedConnection retrieveConnection() {
                try {
                    PersistenceConfiguration conf = JDOSequenceImpl.this.om.getOMFContext().getPersistenceConfiguration();
                    int isolationLevel = TransactionUtils.getTransactionIsolationLevelForName((String)conf.getStringProperty("datanucleus.valuegeneration.transactionIsolation"));
                    this.mconn = ((RDBMSManager)JDOSequenceImpl.this.storeManager).getConnection(isolationLevel);
                }
                catch (SQLException e) {
                    String msg = LOCALISER.msg("017006", (Object)e);
                    NucleusLogger.JDO.error((Object)msg);
                    throw new JDODataStoreException(msg, (Throwable)e);
                }
                return this.mconn;
            }

            public void releaseConnection() {
                try {
                    this.mconn.close();
                }
                catch (NucleusException e) {
                    String msg = LOCALISER.msg("017007", (Object)e);
                    NucleusLogger.JDO.error((Object)msg);
                    throw new JDODataStoreException(msg, (Throwable)e);
                }
            }
        };
        Class cls = null;
        ConfigurationElement elem = objectMgr.getOMFContext().getPluginManager().getConfigurationElementForExtension("org.datanucleus.store_valuegenerator", new String[]{"name", "datastore"}, new String[]{poidGeneratorName, this.storeManager.getStoreManagerKey()});
        if (elem != null) {
            cls = objectMgr.getOMFContext().getPluginManager().loadClass(elem.getExtension().getPlugin().getSymbolicName(), elem.getAttribute("class-name"));
        }
        if (cls == null) {
            throw new NucleusException("Cannot create Poid Generator for strategy " + poidGeneratorName);
        }
        this.generator = mgr.createValueGenerator(this.seqMetaData.getName(), cls, props, (StoreManager)this.storeManager, connProvider);
        if (NucleusLogger.JDO.isDebugEnabled()) {
            NucleusLogger.JDO.debug((Object)LOCALISER.msg("017003", (Object)this.seqMetaData.getName(), (Object)poidGeneratorName));
        }
    }

    public String getName() {
        return this.seqMetaData.getName();
    }

    public void allocate(int additional) {
        try {
            this.generator.allocate(additional);
        }
        catch (NucleusException nucleusException) {
            // empty catch block
        }
    }

    public Object next() {
        try {
            return this.generator.next();
        }
        catch (NucleusDataStoreException dse) {
            if (dse.getFailedObject() != null) {
                throw new JDODataStoreException(dse.getMessage(), dse.getFailedObject());
            }
            throw new JDODataStoreException(dse.getMessage(), dse.getNestedExceptions());
        }
    }

    public long nextValue() {
        try {
            return this.generator.nextValue();
        }
        catch (NucleusDataStoreException dse) {
            if (dse.getFailedObject() != null) {
                throw new JDODataStoreException(dse.getMessage(), dse.getFailedObject());
            }
            throw new JDODataStoreException(dse.getMessage(), dse.getNestedExceptions());
        }
    }

    public Object current() {
        try {
            return this.generator.current();
        }
        catch (NucleusDataStoreException dse) {
            if (dse.getFailedObject() != null) {
                throw new JDODataStoreException(dse.getMessage(), dse.getFailedObject());
            }
            throw new JDODataStoreException(dse.getMessage(), dse.getNestedExceptions());
        }
    }

    public long currentValue() {
        try {
            return this.generator.currentValue();
        }
        catch (NucleusDataStoreException dse) {
            if (dse.getFailedObject() != null) {
                throw new JDODataStoreException(dse.getMessage(), dse.getFailedObject());
            }
            throw new JDODataStoreException(dse.getMessage(), dse.getNestedExceptions());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

