/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.util.Collection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.sco.SCO;
import org.datanucleus.sco.SCOCollection;
import org.datanucleus.sco.SCOContainer;
import org.datanucleus.sco.SCOUtils;
import org.datanucleus.store.exceptions.ReachableObjectNotCascadedException;
import org.datanucleus.store.mapped.expression.CollectionExpression;
import org.datanucleus.store.mapped.expression.CollectionLiteral;
import org.datanucleus.store.mapped.expression.CollectionSubqueryExpression;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.AbstractContainerMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.store.mapped.query.Queryable;
import org.datanucleus.store.scostore.CollectionStore;
import org.datanucleus.util.NucleusLogger;

public class CollectionMapping
extends AbstractContainerMapping
implements MappingCallbacks {
    static /* synthetic */ Class class$java$util$Collection;

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        CollectionMapping sm = (CollectionMapping)obj;
        return this.fmd.equals(sm.fmd) && ((Object)((Object)this.storeMgr)).equals((Object)sm.storeMgr);
    }

    public Class getJavaType() {
        return class$java$util$Collection == null ? (class$java$util$Collection = CollectionMapping.class$("java.util.Collection")) : class$java$util$Collection;
    }

    public void postInsert(StateManager sm) {
        Collection value = (Collection)sm.provideField(this.fmd.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            SCOUtils.validateObjectsForWriting((ObjectManager)sm.getObjectManager(), (Object)value);
            return;
        }
        if (value == null) {
            this.replaceFieldWithWrapper(sm, null, false, false);
            return;
        }
        Object[] collElements = value.toArray();
        if (!this.fmd.isCascadePersist()) {
            if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
                NucleusLogger.REACHABILITY.debug((Object)JavaTypeMapping.LOCALISER.msg("007006", (Object)this.fmd.getFullFieldName()));
            }
            for (int i = 0; i < collElements.length; ++i) {
                if (sm.getObjectManager().getApiAdapter().isDetached(collElements[i]) || sm.getObjectManager().getApiAdapter().isPersistent(collElements[i])) continue;
                throw new ReachableObjectNotCascadedException(this.fmd.getFullFieldName(), collElements[i]);
            }
        } else {
            if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
                NucleusLogger.REACHABILITY.debug((Object)JavaTypeMapping.LOCALISER.msg("007007", (Object)this.fmd.getFullFieldName()));
            }
            boolean needsAttaching = false;
            for (int i = 0; i < collElements.length; ++i) {
                if (!sm.getObjectManager().getApiAdapter().isDetached(collElements[i])) continue;
                needsAttaching = true;
                break;
            }
            if (needsAttaching) {
                SCO collWrapper = this.replaceFieldWithWrapper(sm, null, false, false);
                collWrapper.attachCopy((Object)value);
            } else if (value.size() > 0) {
                ((CollectionStore)this.storeMgr.getBackingStoreForField(sm.getObjectManager().getClassLoaderResolver(), this.fmd, value.getClass())).addAll(sm, value, 0);
                this.replaceFieldWithWrapper(sm, value, false, false);
            } else {
                this.replaceFieldWithWrapper(sm, null, false, false);
            }
        }
    }

    public void postUpdate(StateManager sm) {
        ObjectManager om = sm.getObjectManager();
        Collection value = (Collection)sm.provideField(this.fmd.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            SCOUtils.validateObjectsForWriting((ObjectManager)om, (Object)value);
            return;
        }
        if (value == null) {
            ((CollectionStore)this.storeMgr.getBackingStoreForField(om.getClassLoaderResolver(), this.fmd, null)).clear(sm);
            this.replaceFieldWithWrapper(sm, null, false, false);
            return;
        }
        if (value instanceof SCOContainer) {
            SCOContainer sco = (SCOContainer)value;
            if (sm.getObject() == sco.getOwner() && this.fieldName.equals(sco.getFieldName())) {
                sco.flush();
                return;
            }
            if (sco.getOwner() != null) {
                throw new NucleusException(JavaTypeMapping.LOCALISER.msg("CollectionMapping.WrongOwnerError")).setFatal();
            }
        }
        if (!this.fmd.isCascadeUpdate()) {
            if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
                NucleusLogger.REACHABILITY.debug((Object)JavaTypeMapping.LOCALISER.msg("007008", (Object)this.fmd.getFullFieldName()));
            }
            return;
        }
        if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
            NucleusLogger.REACHABILITY.debug((Object)JavaTypeMapping.LOCALISER.msg("007009", (Object)this.fmd.getFullFieldName()));
        }
        CollectionStore backingStore = (CollectionStore)this.storeMgr.getBackingStoreForField(om.getClassLoaderResolver(), this.fmd, value.getClass());
        backingStore.clear(sm);
        backingStore.addAll(sm, value, 0);
        this.replaceFieldWithWrapper(sm, value, false, false);
    }

    public void preDelete(StateManager sm) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        sm.getObjectManager().getApiAdapter().isLoaded(sm, this.fmd.getAbsoluteFieldNumber());
        Collection value = (Collection)sm.provideField(this.fmd.getAbsoluteFieldNumber());
        if (value == null) {
            return;
        }
        boolean isDependentElement = this.fmd.getCollection().isDependentElement();
        boolean hasJoin = this.fmd.getJoinMetaData() != null;
        boolean hasFK = false;
        if (!hasJoin) {
            if (this.fmd.getElementMetaData() != null && this.fmd.getElementMetaData().getForeignKeyMetaData() != null) {
                hasFK = true;
            } else if (this.fmd.getForeignKeyMetaData() != null) {
                hasFK = true;
            }
            AbstractMemberMetaData[] relatedMmds = this.fmd.getRelatedMemberMetaData(sm.getObjectManager().getClassLoaderResolver());
            if (relatedMmds != null && relatedMmds[0].getForeignKeyMetaData() != null) {
                hasFK = true;
            }
        }
        if (sm.getObjectManager().getOMFContext().getPersistenceConfiguration().getStringProperty("datanucleus.deletionPolicy").equals("JDO2")) {
            hasFK = false;
        }
        if (isDependentElement || hasJoin || !hasFK) {
            if (!(value instanceof SCO)) {
                value = (Collection)sm.wrapSCOField(this.fmd.getAbsoluteFieldNumber(), (Object)value, false, false, true);
            }
            value.clear();
            ((SCOCollection)value).flush();
        }
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        if (this.containerIsStoredInSingleColumn()) {
            throw new NucleusUserException(JavaTypeMapping.LOCALISER.msg("041025", (Object)this.fmd.getFullFieldName())).setFatal();
        }
        if (value instanceof Queryable) {
            return new CollectionSubqueryExpression(qs, ((Queryable)value).newQueryStatement());
        }
        return new CollectionLiteral(qs, (JavaTypeMapping)this, (Collection)value);
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        if (this.containerIsStoredInSingleColumn()) {
            throw new NucleusUserException(JavaTypeMapping.LOCALISER.msg("041025", (Object)this.fmd.getFullFieldName())).setFatal();
        }
        return new CollectionExpression(qs, this.datastoreContainer.getIDMapping(), te, (CollectionStore)this.storeMgr.getBackingStoreForField(qs.getClassLoaderResolver(), this.fmd, null), this.fieldName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

