/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import org.datanucleus.store.mapped.expression.BooleanCharColumnLiteral;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.CharacterExpression;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.NullLiteral;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.query.StatementText;

public class BooleanCharColumnExpression
extends BooleanExpression {
    private boolean truthTest;
    private StatementText booleanCondition = new StatementText();

    public BooleanCharColumnExpression(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression te) {
        this(qs, mapping, te, true);
    }

    public BooleanCharColumnExpression(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression te, boolean truthTest) {
        super(qs, mapping, te);
        this.truthTest = truthTest;
        this.booleanCondition.append(" = ").append(new BooleanCharColumnLiteral(qs, mapping, truthTest));
        this.lowestOperator = ScalarExpression.OP_EQ;
    }

    public BooleanExpression not() {
        return new BooleanCharColumnExpression(this.qs, this.mapping, this.te, !this.truthTest);
    }

    public BooleanExpression eq(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.eq(new CharacterExpression(this.qs, this.mapping, this.te));
        }
        if (expr instanceof BooleanCharColumnExpression) {
            return new BooleanExpression(new CharacterExpression(this.qs, this.mapping, this.te), ScalarExpression.OP_EQ, new CharacterExpression(this.qs, expr.mapping, expr.te));
        }
        return super.eq(expr);
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.noteq(new CharacterExpression(this.qs, this.mapping, this.te));
        }
        if (expr instanceof BooleanCharColumnExpression) {
            return new BooleanExpression(new CharacterExpression(this.qs, this.mapping, this.te), ScalarExpression.OP_NOTEQ, new CharacterExpression(this.qs, expr.mapping, expr.te));
        }
        return super.noteq(expr);
    }

    public BooleanExpression in(ScalarExpression expr) {
        return new BooleanExpression(new CharacterExpression(this.qs, this.mapping, this.te), ScalarExpression.OP_IN, expr);
    }

    public StatementText toStatementText(int mode) {
        StatementText st = super.toStatementText(mode);
        if (mode == ScalarExpression.FILTER) {
            st.append(this.booleanCondition, mode);
        }
        return st;
    }
}

