/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.expression.BooleanCharColumnExpression;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.CharacterExpression;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.ObjectExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.query.StatementText;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.query.QueryStatement;

public class OracleQueryStatement
extends QueryStatement {
    private String nlsSortOrder = "LATIN";

    public OracleQueryStatement(DatastoreContainerObject initialTable, ClassLoaderResolver clr) {
        this(initialTable, null, clr);
    }

    public OracleQueryStatement(DatastoreContainerObject initialTable, DatastoreIdentifier alias, ClassLoaderResolver clr) {
        super(initialTable, alias, clr);
        String sortOrder = this.storeMgr.getOMFContext().getPersistenceConfiguration().getStringProperty("datanucleus.rdbms.oracleNlsSortOrder");
        if (sortOrder != null) {
            this.nlsSortOrder = sortOrder.toUpperCase();
        }
        this.stmtJoinsSeparator = (char)44;
    }

    protected StatementText generateOrderingStatement() {
        StatementText orderByStmt = null;
        if (this.orderingExpressions != null && this.orderingExpressions.length > 0) {
            RDBMSAdapter dba = (RDBMSAdapter)this.storeMgr.getDatastoreAdapter();
            orderByStmt = new StatementText();
            boolean needsSelect = dba.supportsOption("IncludeOrderByColumnsInSelect");
            for (int i = 0; i < this.orderingExpressions.length; ++i) {
                String orderExpr = "JPOXORDER" + i;
                if (i > 0) {
                    orderByStmt.append(',');
                }
                if (needsSelect && !this.hasAggregateExpression) {
                    if (this.orderingExpressions[i] instanceof CharacterExpression && !this.nlsSortOrder.equals("BINARY")) {
                        orderByStmt.append("NLSSORT(").append(orderExpr).append(", 'NLS_SORT = ").append(this.nlsSortOrder).append("')");
                    } else {
                        if (this.orderingExpressions[i] instanceof BooleanExpression && !(this.orderingExpressions[i] instanceof BooleanCharColumnExpression)) {
                            throw new NucleusException(QueryStatement.LOCALISER.msg("052505")).setFatal();
                        }
                        orderByStmt.append(orderExpr);
                    }
                } else if (this.orderingExpressions[i] instanceof CharacterExpression && !this.nlsSortOrder.equals("BINARY")) {
                    orderByStmt.append("NLSSORT(").append(this.orderingExpressions[i].toStatementText(ScalarExpression.PROJECTION).toStatementString(ScalarExpression.PROJECTION)).append(", 'NLS_SORT = ").append(this.nlsSortOrder).append("')");
                } else {
                    if (this.orderingExpressions[i] instanceof BooleanExpression && !(this.orderingExpressions[i] instanceof BooleanCharColumnExpression)) {
                        throw new NucleusException(QueryStatement.LOCALISER.msg("052505")).setFatal();
                    }
                    orderByStmt.append(this.orderingExpressions[i].toStatementText(ScalarExpression.PROJECTION).toStatementString(ScalarExpression.PROJECTION));
                }
                if (!this.orderingDirections[i]) continue;
                orderByStmt.append(" DESC");
            }
        }
        return orderByStmt;
    }

    public void innerJoin(ScalarExpression expr, ScalarExpression expr2, LogicSetExpression tblExpr) {
        this.assertNotFrozen();
        QueryStatement.Join join = new QueryStatement.Join(expr, expr2, tblExpr);
        if (tblExpr.equals(this.getMainTableExpression())) {
            this.andCondition(expr.eq(expr2));
            return;
        }
        if (this.crossJoins.contains(tblExpr)) {
            this.crossJoins.remove(tblExpr);
        }
        if (this.joinsToTableAliases.contains(tblExpr.getAlias())) {
            return;
        }
        this.joinsToTableAliases.add(tblExpr.getAlias());
        this.joins.add(join);
        this.andCondition(expr.eq(expr2));
    }

    public void leftOuterJoin(ScalarExpression expr, ScalarExpression expr2, LogicSetExpression tblExpr) {
        this.assertNotFrozen();
        QueryStatement.Join join = new QueryStatement.Join(expr, expr2, tblExpr);
        if (this.joinsToTableAliases.contains(tblExpr.getAlias())) {
            return;
        }
        this.joinsToTableAliases.add(tblExpr.getAlias());
        this.joins.add(join);
        if (expr2 instanceof ObjectExpression) {
            ((ObjectExpression)expr2).addOuterJoinSuffix("(+)");
        }
        this.andCondition(expr.eq(expr2));
    }

    public void rightOuterJoin(ScalarExpression expr, ScalarExpression expr2, LogicSetExpression tblExpr) {
        this.assertNotFrozen();
        QueryStatement.Join join = new QueryStatement.Join(expr, expr2, tblExpr);
        if (this.joinsToTableAliases.contains(tblExpr.getAlias())) {
            return;
        }
        this.joinsToTableAliases.add(tblExpr.getAlias());
        this.joins.add(join);
        if (expr instanceof ObjectExpression) {
            ((ObjectExpression)expr).addOuterJoinSuffix("(+)");
        }
        this.andCondition(expr.eq(expr2));
    }
}

