/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.table;

import java.util.ArrayList;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ColumnMetaDataContainer;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.store.exceptions.NoTableManagedException;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.CorrespondentColumnsMapper;
import org.datanucleus.store.mapped.mapping.InterfaceMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.mapped.mapping.SerialisedPCMapping;
import org.datanucleus.store.mapped.mapping.SerialisedReferenceMapping;
import org.datanucleus.store.rdbms.exceptions.DuplicateColumnNameException;
import org.datanucleus.store.rdbms.sqlidentifier.RDBMSIdentifierFactory;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public final class ColumnCreator {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)(class$org$datanucleus$store$rdbms$RDBMSManager == null ? (class$org$datanucleus$store$rdbms$RDBMSManager = ColumnCreator.class$("org.datanucleus.store.rdbms.RDBMSManager")) : class$org$datanucleus$store$rdbms$RDBMSManager).getClassLoader());
    static /* synthetic */ Class class$org$datanucleus$store$rdbms$RDBMSManager;

    private ColumnCreator() {
    }

    public static DatastoreField createIndexColumn(JavaTypeMapping mapping, MappedStoreManager storeMgr, ClassLoaderResolver clr, DatastoreContainerObject table, ColumnMetaData colmd, boolean pk) {
        DatastoreIdentifier identifier = null;
        identifier = colmd != null && colmd.getName() != null ? storeMgr.getIdentifierFactory().newDatastoreFieldIdentifier(colmd.getName()) : ((RDBMSIdentifierFactory)storeMgr.getIdentifierFactory()).newAdapterIndexFieldIdentifier();
        DatastoreField column = table.addDatastoreField(mapping.getType(), identifier, mapping, (MetaData)colmd);
        storeMgr.getMappingManager().createDatastoreMapping(mapping, storeMgr, column, mapping.getJavaType().getName());
        if (pk) {
            column.setAsPrimaryKey();
        }
        return column;
    }

    public static JavaTypeMapping createColumnsForJoinTables(Class javaType, AbstractMemberMetaData fmd, ColumnMetaData[] columnMetaData, MappedStoreManager storeMgr, DatastoreContainerObject table, boolean primaryKey, boolean nullable, boolean serialised, boolean embedded, int fieldRole, ClassLoaderResolver clr) {
        return ColumnCreator.createColumnsForField(javaType, null, table, storeMgr, fmd, primaryKey, nullable, serialised, embedded, fieldRole, columnMetaData, clr, false);
    }

    public static void createColumnsForFieldUsingSubclassTable(JavaTypeMapping mapping, DatastoreContainerObject table, AbstractMemberMetaData fmd, ClassLoaderResolver clr) {
        MappedStoreManager storeMgr = table.getStoreManager();
        AbstractClassMetaData refCmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(fmd.getType(), clr);
        if (refCmd.getInheritanceMetaData().getStrategyValue() != InheritanceStrategy.SUBCLASS_TABLE) {
            throw new NucleusUserException(LOCALISER.msg("020185", (Object)fmd.getFullFieldName()));
        }
        AbstractClassMetaData[] subclassCmds = storeMgr.getClassesManagingTableForClass(refCmd, clr);
        boolean pk = false;
        if (subclassCmds.length > 1) {
            pk = false;
        }
        boolean nullable = true;
        if (subclassCmds.length > 1) {
            nullable = true;
        }
        int colPos = 0;
        for (int i = 0; i < subclassCmds.length; ++i) {
            Class type = clr.classForName(subclassCmds[i].getFullClassName());
            DatastoreClass dc = storeMgr.getDatastoreClass(subclassCmds[i].getFullClassName(), clr);
            JavaTypeMapping m = dc.getIDMapping();
            ColumnMetaData[] columnMetaDataForType = null;
            if (fmd.getColumnMetaData() != null && fmd.getColumnMetaData().length > 0) {
                if (fmd.getColumnMetaData().length < colPos + m.getNumberOfDatastoreFields()) {
                    throw new NucleusUserException(LOCALISER.msg("020186", (Object)fmd.getFullFieldName(), (Object)("" + fmd.getColumnMetaData().length), (Object)("" + (colPos + m.getNumberOfDatastoreFields()))));
                }
                columnMetaDataForType = new ColumnMetaData[m.getNumberOfDatastoreFields()];
                System.arraycopy(fmd.getColumnMetaData(), colPos, columnMetaDataForType, 0, columnMetaDataForType.length);
                colPos += columnMetaDataForType.length;
            }
            ColumnCreator.createColumnsForField(type, mapping, table, storeMgr, fmd, pk, nullable, false, false, 2, columnMetaDataForType, clr, true);
            if (!NucleusLogger.DATASTORE.isInfoEnabled()) continue;
            NucleusLogger.DATASTORE.info((Object)LOCALISER.msg("020187", (Object)type, (Object)fmd.getName()));
        }
    }

    public static void createColumnsForFieldUsingReference(ReferenceMapping mapping, DatastoreContainerObject table, AbstractMemberMetaData fmd, ClassLoaderResolver clr, boolean embedded) {
        ColumnCreator.createColumnsForReferenceField(mapping, table, fmd, false, true, false, embedded, 2, fmd.getColumnMetaData(), clr);
    }

    private static void createColumnsForReferenceField(ReferenceMapping mapping, DatastoreContainerObject table, AbstractMemberMetaData fmd, boolean isPrimaryKey, boolean isNullable, boolean serialised, boolean embedded, int fieldRole, ColumnMetaData[] columnMetaData, ClassLoaderResolver clr) {
        String[] implTypes = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(fmd, fieldRole, clr);
        String fieldTypeName = fmd.getTypeName();
        if (fmd.getFieldTypes() != null && fmd.getFieldTypes().length == 1) {
            fieldTypeName = fmd.getFieldTypes()[0];
        }
        if (fmd.hasCollection()) {
            fieldTypeName = fmd.getCollection().getElementType();
        } else if (fmd.hasArray()) {
            fieldTypeName = fmd.getArray().getElementType();
        } else if (fmd.hasMap()) {
            if (fieldRole == 5) {
                fieldTypeName = fmd.getMap().getKeyType();
            } else if (fieldRole == 6) {
                fieldTypeName = fmd.getMap().getValueType();
            }
        }
        MappedStoreManager storeMgr = table.getStoreManager();
        boolean isPersistentInterfaceField = storeMgr.getOMFContext().getMetaDataManager().isPersistentInterface(fieldTypeName);
        boolean pk = isPrimaryKey;
        boolean nullable = isNullable;
        if (implTypes.length > 1) {
            pk = false;
        }
        if (implTypes.length > 1 && !pk) {
            nullable = true;
        }
        ArrayList<Class> implClasses = new ArrayList<Class>();
        for (int i = 0; i < implTypes.length; ++i) {
            Class type = clr.classForName(implTypes[i]);
            if (type == null) {
                throw new NucleusUserException(LOCALISER.msg("020189", (Object)fmd.getTypeName(), (Object)implTypes[i]));
            }
            if (type.isInterface()) {
                throw new NucleusUserException(LOCALISER.msg("020190", (Object)fmd.getFullFieldName(), (Object)fmd.getTypeName(), (Object)implTypes[i]));
            }
            Iterator iter = implClasses.iterator();
            boolean toBeAdded = true;
            Class clsToSwap = null;
            while (iter.hasNext()) {
                Class cls = (Class)iter.next();
                if (cls == type) {
                    toBeAdded = false;
                    break;
                }
                if (type.isAssignableFrom(cls)) {
                    clsToSwap = cls;
                    toBeAdded = false;
                    break;
                }
                if (!cls.isAssignableFrom(type)) continue;
                toBeAdded = false;
                break;
            }
            if (toBeAdded) {
                implClasses.add(type);
                continue;
            }
            if (clsToSwap == null) continue;
            implClasses.remove(clsToSwap);
            implClasses.add(type);
        }
        int colPos = 0;
        Iterator implClsIter = implClasses.iterator();
        while (implClsIter.hasNext()) {
            JavaTypeMapping m;
            Class implClass = (Class)implClsIter.next();
            boolean present = false;
            int numJavaTypeMappings = mapping.getJavaTypeMapping().length;
            for (int i = 0; i < numJavaTypeMappings; ++i) {
                JavaTypeMapping implMapping = mapping.getJavaTypeMapping()[i];
                if (!implClass.getName().equals(implMapping.getType())) continue;
                present = true;
            }
            if (present) continue;
            boolean columnsNeeded = true;
            if (isPersistentInterfaceField && !storeMgr.getOMFContext().getMetaDataManager().isPersistentInterfaceImplementation(fieldTypeName, implClass.getName())) {
                columnsNeeded = false;
            }
            if (!columnsNeeded) continue;
            if (storeMgr.getMappedTypeManager().isSupportedMappedType(implClass.getName())) {
                m = storeMgr.getDatastoreAdapter().getMapping(implClass, storeMgr, serialised, embedded, fmd.getFullFieldName());
            } else {
                try {
                    DatastoreClass dc = storeMgr.getDatastoreClass(implClass.getName(), clr);
                    m = dc.getIDMapping();
                }
                catch (NoTableManagedException ex) {
                    throw new NucleusUserException("Cannot define columns for " + fmd.getFullFieldName() + " due to " + ex.getMessage(), (Throwable)ex);
                }
            }
            ColumnMetaData[] columnMetaDataForType = null;
            if (columnMetaData != null && columnMetaData.length > 0) {
                if (columnMetaData.length < colPos + m.getNumberOfDatastoreFields()) {
                    throw new NucleusUserException(LOCALISER.msg("020186", (Object)fmd.getFullFieldName(), (Object)("" + columnMetaData.length), (Object)("" + (colPos + m.getNumberOfDatastoreFields()))));
                }
                columnMetaDataForType = new ColumnMetaData[m.getNumberOfDatastoreFields()];
                System.arraycopy(columnMetaData, colPos, columnMetaDataForType, 0, columnMetaDataForType.length);
                colPos += columnMetaDataForType.length;
            }
            ColumnCreator.createColumnsForField(implClass, mapping, table, storeMgr, fmd, pk, nullable, serialised, embedded, fieldRole, columnMetaDataForType, clr, true);
            if (!NucleusLogger.DATASTORE.isInfoEnabled()) continue;
            NucleusLogger.DATASTORE.info((Object)LOCALISER.msg("020188", (Object)implClass, (Object)fmd.getName()));
        }
    }

    private static JavaTypeMapping createColumnsForField(Class javaType, JavaTypeMapping mapping, DatastoreContainerObject table, MappedStoreManager storeMgr, AbstractMemberMetaData fmd, boolean isPrimaryKey, boolean isNullable, boolean serialised, boolean embedded, int fieldRole, ColumnMetaData[] columnMetaData, ClassLoaderResolver clr, boolean isReferenceField) {
        if (mapping == null) {
            mapping = storeMgr.getDatastoreAdapter().getMapping(javaType, storeMgr, serialised, embedded, fmd != null ? fmd.getFullFieldName() : null);
        }
        if (mapping instanceof InterfaceMapping && fmd != null && fmd.hasExtension("implementation-classes")) {
            ((InterfaceMapping)mapping).setImplementationClasses(fmd.getValueForExtension("implementation-classes"));
        }
        IdentifierFactory idFactory = storeMgr.getIdentifierFactory();
        if (ClassUtils.isReferenceType((Class)javaType) && !serialised && !embedded) {
            ColumnCreator.createColumnsForReferenceField((ReferenceMapping)mapping, table, fmd, isPrimaryKey, isNullable, serialised, embedded, fieldRole, columnMetaData, clr);
        } else if (mapping instanceof ReferenceMapping || mapping instanceof SerialisedPCMapping || mapping instanceof SerialisedReferenceMapping || mapping instanceof PersistenceCapableMapping) {
            JavaTypeMapping container = mapping;
            if (mapping instanceof ReferenceMapping) {
                container = storeMgr.getDatastoreAdapter().getMapping(javaType, storeMgr, serialised, embedded, fmd != null ? fmd.getFullFieldName() : null);
                ((ReferenceMapping)mapping).addJavaTypeMapping(container);
            }
            if (container instanceof SerialisedPCMapping || container instanceof SerialisedReferenceMapping) {
                return mapping;
            }
            DatastoreClass destinationTable = storeMgr.getDatastoreClass(javaType.getName(), clr);
            if (destinationTable == null) {
                AbstractClassMetaData ownerCmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(javaType, clr);
                AbstractClassMetaData[] ownerCmds = storeMgr.getClassesManagingTableForClass(ownerCmd, clr);
                if (ownerCmds == null || ownerCmds.length == 0) {
                    throw new NucleusUserException(LOCALISER.msg("057023", (Object)javaType.getName())).setFatal();
                }
                destinationTable = storeMgr.getDatastoreClass(ownerCmds[0].getFullClassName(), clr);
            }
            if (destinationTable != null) {
                JavaTypeMapping m = destinationTable.getIDMapping();
                ColumnMetaDataContainer columnContainer = null;
                if (columnMetaData != null && columnMetaData.length > 0) {
                    columnContainer = (ColumnMetaDataContainer)columnMetaData[0].getParent();
                }
                CorrespondentColumnsMapper correspondentColumnsMapping = new CorrespondentColumnsMapper(columnContainer, columnMetaData, m, true);
                for (int i = 0; i < m.getNumberOfDatastoreFields(); ++i) {
                    JavaTypeMapping refDatastoreMapping = storeMgr.getDatastoreAdapter().getMapping(m.getDataStoreMapping(i).getJavaTypeMapping().getJavaType(), storeMgr);
                    ColumnMetaData colmd = correspondentColumnsMapping.getColumnMetaDataByIdentifier(m.getDataStoreMapping(i).getDatastoreField().getIdentifier());
                    try {
                        DatastoreIdentifier identifier = null;
                        if (colmd.getName() == null) {
                            if (isReferenceField) {
                                identifier = idFactory.newReferenceFieldIdentifier(fmd, storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(javaType, clr), m.getDataStoreMapping(i).getDatastoreField().getIdentifier(), storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(javaType), fieldRole);
                            } else {
                                AbstractMemberMetaData[] relatedMmds = fmd.getRelatedMemberMetaData(clr);
                                identifier = ((RDBMSIdentifierFactory)idFactory).newJoinTableFieldIdentifier(fmd, relatedMmds != null ? relatedMmds[0] : null, m.getDataStoreMapping(i).getDatastoreField().getIdentifier(), storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(javaType), fieldRole);
                            }
                        } else {
                            identifier = idFactory.newDatastoreFieldIdentifier(colmd.getName());
                        }
                        DatastoreField column = table.addDatastoreField(javaType.getName(), identifier, refDatastoreMapping, (MetaData)colmd);
                        ((Column)m.getDataStoreMapping(i).getDatastoreField()).copyConfigurationTo(column);
                        if (isPrimaryKey) {
                            column.setAsPrimaryKey();
                        }
                        if (isNullable) {
                            column.setNullable();
                        }
                        storeMgr.getMappingManager().createDatastoreMapping(refDatastoreMapping, storeMgr, column, m.getDataStoreMapping(i).getJavaTypeMapping().getJavaTypeForDatastoreMapping(i));
                    }
                    catch (DuplicateColumnNameException ex) {
                        throw new NucleusUserException("Cannot create column for field " + fmd.getFullFieldName() + " column metadata " + colmd, (Throwable)((Object)ex));
                    }
                    ((PersistenceCapableMapping)container).addJavaTypeMapping(refDatastoreMapping);
                }
            }
        } else {
            DatastoreField column = null;
            ColumnMetaData colmd = null;
            if (columnMetaData != null && columnMetaData.length > 0) {
                colmd = columnMetaData[0];
            }
            DatastoreIdentifier identifier = null;
            identifier = colmd != null && colmd.getName() != null ? idFactory.newDatastoreFieldIdentifier(colmd.getName()) : ((RDBMSIdentifierFactory)idFactory).newJoinTableFieldIdentifier(fmd, null, null, storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(javaType), fieldRole);
            column = table.addDatastoreField(javaType.getName(), identifier, mapping, (MetaData)colmd);
            storeMgr.getMappingManager().createDatastoreMapping(mapping, storeMgr, column, mapping.getJavaTypeForDatastoreMapping(0));
            if (isNullable) {
                column.setNullable();
            }
        }
        return mapping;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

