/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping;

import org.datanucleus.store.exceptions.UnsupportedDataTypeException;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;

public abstract class ColumnMapping
extends RDBMSMapping {
    protected Column column;

    public ColumnMapping(MappedStoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public boolean isDecimalBased() {
        return false;
    }

    public boolean isIntegerBased() {
        return false;
    }

    public boolean isStringBased() {
        return false;
    }

    public boolean isBitBased() {
        return false;
    }

    public boolean isBooleanBased() {
        return false;
    }

    public boolean isNullable() {
        if (this.column != null) {
            return this.column.isNullable();
        }
        return true;
    }

    public DatastoreField getDatastoreField() {
        return this.column;
    }

    protected void initTypeInfo() {
        SQLTypeInfo typeInfo = this.getTypeInfo();
        if (typeInfo == null) {
            throw new UnsupportedDataTypeException(RDBMSMapping.LOCALISER.msg("055000", (Object)this.column));
        }
        if (this.column != null) {
            this.column.setTypeInfo(typeInfo);
        }
    }

    public Column getColumn() {
        return this.column;
    }

    public boolean includeInFetchStatement() {
        return true;
    }

    public String getInsertionInputParameter() {
        return this.column.getWrapperFunction(1);
    }

    public String getUpdateInputParameter() {
        return this.column.getWrapperFunction(2);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ColumnMapping)) {
            return false;
        }
        ColumnMapping cm = (ColumnMapping)obj;
        return this.getClass().equals(cm.getClass()) && ((Object)((Object)this.storeMgr)).equals((Object)cm.storeMgr) && (this.column == null ? cm.column == null : this.column.equals(cm.column));
    }

    public int hashCode() {
        return ((Object)((Object)this.storeMgr)).hashCode() ^ (this.column == null ? 0 : this.column.hashCode());
    }
}

