/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.fieldmanager;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistableObjectType;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.exceptions.ReachableObjectNotCascadedException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.metadata.ValueGenerationStrategy;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.fieldmanager.AbstractStoreFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.mongodb.fieldmanager.StoreEmbeddedFieldManager;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class StoreFieldManager
extends AbstractStoreFieldManager {
    protected Table table;
    protected DBObject dbObject;
    protected AbstractMemberMetaData ownerMmd = null;

    public StoreFieldManager(DNStateManager sm, DBObject dbObject, boolean insert, Table table) {
        super(sm, insert);
        this.table = table;
        this.dbObject = dbObject;
    }

    protected MemberColumnMapping getColumnMapping(int fieldNumber) {
        return this.table.getMemberColumnMappingForMember(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.dbObject.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), (Object)value);
    }

    public void storeCharField(int fieldNumber, char value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.dbObject.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), (Object)("" + value));
    }

    public void storeByteField(int fieldNumber, byte value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.dbObject.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), (Object)value);
    }

    public void storeShortField(int fieldNumber, short value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.dbObject.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), (Object)value);
    }

    public void storeIntField(int fieldNumber, int value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.dbObject.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), (Object)value);
    }

    public void storeLongField(int fieldNumber, long value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.dbObject.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), (Object)value);
    }

    public void storeFloatField(int fieldNumber, float value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.dbObject.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), (Object)Float.valueOf(value));
    }

    public void storeDoubleField(int fieldNumber, double value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.dbObject.put(this.getColumnMapping(fieldNumber).getColumn(0).getName(), (Object)value);
    }

    public void storeStringField(int fieldNumber, String value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (!this.isStorable(mmd)) {
            return;
        }
        if (mmd.getValueStrategy() == ValueGenerationStrategy.IDENTITY) {
            return;
        }
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        if (mapping.getTypeConverter() != null) {
            Object datastoreValue = mapping.getTypeConverter().toDatastoreType((Object)value);
            if (mapping.getNumberOfColumns() > 1) {
                for (int i = 0; i < mapping.getNumberOfColumns(); ++i) {
                    this.dbObject.put(mapping.getColumn(i).getName(), MongoDBUtils.getAcceptableDatastoreValue(Array.get(datastoreValue, i)));
                }
            } else {
                this.dbObject.put(mapping.getColumn(0).getName(), MongoDBUtils.getAcceptableDatastoreValue(datastoreValue));
            }
        } else {
            String fieldName = this.getColumnMapping(fieldNumber).getColumn(0).getName();
            if (value == null) {
                this.dbObject.removeField(fieldName);
                return;
            }
            this.dbObject.put(fieldName, (Object)value);
        }
    }

    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (!this.isStorable(mmd)) {
            return;
        }
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        RelationType relationType = mmd.getRelationType(clr);
        StoreManager storeMgr = this.ec.getStoreManager();
        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(this.ec.getMetaDataManager(), clr, mmd, relationType, this.ownerMmd)) {
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                if (!(mmd.isCascadePersist() || this.ec.getApiAdapter().isDetached(value) || this.ec.getApiAdapter().isPersistent(value))) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007006", (Object[])new Object[]{mmd.getFullFieldName()}));
                    }
                    throw new ReachableObjectNotCascadedException(mmd.getFullFieldName(), value);
                }
                boolean nested = MongoDBUtils.isMemberNested(mmd);
                if (nested && this.ownerMmd != null && (RelationType.isBidirectional((RelationType)relationType) ? this.ownerMmd.getMappedBy() != null && mmd.getName().equals(this.ownerMmd.getMappedBy()) || mmd.getMappedBy() != null && this.ownerMmd.getName().equals(mmd.getMappedBy()) : (this.ownerMmd.hasCollection() ? this.ownerMmd.getElementMetaData().getEmbeddedMetaData() != null && this.ownerMmd.getElementMetaData().getEmbeddedMetaData().getOwnerMember() != null && this.ownerMmd.getElementMetaData().getEmbeddedMetaData().getOwnerMember().equals(mmd.getName()) : this.ownerMmd.getEmbeddedMetaData() != null && this.ownerMmd.getEmbeddedMetaData().getOwnerMember() != null && this.ownerMmd.getEmbeddedMetaData().getOwnerMember().equals(mmd.getName())))) {
                    return;
                }
                if (value == null) {
                    if (nested) {
                        for (int i = 0; i < mapping.getNumberOfColumns(); ++i) {
                            this.dbObject.removeField(mapping.getColumn(i).getName());
                        }
                        return;
                    }
                    return;
                }
                AbstractClassMetaData embcmd = this.ec.getMetaDataManager().getMetaDataForClass(value.getClass(), clr);
                if (embcmd == null) {
                    throw new NucleusUserException("Field " + mmd.getFullFieldName() + " specified as embedded but metadata not found for the class of type " + mmd.getTypeName());
                }
                DNStateManager embSM = this.ec.findStateManagerForEmbedded(value, this.sm, mmd, null);
                DBObject embeddedObject = this.dbObject;
                if (nested) {
                    embeddedObject = new BasicDBObject();
                }
                if (embcmd.hasDiscriminatorStrategy()) {
                    String discPropName = null;
                    discPropName = mmd.getEmbeddedMetaData() != null && mmd.getEmbeddedMetaData().getDiscriminatorMetaData() != null ? mmd.getEmbeddedMetaData().getDiscriminatorMetaData().getColumnName() : storeMgr.getNamingFactory().getColumnName(embcmd, ColumnType.DISCRIMINATOR_COLUMN);
                    embeddedObject.put(discPropName, embcmd.getDiscriminatorValue());
                }
                ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
                embMmds.add(mmd);
                StoreEmbeddedFieldManager ffm = new StoreEmbeddedFieldManager(embSM, embeddedObject, this.insert, embMmds, this.table);
                embSM.provideFields(embcmd.getAllMemberPositions(), (FieldManager)ffm);
                if (nested) {
                    this.dbObject.put(mapping.getColumn(0).getName(), (Object)embeddedObject);
                }
                return;
            }
            if (RelationType.isRelationMultiValued((RelationType)relationType)) {
                if (value == null) {
                    for (int i = 0; i < mapping.getNumberOfColumns(); ++i) {
                        this.dbObject.removeField(mapping.getColumn(i).getName());
                    }
                    return;
                }
                if (mmd.hasCollection()) {
                    AbstractClassMetaData embcmd = mmd.getCollection().getElementClassMetaData(clr);
                    ArrayList<BasicDBObject> coll = new ArrayList<BasicDBObject>();
                    Collection valueColl = (Collection)value;
                    for (Object element : valueColl) {
                        DNStateManager embSM;
                        String embClassName;
                        StoreData sd;
                        if (!element.getClass().getName().equals(embcmd.getFullClassName())) {
                            embcmd = this.ec.getMetaDataManager().getMetaDataForClass(element.getClass(), clr);
                        }
                        BasicDBObject embeddedObject = new BasicDBObject();
                        if (embcmd.hasDiscriminatorStrategy()) {
                            String discPropName = null;
                            discPropName = mmd.getEmbeddedMetaData() != null && mmd.getEmbeddedMetaData().getDiscriminatorMetaData() != null ? mmd.getEmbeddedMetaData().getDiscriminatorMetaData().getColumnName() : storeMgr.getNamingFactory().getColumnName(embcmd, ColumnType.DISCRIMINATOR_COLUMN);
                            embeddedObject.put((Object)discPropName, embcmd.getDiscriminatorValue());
                        }
                        if ((sd = storeMgr.getStoreDataForClass(embClassName = (embSM = this.ec.findStateManagerForEmbedded(element, this.sm, mmd, PersistableObjectType.EMBEDDED_COLLECTION_ELEMENT_PC)).getClassMetaData().getFullClassName())) == null) {
                            storeMgr.manageClasses(clr, new String[]{embClassName});
                            sd = storeMgr.getStoreDataForClass(embClassName);
                        }
                        Table elemTable = sd.getTable();
                        StoreFieldManager sfm = new StoreFieldManager(embSM, (DBObject)embeddedObject, this.insert, elemTable);
                        sfm.ownerMmd = mmd;
                        embSM.provideFields(embcmd.getAllMemberPositions(), (FieldManager)sfm);
                        coll.add(embeddedObject);
                    }
                    this.dbObject.put(mapping.getColumn(0).getName(), coll);
                    return;
                }
                if (mmd.hasArray()) {
                    AbstractClassMetaData embcmd = mmd.getArray().getElementClassMetaData(clr);
                    Object[] array = new Object[Array.getLength(value)];
                    for (int i = 0; i < array.length; ++i) {
                        DNStateManager embSM;
                        String embClassName;
                        StoreData sd;
                        Object element = Array.get(value, i);
                        if (!element.getClass().getName().equals(embcmd.getFullClassName())) {
                            embcmd = this.ec.getMetaDataManager().getMetaDataForClass(element.getClass(), clr);
                        }
                        BasicDBObject embeddedObject = new BasicDBObject();
                        if (embcmd.hasDiscriminatorStrategy()) {
                            String discPropName = null;
                            discPropName = mmd.getEmbeddedMetaData() != null && mmd.getEmbeddedMetaData().getDiscriminatorMetaData() != null ? mmd.getEmbeddedMetaData().getDiscriminatorMetaData().getColumnName() : storeMgr.getNamingFactory().getColumnName(embcmd, ColumnType.DISCRIMINATOR_COLUMN);
                            embeddedObject.put((Object)discPropName, embcmd.getDiscriminatorValue());
                        }
                        if ((sd = storeMgr.getStoreDataForClass(embClassName = (embSM = this.ec.findStateManagerForEmbedded(element, this.sm, mmd, PersistableObjectType.EMBEDDED_ARRAY_ELEMENT_PC)).getClassMetaData().getFullClassName())) == null) {
                            storeMgr.manageClasses(clr, new String[]{embClassName});
                            sd = storeMgr.getStoreDataForClass(embClassName);
                        }
                        Table elemTable = sd.getTable();
                        StoreFieldManager sfm = new StoreFieldManager(embSM, (DBObject)embeddedObject, this.insert, elemTable);
                        sfm.ownerMmd = mmd;
                        embSM.provideFields(embcmd.getAllMemberPositions(), (FieldManager)sfm);
                        array[i] = embeddedObject;
                    }
                    this.dbObject.put(mapping.getColumn(0).getName(), (Object)array);
                    return;
                }
                AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(clr);
                AbstractClassMetaData valCmd = mmd.getMap().getValueClassMetaData(clr);
                ArrayList<BasicDBObject> entryList = new ArrayList<BasicDBObject>();
                Map valueMap = (Map)value;
                for (Map.Entry entry : valueMap.entrySet()) {
                    StoreFieldManager sfm;
                    StoreData sd;
                    String discPropName;
                    DNStateManager embSM;
                    BasicDBObject entryObj = new BasicDBObject();
                    if (keyCmd == null) {
                        this.processContainerNonRelationField("key", this.ec, entry.getKey(), (DBObject)entryObj, mmd, mapping, FieldRole.ROLE_MAP_KEY);
                    } else {
                        String keyClassName;
                        embSM = this.ec.findStateManagerForEmbedded(entry.getKey(), this.sm, mmd, PersistableObjectType.EMBEDDED_MAP_KEY_PC);
                        BasicDBObject embeddedKey = new BasicDBObject();
                        if (keyCmd.hasDiscriminatorStrategy()) {
                            discPropName = null;
                            discPropName = mmd.getEmbeddedMetaData() != null && mmd.getEmbeddedMetaData().getDiscriminatorMetaData() != null ? mmd.getEmbeddedMetaData().getDiscriminatorMetaData().getColumnName() : storeMgr.getNamingFactory().getColumnName(keyCmd, ColumnType.DISCRIMINATOR_COLUMN);
                            embeddedKey.put((Object)discPropName, keyCmd.getDiscriminatorValue());
                        }
                        if ((sd = storeMgr.getStoreDataForClass(keyClassName = embSM.getClassMetaData().getFullClassName())) == null) {
                            storeMgr.manageClasses(clr, new String[]{keyClassName});
                            sd = storeMgr.getStoreDataForClass(keyClassName);
                        }
                        Table keyTable = sd.getTable();
                        sfm = new StoreFieldManager(embSM, (DBObject)embeddedKey, this.insert, keyTable);
                        sfm.ownerMmd = mmd;
                        embSM.provideFields(embSM.getClassMetaData().getAllMemberPositions(), (FieldManager)sfm);
                        entryObj.append("key", (Object)embeddedKey);
                    }
                    if (valCmd == null) {
                        this.processContainerNonRelationField("value", this.ec, entry.getValue(), (DBObject)entryObj, mmd, mapping, FieldRole.ROLE_MAP_VALUE);
                    } else {
                        String valClassName;
                        embSM = this.ec.findStateManagerForEmbedded(entry.getValue(), this.sm, mmd, PersistableObjectType.EMBEDDED_MAP_VALUE_PC);
                        BasicDBObject embeddedVal = new BasicDBObject();
                        if (valCmd.hasDiscriminatorStrategy()) {
                            discPropName = null;
                            discPropName = mmd.getEmbeddedMetaData() != null && mmd.getEmbeddedMetaData().getDiscriminatorMetaData() != null ? mmd.getEmbeddedMetaData().getDiscriminatorMetaData().getColumnName() : storeMgr.getNamingFactory().getColumnName(valCmd, ColumnType.DISCRIMINATOR_COLUMN);
                            embeddedVal.put((Object)discPropName, valCmd.getDiscriminatorValue());
                        }
                        if ((sd = storeMgr.getStoreDataForClass(valClassName = embSM.getClassMetaData().getFullClassName())) == null) {
                            storeMgr.manageClasses(clr, new String[]{valClassName});
                            sd = storeMgr.getStoreDataForClass(valClassName);
                        }
                        Table valTable = sd.getTable();
                        sfm = new StoreFieldManager(embSM, (DBObject)embeddedVal, this.insert, valTable);
                        sfm.ownerMmd = mmd;
                        embSM.provideFields(embSM.getClassMetaData().getAllMemberPositions(), (FieldManager)sfm);
                        entryObj.append("value", (Object)embeddedVal);
                    }
                    entryList.add(entryObj);
                }
                this.dbObject.put(mapping.getColumn(0).getName(), entryList);
                return;
            }
        }
        this.storeNonEmbeddedObjectField(mmd, relationType, clr, value);
    }

    protected void storeNonEmbeddedObjectField(AbstractMemberMetaData mmd, RelationType relationType, ClassLoaderResolver clr, Object value) {
        byte[] bytes;
        int fieldNumber = mmd.getAbsoluteFieldNumber();
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        if (value instanceof Optional) {
            Optional opt;
            if (relationType != RelationType.NONE) {
                relationType = RelationType.ONE_TO_ONE_UNI;
            }
            value = (opt = (Optional)value).isPresent() ? opt.get() : null;
        }
        if (value == null) {
            for (int i = 0; i < mapping.getNumberOfColumns(); ++i) {
                String colName = mapping.getColumn(i).getName();
                if (!this.dbObject.containsField(colName)) continue;
                this.dbObject.removeField(colName);
            }
            return;
        }
        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            if (!(mmd.isCascadePersist() || this.ec.getApiAdapter().isDetached(value) || this.ec.getApiAdapter().isPersistent(value))) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007006", (Object[])new Object[]{mmd.getFullFieldName()}));
                }
                throw new ReachableObjectNotCascadedException(mmd.getFullFieldName(), value);
            }
            if (mmd.isSerialized()) {
                DNStateManager pcSM = this.ec.findStateManager(value);
                if (pcSM == null || this.ec.getApiAdapter().getExecutionContext(value) == null) {
                    pcSM = this.ec.getNucleusContext().getStateManagerFactory().newForEmbedded(this.ec, value, false, this.sm, fieldNumber, PersistableObjectType.EMBEDDED_PC);
                }
                if (pcSM != null) {
                    pcSM.setStoringPC();
                }
                byte[] bytes2 = MongoDBUtils.getStoredValueForJavaSerialisedField(mmd, value);
                this.dbObject.put(mapping.getColumn(0).getName(), (Object)bytes2);
                if (pcSM != null) {
                    pcSM.unsetStoringPC();
                }
                return;
            }
            this.processSingleRelationField(value, mapping.getColumn(0).getName());
        } else if (RelationType.isRelationMultiValued((RelationType)relationType)) {
            if (mmd.isSerialized()) {
                bytes = MongoDBUtils.getStoredValueForJavaSerialisedField(mmd, value);
                this.dbObject.put(mapping.getColumn(0).getName(), (Object)bytes);
                SCOUtils.wrapSCOField((DNStateManager)this.sm, (int)fieldNumber, (Object)value, (boolean)true);
                return;
            }
            this.processContainerRelationField(mmd, mapping, value, this.ec, mapping.getColumn(0).getName());
            SCOUtils.wrapSCOField((DNStateManager)this.sm, (int)fieldNumber, (Object)value, (boolean)true);
        } else {
            if (mmd.isSerialized()) {
                bytes = MongoDBUtils.getStoredValueForJavaSerialisedField(mmd, value);
                this.dbObject.put(mapping.getColumn(0).getName(), (Object)bytes);
                SCOUtils.wrapSCOField((DNStateManager)this.sm, (int)fieldNumber, (Object)value, (boolean)true);
                return;
            }
            if (mapping.getTypeConverter() != null) {
                Object datastoreValue = mapping.getTypeConverter().toDatastoreType(value);
                if (mapping.getNumberOfColumns() > 1) {
                    for (int i = 0; i < mapping.getNumberOfColumns(); ++i) {
                        this.dbObject.put(mapping.getColumn(i).getName(), MongoDBUtils.getAcceptableDatastoreValue(Array.get(datastoreValue, i)));
                    }
                } else {
                    this.dbObject.put(mapping.getColumn(0).getName(), MongoDBUtils.getAcceptableDatastoreValue(datastoreValue));
                }
            } else {
                this.processContainerNonRelationField(mapping.getColumn(0).getName(), this.ec, value, this.dbObject, mmd, mapping, FieldRole.ROLE_FIELD);
            }
            SCOUtils.wrapSCOField((DNStateManager)this.sm, (int)fieldNumber, (Object)value, (boolean)true);
        }
    }

    protected void processSingleRelationField(Object value, String fieldName) {
        Object valuePC = this.ec.persistObjectInternal(value, null, PersistableObjectType.PC, null, -1);
        Object valueId = this.ec.getApiAdapter().getIdForObject(valuePC);
        this.dbObject.put(fieldName, (Object)IdentityUtils.getPersistableIdentityForId((Object)valueId));
    }

    protected void processContainerRelationField(AbstractMemberMetaData mmd, MemberColumnMapping mapping, Object value, ExecutionContext ec, String fieldName) {
        if (mmd.hasCollection()) {
            Collection coll = (Collection)value;
            if (!mmd.isCascadePersist()) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007006", (Object[])new Object[]{mmd.getFullFieldName()}));
                }
                for (Object element : coll) {
                    if (ec.getApiAdapter().isDetached(element) || ec.getApiAdapter().isPersistent(element)) continue;
                    throw new ReachableObjectNotCascadedException(mmd.getFullFieldName(), element);
                }
            }
            if (mmd.getCollection().isSerializedElement()) {
                throw new NucleusUserException("Don't currently support serialised collection elements at " + mmd.getFullFieldName() + " . Serialise the whole field");
            }
            ArrayList<String> collIds = new ArrayList<String>();
            for (Object element : coll) {
                if (element != null) {
                    Object elementPC = ec.persistObjectInternal(element, null, PersistableObjectType.PC, null, -1);
                    Object elementID = ec.getApiAdapter().getIdForObject(elementPC);
                    collIds.add(IdentityUtils.getPersistableIdentityForId((Object)elementID));
                    continue;
                }
                collIds.add("NULL");
            }
            this.dbObject.put(fieldName, collIds);
        } else if (mmd.hasMap()) {
            if (mmd.getMap().isSerializedKey() || mmd.getMap().isSerializedValue()) {
                throw new NucleusUserException("Don't currently support serialised map keys/values at " + mmd.getFullFieldName() + " . Serialise the whole field");
            }
            HashSet<BasicDBObject> collEntries = new HashSet<BasicDBObject>();
            Map map = (Map)value;
            for (Map.Entry entry : map.entrySet()) {
                Object pc;
                Object mapKey = entry.getKey();
                Object mapValue = entry.getValue();
                BasicDBObject entryObj = new BasicDBObject();
                if (ec.getApiAdapter().isPersistable(mapKey)) {
                    pc = ec.persistObjectInternal(mapKey, null, PersistableObjectType.PC, null, -1);
                    Object keyID = ec.getApiAdapter().getIdForObject(pc);
                    entryObj.append("key", (Object)IdentityUtils.getPersistableIdentityForId((Object)keyID));
                } else {
                    this.processContainerNonRelationField("key", ec, mapKey, (DBObject)entryObj, mmd, mapping, FieldRole.ROLE_MAP_KEY);
                }
                if (ec.getApiAdapter().isPersistable(mapValue)) {
                    pc = ec.persistObjectInternal(mapValue, null, PersistableObjectType.PC, null, -1);
                    Object valueID = ec.getApiAdapter().getIdForObject(pc);
                    entryObj.append("value", (Object)IdentityUtils.getPersistableIdentityForId((Object)valueID));
                } else {
                    this.processContainerNonRelationField("value", ec, mapValue, (DBObject)entryObj, mmd, mapping, FieldRole.ROLE_MAP_VALUE);
                }
                collEntries.add(entryObj);
            }
            this.dbObject.put(fieldName, collEntries);
        } else if (mmd.hasArray()) {
            if (mmd.getArray().isSerializedElement()) {
                throw new NucleusUserException("Don't currently support serialised array elements at " + mmd.getFullFieldName() + " . Serialise the whole field");
            }
            ArrayList<String> collIds = new ArrayList<String>();
            for (int i = 0; i < Array.getLength(value); ++i) {
                Object element = Array.get(value, i);
                if (element != null) {
                    Object elementPC = ec.persistObjectInternal(element, null, PersistableObjectType.PC, null, -1);
                    Object elementID = ec.getApiAdapter().getIdForObject(elementPC);
                    collIds.add(IdentityUtils.getPersistableIdentityForId((Object)elementID));
                    continue;
                }
                collIds.add("NULL");
            }
            this.dbObject.put(fieldName, collIds);
        }
    }

    protected void processContainerNonRelationField(String fieldName, ExecutionContext ec, Object value, DBObject dbObject, AbstractMemberMetaData mmd, MemberColumnMapping mapping, FieldRole fieldRole) {
        Object storeValue = MongoDBUtils.getStoredValueForField(ec, mmd, mapping, value, fieldRole);
        dbObject.put(fieldName, storeValue);
    }
}

