/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb;

import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.AbstractConnectionFactory;
import org.datanucleus.store.connection.AbstractEmulatedXAResource;
import org.datanucleus.store.connection.AbstractManagedConnection;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class ConnectionFactoryImpl
extends AbstractConnectionFactory {
    public static final String MONGODB_CONNECTIONS_PER_HOST = "datanucleus.mongodb.connectionsPerHost";
    public static final String MONGODB_THREAD_BLOCK_FOR_MULTIPLIER = "datanucleus.mongodb.threadsAllowedToBlockForConnectionMultiplier";
    String dbName = "DataNucleus";
    Mongo mongo;

    public ConnectionFactoryImpl(StoreManager storeMgr, String resourceType) {
        super(storeMgr, resourceType);
        String url = storeMgr.getConnectionURL();
        if (url == null) {
            throw new NucleusException("You haven't specified persistence property 'datanucleus.ConnectionURL' (or alias)");
        }
        String remains = url.substring(7).trim();
        if (remains.indexOf(58) == 0) {
            remains = remains.substring(1);
        }
        try {
            ArrayList<ServerAddress> serverAddrs = new ArrayList<ServerAddress>();
            if (remains.length() == 0) {
                serverAddrs.add(new ServerAddress());
            } else {
                StringTokenizer tokeniser = new StringTokenizer(remains, ",");
                boolean firstServer = true;
                while (tokeniser.hasMoreTokens()) {
                    String token = tokeniser.nextToken();
                    String serverName = "localhost";
                    if (firstServer) {
                        int dbNameSepPos = token.indexOf("/");
                        if (dbNameSepPos >= 0) {
                            String dbNameStr;
                            if (dbNameSepPos < token.length() && (dbNameStr = token.substring(dbNameSepPos + 1)).length() > 0) {
                                this.dbName = dbNameStr;
                            }
                            if (dbNameSepPos > 0) {
                                serverName = token.substring(0, dbNameSepPos);
                            }
                        } else if (token.length() > 0) {
                            serverName = token;
                        }
                    } else {
                        serverName = token;
                    }
                    ServerAddress addr = null;
                    int portSeparatorPos = serverName.indexOf(58);
                    addr = portSeparatorPos > 0 ? new ServerAddress(serverName.substring(0, portSeparatorPos), Integer.valueOf(serverName.substring(portSeparatorPos + 1)).intValue()) : new ServerAddress(serverName);
                    serverAddrs.add(addr);
                    firstServer = false;
                }
            }
            if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                NucleusLogger.CONNECTION.debug((Object)Localiser.msg((String)"MongoDB.ServerConnect", (Object[])new Object[]{this.dbName, serverAddrs.size(), StringUtils.collectionToString(serverAddrs)}));
            }
            this.mongo = serverAddrs.size() == 1 ? new MongoClient((ServerAddress)serverAddrs.get(0), this.getMongodbOptions(storeMgr)) : new MongoClient(serverAddrs, this.getMongodbOptions(storeMgr));
            NucleusLogger.CONNECTION.debug((Object)"Created MongoClient object");
        }
        catch (UnknownHostException e) {
            throw new NucleusDataStoreException("Unable to connect to mongodb", (Throwable)e);
        }
        catch (MongoException me) {
            throw new NucleusDataStoreException("Unable to connect to mongodb", (Throwable)me);
        }
    }

    private MongoClientOptions getMongodbOptions(StoreManager storeManager) {
        Object connectionsPerHost = storeManager.getProperty(MONGODB_CONNECTIONS_PER_HOST);
        Object threadsAllowedToBlockForConnectionMultiplier = storeManager.getProperty(MONGODB_THREAD_BLOCK_FOR_MULTIPLIER);
        MongoClientOptions.Builder mongoOptionsBuilder = MongoClientOptions.builder();
        if (connectionsPerHost != null) {
            mongoOptionsBuilder.connectionsPerHost(Integer.parseInt((String)connectionsPerHost));
        }
        if (threadsAllowedToBlockForConnectionMultiplier != null) {
            mongoOptionsBuilder.threadsAllowedToBlockForConnectionMultiplier(Integer.parseInt((String)threadsAllowedToBlockForConnectionMultiplier));
        }
        return mongoOptionsBuilder.build();
    }

    public void close() {
        NucleusLogger.CONNECTION.debug((Object)"Closing MongoClient object");
        this.mongo.close();
        super.close();
    }

    public ManagedConnection createManagedConnection(ExecutionContext ec, Map options) {
        return new ManagedConnectionImpl();
    }

    static class EmulatedXAResource
    extends AbstractEmulatedXAResource {
        DB db;

        EmulatedXAResource(ManagedConnectionImpl mconn, DB db) {
            super((ManagedConnection)mconn);
            this.db = db;
        }

        public void commit(Xid xid, boolean onePhase) throws XAException {
            super.commit(xid, onePhase);
            this.db.requestDone();
            ((ManagedConnectionImpl)this.mconn).startRequested = false;
        }

        public void rollback(Xid xid) throws XAException {
            super.rollback(xid);
            this.db.requestDone();
            ((ManagedConnectionImpl)this.mconn).startRequested = false;
        }
    }

    public class ManagedConnectionImpl
    extends AbstractManagedConnection {
        boolean startRequested = false;
        XAResource xaRes = null;

        public boolean closeAfterTransactionEnd() {
            return false;
        }

        public Object getConnection() {
            if (this.conn == null || !this.startRequested) {
                this.obtainNewConnection();
            }
            return this.conn;
        }

        protected void obtainNewConnection() {
            if (this.conn == null) {
                this.conn = ConnectionFactoryImpl.this.mongo.getDB(ConnectionFactoryImpl.this.dbName);
                NucleusLogger.CONNECTION.debug((Object)"Created DB from MongoClient");
                String userName = ConnectionFactoryImpl.this.storeMgr.getConnectionUserName();
                String password = ConnectionFactoryImpl.this.storeMgr.getConnectionPassword();
                if (!StringUtils.isWhitespace((String)userName)) {
                    boolean authenticated = false;
                    if (!((DB)this.conn).isAuthenticated() && !(authenticated = ((DB)this.conn).authenticate(userName, password.toCharArray()))) {
                        throw new NucleusDataStoreException("Authentication of the connection failed for datastore " + ConnectionFactoryImpl.this.dbName + " with user " + userName);
                    }
                }
                if (ConnectionFactoryImpl.this.storeMgr.getBooleanProperty("datanucleus.readOnlyDatastore", false)) {
                    ((DB)this.conn).setReadOnly(Boolean.TRUE);
                }
            }
            if (!this.startRequested) {
                ((DB)this.conn).requestStart();
                this.startRequested = true;
                NucleusLogger.CONNECTION.debug((Object)("ManagedConnection " + this.toString() + " is starting"));
            }
        }

        public void release() {
            if (this.commitOnRelease) {
                NucleusLogger.CONNECTION.debug((Object)("ManagedConnection " + this.toString() + " is committing"));
                ((DB)this.conn).requestDone();
                this.startRequested = false;
                NucleusLogger.CONNECTION.debug((Object)("ManagedConnection " + this.toString() + " committed connection"));
            }
            super.release();
        }

        public void close() {
            int i;
            if (this.conn == null) {
                return;
            }
            for (i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPreClose();
            }
            if (this.startRequested) {
                NucleusLogger.CONNECTION.debug((Object)("ManagedConnection " + this.toString() + " is committing"));
                ((DB)this.conn).requestDone();
                this.startRequested = false;
                NucleusLogger.CONNECTION.debug((Object)("ManagedConnection " + this.toString() + " committed connection"));
            }
            for (i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPostClose();
            }
            this.conn = null;
            this.xaRes = null;
        }

        public XAResource getXAResource() {
            if (this.xaRes == null) {
                if (this.conn == null) {
                    this.obtainNewConnection();
                }
                this.xaRes = new EmulatedXAResource(this, (DB)this.conn);
            }
            return this.xaRes;
        }
    }
}

