/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.fieldmanager;

import com.mongodb.DBObject;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Array;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.Relation;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.mongodb.fieldmanager.FetchEmbeddedFieldManager;
import org.datanucleus.store.types.ObjectLongConverter;
import org.datanucleus.store.types.ObjectStringConverter;
import org.datanucleus.store.types.sco.SCOUtils;

public class FetchFieldManager
extends AbstractFieldManager {
    protected ExecutionContext ec;
    protected ObjectProvider sm;
    protected DBObject dbObject;
    protected AbstractClassMetaData cmd;
    boolean embedded = false;
    protected AbstractMemberMetaData ownerMmd = null;

    public FetchFieldManager(ObjectProvider sm, DBObject dbObject, AbstractClassMetaData acmd) {
        this.sm = sm;
        this.ec = sm.getExecutionContext();
        this.dbObject = dbObject;
        this.cmd = acmd;
        if (sm.getEmbeddedOwners() != null) {
            this.embedded = true;
        }
    }

    public FetchFieldManager(ExecutionContext ec, DBObject dbObject, AbstractClassMetaData acmd) {
        this.ec = ec;
        this.dbObject = dbObject;
        this.cmd = acmd;
    }

    public boolean fetchBooleanField(int fieldNumber) {
        String fieldName = this.getFieldName(fieldNumber);
        if (!this.dbObject.containsField(fieldName)) {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            String dflt = MongoDBUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Boolean.valueOf(dflt);
            }
            return false;
        }
        Object value = this.dbObject.get(fieldName);
        return (Boolean)value;
    }

    public byte fetchByteField(int fieldNumber) {
        String fieldName = this.getFieldName(fieldNumber);
        if (!this.dbObject.containsField(fieldName)) {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            String dflt = MongoDBUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Byte.valueOf(dflt);
            }
            return 0;
        }
        Object value = this.dbObject.get(fieldName);
        return (Byte)value;
    }

    public char fetchCharField(int fieldNumber) {
        String fieldName = this.getFieldName(fieldNumber);
        if (!this.dbObject.containsField(fieldName)) {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            String dflt = MongoDBUtils.getDefaultValueForMember(mmd);
            if (dflt != null && dflt.length() > 0) {
                return dflt.charAt(0);
            }
            return '\u0000';
        }
        Object value = this.dbObject.get(fieldName);
        return ((Character)value).charValue();
    }

    public double fetchDoubleField(int fieldNumber) {
        String fieldName = this.getFieldName(fieldNumber);
        if (!this.dbObject.containsField(fieldName)) {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            String dflt = MongoDBUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Double.valueOf(dflt);
            }
            return 0.0;
        }
        Object value = this.dbObject.get(fieldName);
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof Long) {
            return ((Long)value).doubleValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).doubleValue();
        }
        return (Double)value;
    }

    public float fetchFloatField(int fieldNumber) {
        String fieldName = this.getFieldName(fieldNumber);
        if (!this.dbObject.containsField(fieldName)) {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            String dflt = MongoDBUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Float.valueOf(dflt).floatValue();
            }
            return 0.0f;
        }
        Object value = this.dbObject.get(fieldName);
        if (value instanceof Double) {
            return ((Double)value).floatValue();
        }
        if (value instanceof Long) {
            return ((Long)value).floatValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).floatValue();
        }
        return ((Float)value).floatValue();
    }

    public int fetchIntField(int fieldNumber) {
        String fieldName = this.getFieldName(fieldNumber);
        if (!this.dbObject.containsField(fieldName)) {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            String dflt = MongoDBUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Integer.valueOf(dflt);
            }
            return 0;
        }
        Object value = this.dbObject.get(fieldName);
        if (value instanceof Short) {
            return ((Short)value).intValue();
        }
        if (value instanceof Float) {
            return ((Float)value).intValue();
        }
        if (value instanceof Double) {
            return ((Double)value).intValue();
        }
        if (value instanceof Long) {
            return ((Long)value).intValue();
        }
        return (Integer)value;
    }

    public long fetchLongField(int fieldNumber) {
        String fieldName = this.getFieldName(fieldNumber);
        if (!this.dbObject.containsField(fieldName)) {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            String dflt = MongoDBUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Long.valueOf(dflt);
            }
            return 0L;
        }
        Object value = this.dbObject.get(fieldName);
        if (value instanceof Short) {
            return ((Short)value).longValue();
        }
        if (value instanceof Float) {
            return ((Float)value).longValue();
        }
        if (value instanceof Double) {
            return ((Double)value).longValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        return (Long)value;
    }

    public short fetchShortField(int fieldNumber) {
        String fieldName = this.getFieldName(fieldNumber);
        if (!this.dbObject.containsField(fieldName)) {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            String dflt = MongoDBUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Short.valueOf(dflt);
            }
            return 0;
        }
        Object value = this.dbObject.get(fieldName);
        if (value instanceof Long) {
            return ((Long)value).shortValue();
        }
        if (value instanceof Float) {
            return ((Float)value).shortValue();
        }
        if (value instanceof Double) {
            return ((Double)value).shortValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).shortValue();
        }
        return (Short)value;
    }

    public String fetchStringField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getValueStrategy() == IdentityStrategy.IDENTITY) {
            Object id = this.dbObject.get("_id");
            return id.toString();
        }
        String fieldName = this.getFieldName(fieldNumber);
        if (this.dbObject.containsField(fieldName)) {
            return (String)this.dbObject.get(fieldName);
        }
        return null;
    }

    protected String getFieldName(int fieldNumber) {
        return MongoDBUtils.getFieldName(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
    }

    public Object fetchObjectField(int fieldNumber) {
        String fieldName;
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        int relationType = mmd.getRelationType(clr);
        boolean embedded = false;
        if (this.embedded || this.ownerMmd != null) {
            embedded = true;
        } else if (relationType != 0) {
            if (mmd.isEmbedded()) {
                embedded = true;
            } else if (mmd.getEmbeddedMetaData() != null) {
                embedded = true;
            } else if (Relation.isRelationMultiValued((int)relationType)) {
                if (mmd.hasCollection() && mmd.getElementMetaData() != null && mmd.getElementMetaData().getEmbeddedMetaData() != null) {
                    embedded = true;
                } else if (mmd.hasArray() && mmd.getElementMetaData() != null && mmd.getElementMetaData().getEmbeddedMetaData() != null) {
                    embedded = true;
                } else if (mmd.hasMap() && (mmd.getKeyMetaData() != null && mmd.getKeyMetaData().getEmbeddedMetaData() != null || mmd.getValueMetaData() != null && mmd.getValueMetaData().getEmbeddedMetaData() != null)) {
                    embedded = true;
                }
            }
        }
        if (embedded) {
            if (Relation.isRelationSingleValued((int)relationType)) {
                AbstractClassMetaData embcmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
                if (embcmd == null) {
                    throw new NucleusUserException("Field " + mmd.getFullFieldName() + " marked as embedded but no such metadata");
                }
                boolean nested = true;
                String nestedStr = mmd.getValueForExtension("nested");
                if (nestedStr != null && nestedStr.equalsIgnoreCase("false")) {
                    nested = false;
                }
                if (nested) {
                    if (embedded && Relation.isBidirectional((int)relationType) && (this.ownerMmd.getMappedBy() != null && mmd.getName().equals(this.ownerMmd.getMappedBy()) || mmd.getMappedBy() != null && this.ownerMmd.getName().equals(mmd.getMappedBy()))) {
                        ObjectProvider[] ownerSms = this.sm.getEmbeddedOwners();
                        if (ownerSms == null) {
                            throw new NucleusException("Processing of " + mmd.getFullFieldName() + " cannot set value to owner since owner StateManager not set");
                        }
                        return ownerSms[0].getObject();
                    }
                    String fieldName2 = MongoDBUtils.getFieldName(mmd);
                    if (!this.dbObject.containsField(fieldName2)) {
                        return null;
                    }
                    DBObject embeddedValue = (DBObject)this.dbObject.get(fieldName2);
                    ObjectProvider embSM = this.ec.newObjectProviderForEmbedded(mmd, embcmd, this.sm, fieldNumber);
                    FetchFieldManager ffm = new FetchFieldManager(embSM, embeddedValue, embcmd);
                    ffm.ownerMmd = mmd;
                    ffm.embedded = true;
                    embSM.replaceFields(embcmd.getAllMemberPositions(), (FieldManager)ffm);
                    return embSM.getObject();
                }
                EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
                AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
                boolean isNull = true;
                for (int i = 0; i < embmmds.length; ++i) {
                    String embFieldName = MongoDBUtils.getFieldName(mmd, i);
                    if (!this.dbObject.containsField(embFieldName)) continue;
                    isNull = false;
                    break;
                }
                if (isNull) {
                    return null;
                }
                ObjectProvider embSM = this.ec.newObjectProviderForEmbedded(mmd, embcmd, this.sm, fieldNumber);
                FetchEmbeddedFieldManager ffm = new FetchEmbeddedFieldManager(embSM, this.dbObject, mmd);
                embSM.replaceFields(embcmd.getAllMemberPositions(), (FieldManager)ffm);
                return embSM.getObject();
            }
            if (Relation.isRelationMultiValued((int)relationType)) {
                if (mmd.hasCollection()) {
                    Collection coll;
                    String fieldName3 = MongoDBUtils.getFieldName(mmd);
                    if (!this.dbObject.containsField(fieldName3)) {
                        return null;
                    }
                    Object value = this.dbObject.get(fieldName3);
                    AbstractClassMetaData elemCmd = mmd.getCollection().getElementClassMetaData(clr, this.ec.getMetaDataManager());
                    try {
                        Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                        coll = (Collection)instanceType.newInstance();
                    }
                    catch (Exception e) {
                        throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                    }
                    Collection collValue = (Collection)value;
                    for (DBObject elementObj : collValue) {
                        ObjectProvider embSM = this.ec.newObjectProviderForEmbedded(mmd, elemCmd, this.sm, fieldNumber);
                        embSM.setPcObjectType((short)2);
                        FetchFieldManager ffm = new FetchFieldManager(embSM, elementObj, elemCmd);
                        ffm.ownerMmd = mmd;
                        ffm.embedded = true;
                        embSM.replaceFields(elemCmd.getAllMemberPositions(), (FieldManager)ffm);
                        coll.add(embSM.getObject());
                    }
                    if (this.sm != null) {
                        return this.sm.wrapSCOField(fieldNumber, (Object)coll, false, false, true);
                    }
                    return coll;
                }
                if (mmd.hasArray()) {
                    String fieldName4 = MongoDBUtils.getFieldName(mmd);
                    if (!this.dbObject.containsField(fieldName4)) {
                        return null;
                    }
                    AbstractClassMetaData elemCmd = mmd.getArray().getElementClassMetaData(clr, this.ec.getMetaDataManager());
                    Object value = this.dbObject.get(fieldName4);
                    Object[] array = new Object[Array.getLength(value)];
                    for (int i = 0; i < array.length; ++i) {
                        DBObject elementObj = (DBObject)Array.get(value, i);
                        ObjectProvider embSM = this.ec.newObjectProviderForEmbedded(mmd, elemCmd, this.sm, fieldNumber);
                        embSM.setPcObjectType((short)2);
                        FetchFieldManager ffm = new FetchFieldManager(embSM, elementObj, elemCmd);
                        ffm.ownerMmd = mmd;
                        ffm.embedded = true;
                        embSM.replaceFields(elemCmd.getAllMemberPositions(), (FieldManager)ffm);
                        array[i] = embSM.getObject();
                    }
                    return array;
                }
                String fieldName5 = MongoDBUtils.getFieldName(mmd);
                if (!this.dbObject.containsField(fieldName5)) {
                    return null;
                }
                Object value = this.dbObject.get(fieldName5);
                Map map = null;
                try {
                    Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), null);
                    map = (Map)instanceType.newInstance();
                }
                catch (Exception e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
                AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(clr, this.ec.getMetaDataManager());
                AbstractClassMetaData valCmd = mmd.getMap().getValueClassMetaData(clr, this.ec.getMetaDataManager());
                Collection entryColl = (Collection)value;
                for (DBObject entryObj : entryColl) {
                    Object keyObj = entryObj.get("key");
                    Object valObj = entryObj.get("value");
                    Object mapKey = null;
                    if (keyCmd != null) {
                        DBObject keyDbObj = (DBObject)keyObj;
                        ObjectProvider embSM = this.ec.newObjectProviderForEmbedded(mmd, keyCmd, this.sm, fieldNumber);
                        embSM.setPcObjectType((short)3);
                        FetchFieldManager ffm = new FetchFieldManager(embSM, keyDbObj, keyCmd);
                        ffm.ownerMmd = mmd;
                        ffm.embedded = true;
                        embSM.replaceFields(keyCmd.getAllMemberPositions(), (FieldManager)ffm);
                        mapKey = embSM.getObject();
                    } else {
                        mapKey = this.getMapKeyForReturnValue(mmd, keyObj);
                    }
                    Object mapVal = null;
                    if (valCmd != null) {
                        DBObject valDbObj = (DBObject)valObj;
                        ObjectProvider embSM = this.ec.newObjectProviderForEmbedded(mmd, valCmd, this.sm, fieldNumber);
                        embSM.setPcObjectType((short)4);
                        FetchFieldManager ffm = new FetchFieldManager(embSM, valDbObj, valCmd);
                        ffm.ownerMmd = mmd;
                        ffm.embedded = true;
                        embSM.replaceFields(valCmd.getAllMemberPositions(), (FieldManager)ffm);
                        mapVal = embSM.getObject();
                    } else {
                        mapVal = this.getMapValueForReturnValue(mmd, valObj);
                    }
                    map.put(mapKey, mapVal);
                }
                if (this.sm != null) {
                    return this.sm.wrapSCOField(fieldNumber, (Object)map, false, false, true);
                }
                return map;
            }
        }
        if (!this.dbObject.containsField(fieldName = MongoDBUtils.getFieldName(mmd))) {
            return null;
        }
        Object value = this.dbObject.get(fieldName);
        if (mmd.isSerialized()) {
            return this.getValueForSerialisedField(mmd, value);
        }
        if (Relation.isRelationSingleValued((int)relationType)) {
            return this.getValueForSingleRelationField(mmd, value, clr);
        }
        if (Relation.isRelationMultiValued((int)relationType)) {
            return this.getValueForContainerRelationField(mmd, value, clr);
        }
        Object val = this.getValueForContainerNonRelationField(mmd, value);
        if (this.sm != null) {
            return this.sm.wrapSCOField(mmd.getAbsoluteFieldNumber(), val, false, false, true);
        }
        return val;
    }

    protected Object getValueForSerialisedField(AbstractMemberMetaData mmd, Object value) {
        Object returnValue = null;
        try {
            if (value != null) {
                byte[] bytes = (byte[])value;
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                returnValue = ois.readObject();
                ois.close();
                bis.close();
                if (this.sm != null) {
                    returnValue = this.sm.wrapSCOField(mmd.getAbsoluteFieldNumber(), returnValue, false, false, true);
                }
            }
        }
        catch (Exception e) {
            throw new NucleusUserException("Exception thrown deserialising field at " + mmd.getFullFieldName(), (Throwable)e);
        }
        return returnValue;
    }

    protected Object getValueForSingleRelationField(AbstractMemberMetaData mmd, Object value, ClassLoaderResolver clr) {
        String idStr = (String)value;
        if (value == null) {
            return null;
        }
        return IdentityUtils.getObjectFromIdString((String)idStr, (AbstractMemberMetaData)mmd, (int)2, (ExecutionContext)this.ec, (boolean)true);
    }

    protected Object getValueForContainerRelationField(AbstractMemberMetaData mmd, Object value, ClassLoaderResolver clr) {
        if (mmd.hasCollection()) {
            Collection coll;
            try {
                Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                coll = (Collection)instanceType.newInstance();
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            AbstractClassMetaData elemCmd = mmd.getCollection().getElementClassMetaData(clr, this.ec.getMetaDataManager());
            Collection collIds = (Collection)value;
            for (String elementIdStr : collIds) {
                coll.add(IdentityUtils.getObjectFromIdString((String)elementIdStr, (AbstractClassMetaData)elemCmd, (ExecutionContext)this.ec, (boolean)true));
            }
            if (this.sm != null) {
                return this.sm.wrapSCOField(mmd.getAbsoluteFieldNumber(), (Object)coll, false, false, true);
            }
            return coll;
        }
        if (mmd.hasMap()) {
            Map map = null;
            try {
                Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), null);
                map = (Map)instanceType.newInstance();
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(clr, this.ec.getMetaDataManager());
            AbstractClassMetaData valueCmd = mmd.getMap().getValueClassMetaData(clr, this.ec.getMetaDataManager());
            Collection collEntries = (Collection)value;
            for (DBObject entryObj : collEntries) {
                Object keyObj = entryObj.get("key");
                Object valueObj = entryObj.get("value");
                Object mapKey = null;
                mapKey = keyCmd != null ? IdentityUtils.getObjectFromIdString((String)((String)keyObj), (AbstractClassMetaData)keyCmd, (ExecutionContext)this.ec, (boolean)true) : this.getMapKeyForReturnValue(mmd, keyObj);
                Object mapVal = null;
                mapVal = valueCmd != null ? IdentityUtils.getObjectFromIdString((String)((String)valueObj), (AbstractClassMetaData)valueCmd, (ExecutionContext)this.ec, (boolean)true) : this.getMapValueForReturnValue(mmd, valueObj);
                map.put(mapKey, mapVal);
            }
            if (this.sm != null) {
                return this.sm.wrapSCOField(mmd.getAbsoluteFieldNumber(), (Object)map, false, false, true);
            }
            return map;
        }
        if (mmd.hasArray()) {
            AbstractClassMetaData elemCmd = mmd.getArray().getElementClassMetaData(clr, this.ec.getMetaDataManager());
            Collection collIds = (Collection)value;
            Iterator idIter = collIds.iterator();
            int i = 0;
            Object array = Array.newInstance(mmd.getType().getComponentType(), collIds.size());
            while (idIter.hasNext()) {
                String elementIdStr = (String)idIter.next();
                Array.set(array, i, IdentityUtils.getObjectFromIdString((String)elementIdStr, (AbstractClassMetaData)elemCmd, (ExecutionContext)this.ec, (boolean)true));
                ++i;
            }
            return array;
        }
        return value;
    }

    protected Object getValueForContainerNonRelationField(AbstractMemberMetaData mmd, Object value) {
        if (Enum.class.isAssignableFrom(mmd.getType())) {
            return Enum.valueOf(mmd.getType(), (String)value);
        }
        if (Date.class.isAssignableFrom(mmd.getType()) && value instanceof Date) {
            if (this.sm != null) {
                return this.sm.wrapSCOField(mmd.getAbsoluteFieldNumber(), value, false, false, true);
            }
            return value;
        }
        if (Calendar.class.isAssignableFrom(mmd.getType())) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)value);
            return cal;
        }
        ObjectStringConverter strConv = this.ec.getNucleusContext().getTypeManager().getStringConverter(mmd.getType());
        ObjectLongConverter longConv = this.ec.getNucleusContext().getTypeManager().getLongConverter(mmd.getType());
        Object returnValue = value;
        if (strConv != null) {
            String strValue = (String)value;
            returnValue = strConv.toObject(strValue);
        } else if (longConv != null) {
            Long longValue = (Long)value;
            returnValue = longConv.toObject(longValue);
        }
        if (this.sm != null) {
            return this.sm.wrapSCOField(mmd.getAbsoluteFieldNumber(), returnValue, false, false, true);
        }
        return returnValue;
    }

    private Object getMapKeyForReturnValue(AbstractMemberMetaData mmd, Object value) {
        String keyType = mmd.getMap().getKeyType();
        Class keyCls = this.ec.getClassLoaderResolver().classForName(keyType);
        if (keyCls == Long.class || keyCls == Double.class || keyCls == Float.class || keyCls == Integer.class || keyCls == Short.class || keyCls == String.class) {
            return value;
        }
        if (Enum.class.isAssignableFrom(keyCls)) {
            return Enum.valueOf(keyCls, (String)value);
        }
        throw new NucleusException("Dont currently support persistence/retrieval of maps with keys of type " + keyType);
    }

    private Object getMapValueForReturnValue(AbstractMemberMetaData mmd, Object value) {
        String valueType = mmd.getMap().getValueType();
        Class valueCls = this.ec.getClassLoaderResolver().classForName(valueType);
        if (valueCls == Long.class || valueCls == Double.class || valueCls == Float.class || valueCls == Integer.class || valueCls == Short.class || valueCls == String.class) {
            return value;
        }
        if (Enum.class.isAssignableFrom(valueCls)) {
            return Enum.valueOf(valueCls, (String)value);
        }
        throw new NucleusException("Dont currently support persistence/retrieval of maps with values of type " + valueType);
    }
}

