/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.fieldmanager;

import com.mongodb.DBObject;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.Relation;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.mongodb.fieldmanager.FetchFieldManager;

public class FetchEmbeddedFieldManager
extends FetchFieldManager {
    private final AbstractMemberMetaData ownerMmd;

    public FetchEmbeddedFieldManager(ObjectProvider sm, DBObject dbObject, AbstractMemberMetaData ownerMmd) {
        super(sm, dbObject, null);
        this.ownerMmd = ownerMmd;
    }

    protected String getFieldName(int fieldNumber) {
        return MongoDBUtils.getFieldName(this.ownerMmd, fieldNumber);
    }

    public Object fetchObjectField(int fieldNumber) {
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        AbstractMemberMetaData embMmd = this.ownerMmd.getEmbeddedMetaData().getMemberMetaData()[fieldNumber];
        int relationType = embMmd.getRelationType(clr);
        if (Relation.isRelationSingleValued((int)relationType) && embMmd.isEmbedded()) {
            AbstractClassMetaData embcmd = this.ec.getMetaDataManager().getMetaDataForClass(embMmd.getType(), clr);
            if (embcmd == null) {
                throw new NucleusUserException("Field " + this.ownerMmd.getFullFieldName() + " marked as embedded but no such metadata");
            }
            if ((relationType == 2 || relationType == 6) && (this.ownerMmd.getMappedBy() != null && embMmd.getName().equals(this.ownerMmd.getMappedBy()) || embMmd.getMappedBy() != null && this.ownerMmd.getName().equals(embMmd.getMappedBy()))) {
                ObjectProvider[] ownerSms = this.sm.getEmbeddedOwners();
                if (ownerSms == null) {
                    throw new NucleusException("Processing of " + embMmd.getFullFieldName() + " cannot set value to owner since owner StateManager not set");
                }
                return ownerSms[0].getObject();
            }
            EmbeddedMetaData embmd = this.ownerMmd.getEmbeddedMetaData();
            AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
            boolean isNull = true;
            for (int i = 0; i < embmmds.length; ++i) {
                String embFieldName = MongoDBUtils.getFieldName(this.ownerMmd, i);
                if (!this.dbObject.containsField(embFieldName)) continue;
                isNull = false;
                break;
            }
            if (isNull) {
                return null;
            }
            ObjectProvider embSM = this.ec.newObjectProviderForEmbedded(embMmd, embcmd, this.sm, fieldNumber);
            FetchEmbeddedFieldManager ffm = new FetchEmbeddedFieldManager(embSM, this.dbObject, embMmd);
            embSM.replaceFields(embcmd.getAllMemberPositions(), (FieldManager)ffm);
            return embSM.getObject();
        }
        String fieldName = MongoDBUtils.getFieldName(this.ownerMmd, fieldNumber);
        if (!this.dbObject.containsField(fieldName)) {
            return null;
        }
        Object value = this.dbObject.get(fieldName);
        if (embMmd.isSerialized()) {
            return this.getValueForSerialisedField(embMmd, value);
        }
        if (Relation.isRelationSingleValued((int)relationType)) {
            return this.getValueForSingleRelationField(embMmd, value, clr);
        }
        if (Relation.isRelationMultiValued((int)relationType)) {
            return this.getValueForContainerRelationField(embMmd, value, clr);
        }
        return this.getValueForContainerNonRelationField(embMmd, value);
    }
}

