/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import javax.naming.directory.Attributes;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.ldap.fieldmanager.AbstractMappingStrategy;

public class FetchFieldManager
extends AbstractFieldManager {
    ObjectProvider sm;
    StoreManager storeMgr;
    Attributes result;

    public FetchFieldManager(StoreManager storeMgr, ObjectProvider sm, Attributes result) {
        this.sm = sm;
        this.storeMgr = storeMgr;
        this.result = result;
    }

    public String fetchStringField(int fieldNumber) {
        return (String)this.fetchObjectField(fieldNumber);
    }

    public Object fetchObjectField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        AbstractMappingStrategy ms = AbstractMappingStrategy.findMappingStrategy(this.storeMgr, this.sm, mmd, this.result);
        if (ms != null) {
            return ms.fetch();
        }
        throw new NucleusException("Cant obtain value for field " + mmd.getFullFieldName() + " since type=" + mmd.getTypeName() + " is not supported for this datastore");
    }

    public boolean fetchBooleanField(int fieldNumber) {
        return (Boolean)this.fetchObjectField(fieldNumber);
    }

    public byte fetchByteField(int fieldNumber) {
        return (Byte)this.fetchObjectField(fieldNumber);
    }

    public char fetchCharField(int fieldNumber) {
        return ((Character)this.fetchObjectField(fieldNumber)).charValue();
    }

    public double fetchDoubleField(int fieldNumber) {
        return (Double)this.fetchObjectField(fieldNumber);
    }

    public float fetchFloatField(int fieldNumber) {
        return ((Float)this.fetchObjectField(fieldNumber)).floatValue();
    }

    public int fetchIntField(int fieldNumber) {
        return (Integer)this.fetchObjectField(fieldNumber);
    }

    public long fetchLongField(int fieldNumber) {
        return (Long)this.fetchObjectField(fieldNumber);
    }

    public short fetchShortField(int fieldNumber) {
        return (Short)this.fetchObjectField(fieldNumber);
    }
}

