/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.XAResource;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Table;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.connection.AbstractManagedConnection;

public class HBaseManagedConnection
extends AbstractManagedConnection {
    private Connection conn;
    private Map<String, Table> tables;
    private int idleTimeoutMills = 30000;
    private long expirationTime;
    private boolean isDisposed = false;

    public HBaseManagedConnection(Connection conn) {
        this.conn = conn;
        this.tables = new HashMap<String, Table>();
        this.disableExpirationTime();
    }

    public Object getConnection() {
        return this.conn;
    }

    public Table getHTable(String tableNameString) {
        Table table = this.tables.get(tableNameString);
        if (table == null) {
            try {
                table = this.conn.getTable(TableName.valueOf((String)tableNameString));
                this.tables.put(tableNameString, table);
            }
            catch (Exception e) {
                throw new NucleusDataStoreException("Exception obtaining Table from Connection for table=" + tableNameString, (Throwable)e);
            }
        }
        return table;
    }

    public XAResource getXAResource() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        for (Object listener : this.listeners) {
            listener.managedConnectionPreClose();
        }
        try {
            Map<String, Table> oldtables = this.tables;
            this.tables = new HashMap<String, Table>();
            try {
                for (Table table : oldtables.values()) {
                    table.close();
                }
                this.dispose();
            }
            catch (IOException e) {
                throw new NucleusDataStoreException("Exception thrown while closing HTable(s) for transaction and associated HConnection", (Throwable)e);
            }
        }
        finally {
            for (Object listener : this.listeners) {
                listener.managedConnectionPostClose();
            }
        }
    }

    protected void incrementUseCount() {
        super.incrementUseCount();
        this.disableExpirationTime();
    }

    public void release() {
        super.release();
        if (this.useCount == 0) {
            this.enableExpirationTime();
        }
    }

    private void enableExpirationTime() {
        this.expirationTime = System.currentTimeMillis() + (long)this.idleTimeoutMills;
    }

    private void disableExpirationTime() {
        this.expirationTime = -1L;
    }

    public void setIdleTimeoutMills(int mills) {
        this.idleTimeoutMills = mills;
    }

    public boolean isExpired() {
        return this.expirationTime > 0L && this.expirationTime > System.currentTimeMillis();
    }

    public void dispose() {
        this.isDisposed = true;
        if (!this.conn.isClosed()) {
            try {
                this.conn.close();
            }
            catch (IOException e) {
                throw new NucleusDataStoreException("Exception thrown closing HConnection", (Throwable)e);
            }
        }
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }
}

