/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.AbstractConnectionFactory;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.hbase.HBaseConnectionPool;
import org.datanucleus.store.hbase.HBaseManagedConnection;
import org.datanucleus.store.hbase.HBaseStoreManager;
import org.datanucleus.util.Localiser;

public class ConnectionFactoryImpl
extends AbstractConnectionFactory {
    private Configuration config;
    private HBaseConnectionPool connectionPool;
    private int poolMinEvictableIdleTimeMillis = 0;

    public ConnectionFactoryImpl(StoreManager storeMgr, String resourceType) {
        super(storeMgr, resourceType);
        int maxSize;
        int poolTimeBetweenEvictionRunsMillis = storeMgr.getIntProperty("datanucleus.connectionPool.timeBetweenEvictionRunsMillis");
        if (poolTimeBetweenEvictionRunsMillis == 0) {
            poolTimeBetweenEvictionRunsMillis = 15000;
        }
        this.poolMinEvictableIdleTimeMillis = storeMgr.getIntProperty("datanucleus.connectionPool.minEvictableIdleTimeMillis");
        if (this.poolMinEvictableIdleTimeMillis == 0) {
            this.poolMinEvictableIdleTimeMillis = 30000;
        }
        this.connectionPool = new HBaseConnectionPool();
        this.connectionPool.setTimeBetweenEvictionRunsMillis(poolTimeBetweenEvictionRunsMillis);
        String url = storeMgr.getConnectionURL();
        if (!url.startsWith("hbase")) {
            throw new NucleusException(Localiser.msg((String)"HBase.URLInvalid", (Object[])new Object[]{url}));
        }
        String hbaseStr = url.substring(5);
        if (hbaseStr.startsWith(":")) {
            hbaseStr = hbaseStr.substring(1);
        }
        this.config = ((HBaseStoreManager)storeMgr).getHbaseConfig();
        if (hbaseStr.length() > 0) {
            String serverName = hbaseStr;
            String portName = "60000";
            if (hbaseStr.indexOf(58) > 0) {
                serverName = hbaseStr.substring(0, hbaseStr.indexOf(58));
                portName = hbaseStr.substring(hbaseStr.indexOf(58) + 1);
            }
            this.config.set("hbase.zookeeper.quorum", serverName);
            this.config.set("hbase.master", serverName + ":" + portName);
        }
        maxSize = (maxSize = storeMgr.getIntProperty("datanucleus.hbase.tablePoolMaxSize")) > 0 ? maxSize : Integer.MAX_VALUE;
    }

    public ManagedConnection createManagedConnection(ExecutionContext ec, Map options) {
        HBaseManagedConnection managedConnection = this.connectionPool.getPooledConnection();
        if (managedConnection == null) {
            try {
                HConnection hconn = HConnectionManager.createConnection((Configuration)this.config);
                managedConnection = new HBaseManagedConnection(hconn);
                managedConnection.setIdleTimeoutMills(this.poolMinEvictableIdleTimeMillis);
                this.connectionPool.registerConnection(managedConnection);
            }
            catch (ZooKeeperConnectionException e) {
                throw new NucleusDataStoreException("Exception thrown obtaining HConnection", (Throwable)e);
            }
        }
        return managedConnection;
    }
}

