/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.hbase.HBaseStoreManager;
import org.datanucleus.store.hbase.HBaseUtils;
import org.datanucleus.store.hbase.metadata.MetaDataExtensionParser;
import org.datanucleus.store.schema.AbstractStoreSchemaHandler;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.CompleteClassTable;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class HBaseSchemaHandler
extends AbstractStoreSchemaHandler {
    public HBaseSchemaHandler(StoreManager storeMgr) {
        super(storeMgr);
    }

    public void createSchemaForClasses(Set<String> classNames, Properties props, Object connection) {
        if (this.isAutoCreateTables() || this.isAutoCreateColumns()) {
            Iterator<String> classIter = classNames.iterator();
            ClassLoaderResolver clr = this.storeMgr.getNucleusContext().getClassLoaderResolver(null);
            while (classIter.hasNext()) {
                String className = classIter.next();
                AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(className, clr);
                if (cmd == null) continue;
                this.createSchemaForClass((HBaseStoreManager)this.storeMgr, cmd, false);
            }
        }
    }

    public void createSchemaForClass(final HBaseStoreManager storeMgr, final AbstractClassMetaData cmd, final boolean validateOnly) {
        if (cmd.isEmbeddedOnly()) {
            return;
        }
        StoreData storeData = storeMgr.getStoreDataForClass(cmd.getFullClassName());
        Object table = null;
        table = storeData != null ? storeData.getTable() : new CompleteClassTable((StoreManager)storeMgr, cmd, null);
        final String tableName = table.getName();
        final Configuration config = storeMgr.getHbaseConfig();
        try {
            boolean changed;
            final HBaseAdmin hBaseAdmin = (HBaseAdmin)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new HBaseAdmin(config);
                }
            });
            final HTableDescriptor hTable = (HTableDescriptor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    HTableDescriptor hTable;
                    block3: {
                        hTable = null;
                        try {
                            hTable = hBaseAdmin.getTableDescriptor(tableName.getBytes());
                        }
                        catch (TableNotFoundException ex) {
                            if (validateOnly) {
                                NucleusLogger.DATASTORE_SCHEMA.info((Object)Localiser.msg((String)"HBase.SchemaValidate.Class", (Object[])new Object[]{cmd.getFullClassName(), tableName}));
                            }
                            if (!storeMgr.getSchemaHandler().isAutoCreateTables()) break block3;
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"HBase.SchemaCreate.Class", (Object[])new Object[]{cmd.getFullClassName(), tableName}));
                            hTable = new HTableDescriptor(tableName);
                            hBaseAdmin.createTable(hTable);
                        }
                    }
                    return hTable;
                }
            });
            if (hTable == null) {
                return;
            }
            MetaDataExtensionParser ep = new MetaDataExtensionParser(cmd);
            boolean modified = false;
            if (!hTable.hasFamily(tableName.getBytes())) {
                if (validateOnly) {
                    NucleusLogger.DATASTORE_SCHEMA.info((Object)Localiser.msg((String)"HBase.SchemaValidate.Class.Family", (Object[])new Object[]{tableName, tableName}));
                } else if (storeMgr.getSchemaHandler().isAutoCreateColumns()) {
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"HBase.SchemaCreate.Class.Family", (Object[])new Object[]{tableName, tableName}));
                    HColumnDescriptor hColumn = new HColumnDescriptor(tableName);
                    hTable.addFamily(hColumn);
                    modified = true;
                }
            }
            List cols = table.getColumns();
            HashSet<String> familyNames = new HashSet<String>();
            for (Column col : cols) {
                boolean changed2 = this.addColumnFamilyForColumn(col, hTable, tableName, familyNames, validateOnly);
                if (!changed2) continue;
                modified = true;
            }
            if (table.getDatastoreIdColumn() != null && (changed = this.addColumnFamilyForColumn(table.getDatastoreIdColumn(), hTable, tableName, familyNames, validateOnly))) {
                modified = true;
            }
            if (table.getVersionColumn() != null && (changed = this.addColumnFamilyForColumn(table.getVersionColumn(), hTable, tableName, familyNames, validateOnly))) {
                modified = true;
            }
            if (table.getDiscriminatorColumn() != null && (changed = this.addColumnFamilyForColumn(table.getDiscriminatorColumn(), hTable, tableName, familyNames, validateOnly))) {
                modified = true;
            }
            if (table.getMultitenancyColumn() != null && (changed = this.addColumnFamilyForColumn(table.getMultitenancyColumn(), hTable, tableName, familyNames, validateOnly))) {
                modified = true;
            }
            if (!validateOnly && ep.hasExtensions()) {
                for (String familyName : familyNames) {
                    modified |= ep.applyExtensions(hTable, familyName);
                }
            }
            if (modified) {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        hBaseAdmin.disableTable(hTable.getName());
                        hBaseAdmin.modifyTable(hTable.getName(), hTable);
                        hBaseAdmin.enableTable(hTable.getName());
                        return null;
                    }
                });
            }
        }
        catch (PrivilegedActionException e) {
            throw new NucleusDataStoreException(e.getMessage(), e.getCause());
        }
    }

    protected boolean addColumnFamilyForColumn(Column col, HTableDescriptor htable, String tableName, Set<String> familyNames, boolean validateOnly) {
        boolean modified = false;
        String familyName = HBaseUtils.getFamilyNameForColumn(col);
        if (!familyNames.contains(familyName)) {
            familyNames.add(familyName);
            if (!htable.hasFamily(familyName.getBytes())) {
                if (validateOnly) {
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"HBase.SchemaValidate.Class.Family", (Object[])new Object[]{tableName, familyName}));
                } else if (this.storeMgr.getSchemaHandler().isAutoCreateColumns()) {
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"HBase.SchemaCreate.Class.Family", (Object[])new Object[]{tableName, familyName}));
                    HColumnDescriptor hColumn = new HColumnDescriptor(familyName);
                    htable.addFamily(hColumn);
                    modified = true;
                }
            }
        }
        return modified;
    }

    public void deleteSchemaForClasses(Set<String> classNames, Properties props, Object connection) {
        Iterator<String> classIter = classNames.iterator();
        ClassLoaderResolver clr = this.storeMgr.getNucleusContext().getClassLoaderResolver(null);
        while (classIter.hasNext()) {
            String className = classIter.next();
            AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(className, clr);
            if (cmd == null) continue;
            this.deleteSchemaForClass(cmd);
        }
    }

    void deleteSchemaForClass(final AbstractClassMetaData cmd) {
        if (cmd.isEmbeddedOnly()) {
            return;
        }
        StoreData storeData = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
        Object table = null;
        table = storeData != null ? storeData.getTable() : new CompleteClassTable(this.storeMgr, cmd, null);
        final String tableName = table.getName();
        final Configuration config = ((HBaseStoreManager)this.storeMgr).getHbaseConfig();
        try {
            final HBaseAdmin hBaseAdmin = (HBaseAdmin)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new HBaseAdmin(config);
                }
            });
            final HTableDescriptor hTable = (HTableDescriptor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    HTableDescriptor hTable;
                    try {
                        hTable = hBaseAdmin.getTableDescriptor(tableName.getBytes());
                    }
                    catch (TableNotFoundException ex) {
                        hTable = new HTableDescriptor(tableName);
                        hBaseAdmin.createTable(hTable);
                    }
                    return hTable;
                }
            });
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"HBase.SchemaDelete.Class", (Object[])new Object[]{cmd.getFullClassName(), hTable.getNameAsString()}));
                    hBaseAdmin.disableTable(hTable.getName());
                    hBaseAdmin.deleteTable(hTable.getName());
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new NucleusDataStoreException(e.getMessage(), e.getCause());
        }
    }

    public void validateSchema(Set<String> classNames, Properties props, Object connection) {
        if (this.isValidateTables() || this.isValidateColumns()) {
            Iterator<String> classIter = classNames.iterator();
            ClassLoaderResolver clr = this.storeMgr.getNucleusContext().getClassLoaderResolver(null);
            while (classIter.hasNext()) {
                String className = classIter.next();
                AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(className, clr);
                if (cmd == null) continue;
                this.createSchemaForClass((HBaseStoreManager)this.storeMgr, cmd, true);
            }
        }
    }
}

