/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase.metadata;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ExtensionMetaData;
import org.datanucleus.store.hbase.metadata.MetaDataExtension;
import org.datanucleus.util.NucleusLogger;

public class MetaDataExtensionParser {
    public static final String BASE = "hbase.columnFamily.";
    private Map<String, StoreFile.BloomType> bloomFilterPerCf = new HashMap<String, StoreFile.BloomType>();
    private Map<String, Boolean> inMemoryPerCf = new HashMap<String, Boolean>();
    private Map<String, Boolean> keepDeletedCellsPerCf = new HashMap<String, Boolean>();
    private Map<String, Boolean> blockCacheEnabledPerCf = new HashMap<String, Boolean>();
    private Map<String, Compression.Algorithm> compressionPerCf = new HashMap<String, Compression.Algorithm>();
    private Map<String, Integer> maxVersionsPerCf = new HashMap<String, Integer>();
    private Map<String, Integer> ttlPerCf = new HashMap<String, Integer>();
    private boolean extensionsFound = false;

    public MetaDataExtensionParser(AbstractClassMetaData acmd) {
        ExtensionMetaData[] eMetaData = acmd.getExtensions();
        if (eMetaData == null) {
            return;
        }
        for (ExtensionMetaData anEMetaData : eMetaData) {
            MetaDataExtension hBaseExtension;
            int nextDot;
            String key = anEMetaData.getKey();
            String value = anEMetaData.getValue();
            if (value == null || value.length() == 0 || key == null || !key.startsWith(BASE)) continue;
            if (NucleusLogger.METADATA.isDebugEnabled()) {
                NucleusLogger.METADATA.debug((Object)("Found HBase extension: " + anEMetaData));
            }
            if ((nextDot = key.indexOf(".", BASE.length())) == -1) continue;
            String cf = key.substring(BASE.length(), nextDot);
            String extension = key.substring(nextDot + 1, key.length());
            if (NucleusLogger.METADATA.isDebugEnabled()) {
                NucleusLogger.METADATA.debug((Object)("cf:" + cf + ", extension: " + extension));
            }
            if ((hBaseExtension = MetaDataExtension.parse(extension)) == null) continue;
            if (NucleusLogger.METADATA.isDebugEnabled()) {
                NucleusLogger.METADATA.debug((Object)("Adding '" + (Object)((Object)hBaseExtension) + "' '" + value + "'"));
            }
            switch (hBaseExtension) {
                case IN_MEMORY: {
                    this.inMemoryPerCf.put(cf, this.toBoolean(value));
                    break;
                }
                case BLOOM_FILTER: {
                    this.bloomFilterPerCf.put(cf, this.toBloomFilter(value));
                    this.extensionsFound = true;
                    break;
                }
                case MAX_VERSIONS: {
                    this.addMaxVersionsPerCf(cf, value);
                    break;
                }
                case KEEP_DELETED_CELLS: {
                    this.keepDeletedCellsPerCf.put(cf, this.toBoolean(value));
                    break;
                }
                case COMPRESSION: {
                    this.compressionPerCf.put(cf, this.toCompression(value));
                    break;
                }
                case BLOCK_CACHE_ENABLED: {
                    this.blockCacheEnabledPerCf.put(cf, this.toBoolean(value));
                    break;
                }
                case TIME_TO_LIVE: {
                    this.ttlPerCf.put(cf, this.toInteger(value));
                }
            }
            this.extensionsFound = true;
        }
    }

    public boolean hasExtensions() {
        return this.extensionsFound;
    }

    public boolean applyExtensions(HTableDescriptor hTable, String familyName) {
        Integer maxVersion;
        Boolean keepDeletedCells;
        Compression.Algorithm compression;
        Integer ttl;
        Boolean blockCacheEnabled;
        Boolean isInMemory;
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug((Object)("Applying extensions: {BF = " + this.bloomFilterPerCf + "}"));
        }
        boolean modified = false;
        if (!this.extensionsFound || familyName == null) {
            return modified;
        }
        HColumnDescriptor hColumnDescriptor = hTable.getFamily(familyName.getBytes());
        if (hColumnDescriptor == null) {
            throw new IllegalArgumentException("No such family name corresponding HTable: " + familyName);
        }
        StoreFile.BloomType configuredBloomFilter = this.getBloomFilterForCf(familyName);
        if (configuredBloomFilter != hColumnDescriptor.getBloomFilterType()) {
            hColumnDescriptor.setBloomFilterType(configuredBloomFilter);
            modified = true;
        }
        if ((isInMemory = this.inMemoryPerCf.get(familyName)) != null && isInMemory.booleanValue() != hColumnDescriptor.isInMemory()) {
            hColumnDescriptor.setInMemory(isInMemory.booleanValue());
            modified = true;
        }
        if ((blockCacheEnabled = this.blockCacheEnabledPerCf.get(familyName)) != null && blockCacheEnabled.booleanValue() != hColumnDescriptor.isBlockCacheEnabled()) {
            hColumnDescriptor.setBlockCacheEnabled(blockCacheEnabled.booleanValue());
            modified = true;
        }
        if ((ttl = this.ttlPerCf.get(familyName)) != null && ttl.intValue() != hColumnDescriptor.getTimeToLive()) {
            hColumnDescriptor.setTimeToLive(ttl.intValue());
            modified = true;
        }
        if ((compression = this.compressionPerCf.get(familyName)) != null && compression != hColumnDescriptor.getCompression()) {
            hColumnDescriptor.setCompressionType(compression);
            modified = true;
        }
        if ((keepDeletedCells = this.keepDeletedCellsPerCf.get(familyName)) != null && keepDeletedCells.booleanValue() != hColumnDescriptor.getKeepDeletedCells()) {
            hColumnDescriptor.setKeepDeletedCells(keepDeletedCells.booleanValue());
            modified = true;
        }
        if ((maxVersion = this.maxVersionsPerCf.get(familyName)) != null && maxVersion.intValue() != hColumnDescriptor.getMaxVersions()) {
            hColumnDescriptor.setMaxVersions(maxVersion.intValue());
            modified = true;
        }
        return modified;
    }

    private StoreFile.BloomType getBloomFilterForCf(String familyName) {
        StoreFile.BloomType result = this.bloomFilterPerCf.get(familyName);
        return result != null ? result : StoreFile.BloomType.NONE;
    }

    private StoreFile.BloomType toBloomFilter(String value) {
        if (value == null || value.length() == 0) {
            return StoreFile.BloomType.NONE;
        }
        try {
            return StoreFile.BloomType.valueOf((String)value);
        }
        catch (IllegalArgumentException e) {
            return StoreFile.BloomType.NONE;
        }
    }

    private Compression.Algorithm toCompression(String value) {
        if (value == null || value.length() == 0) {
            return Compression.Algorithm.NONE;
        }
        try {
            return Compression.Algorithm.valueOf((String)value);
        }
        catch (IllegalArgumentException e) {
            return Compression.Algorithm.NONE;
        }
    }

    private boolean toBoolean(String value) {
        return "true".equalsIgnoreCase(value) || "1".equals(value);
    }

    private Integer toInteger(String value) {
        if ("MAX_VALUE".equals(value)) {
            return Integer.MAX_VALUE;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void addMaxVersionsPerCf(String cf, String value) {
        Integer res = this.toInteger(value);
        if (res != null && res > 0) {
            this.maxVersionsPerCf.put(cf, res);
        } else {
            this.maxVersionsPerCf.put(cf, 3);
        }
    }
}

