/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.filter.Filter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.query.evaluator.JPQLEvaluator;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.hbase.HBaseManagedConnection;
import org.datanucleus.store.hbase.query.HBaseQueryCompilation;
import org.datanucleus.store.hbase.query.HBaseQueryUtils;
import org.datanucleus.store.hbase.query.QueryToHBaseMapper;
import org.datanucleus.store.query.AbstractJPQLQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryManager;
import org.datanucleus.util.NucleusLogger;

public class JPQLQuery
extends AbstractJPQLQuery {
    protected transient HBaseQueryCompilation datastoreCompilation;

    public JPQLQuery(StoreManager storeMgr, ExecutionContext ec) {
        this(storeMgr, ec, (JPQLQuery)null);
    }

    public JPQLQuery(StoreManager storeMgr, ExecutionContext ec, JPQLQuery q) {
        super(storeMgr, ec, (AbstractJPQLQuery)q);
    }

    public JPQLQuery(StoreManager storeMgr, ExecutionContext ec, String query) {
        super(storeMgr, ec, query);
    }

    protected void discardCompiled() {
        super.discardCompiled();
        this.datastoreCompilation = null;
    }

    protected boolean isCompiled() {
        if (this.evaluateInMemory()) {
            return this.compilation != null;
        }
        return this.compilation != null && this.datastoreCompilation != null;
    }

    protected boolean evaluateInMemory() {
        if (this.candidateCollection != null) {
            if (this.compilation != null && this.compilation.getSubqueryAliases() != null) {
                NucleusLogger.QUERY.warn((Object)"In-memory evaluator doesn't currently handle subqueries completely so evaluating in datastore");
                return false;
            }
            Object val = this.getExtension("datanucleus.query.evaluateInMemory");
            if (val == null) {
                return true;
            }
            return Boolean.valueOf((String)val);
        }
        return super.evaluateInMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void compileInternal(Map parameterValues) {
        String[] impls;
        if (this.isCompiled()) {
            return;
        }
        super.compileInternal(parameterValues);
        boolean inMemory = this.evaluateInMemory();
        if (this.candidateCollection != null && inMemory) {
            return;
        }
        if (this.candidateClass == null || this.candidateClassName == null) {
            this.candidateClass = this.compilation.getCandidateClass();
            this.candidateClassName = this.candidateClass.getName();
        }
        if (this.candidateClass == null) {
            throw new NucleusUserException(LOCALISER.msg("021009", (Object)this.candidateClassName));
        }
        this.ec.hasPersistenceInformationForClass(this.candidateClass);
        AbstractClassMetaData cmd = this.ec.getMetaDataManager().getMetaDataForClass(this.candidateClass, this.clr);
        if (this.candidateClass.isInterface() && ((impls = this.ec.getMetaDataManager().getClassesImplementingInterface(this.candidateClass.getName(), this.clr)).length != 1 || !cmd.isImplementationOfPersistentDefinition()) && (cmd = this.ec.getMetaDataManager().getMetaDataForInterface(this.candidateClass, this.clr)) == null) {
            throw new NucleusUserException("Attempting to query an interface yet it is not declared 'persistent'. Define the interface in metadata as being persistent to perform this operation, and make sure any implementations use the same identity and identity member(s)");
        }
        QueryManager qm = this.getQueryManager();
        String datastoreKey = this.getStoreManager().getQueryCacheKey();
        String cacheKey = this.getQueryCacheKey();
        if (this.useCaching()) {
            this.datastoreCompilation = (HBaseQueryCompilation)qm.getDatastoreQueryCompilation(datastoreKey, this.getLanguage(), cacheKey);
            if (this.datastoreCompilation != null) {
                this.setResultDistinct(this.compilation.getResultDistinct());
                return;
            }
        }
        HBaseQueryCompilation hBaseQueryCompilation = this.datastoreCompilation = new HBaseQueryCompilation();
        synchronized (hBaseQueryCompilation) {
            if (!inMemory) {
                this.compileQueryFull(parameterValues, cmd);
            }
        }
        if (this.datastoreCompilation.isPrecompilable() && cacheKey != null) {
            qm.addDatastoreQueryCompilation(datastoreKey, this.getLanguage(), cacheKey, (Object)this.datastoreCompilation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performExecute(Map parameters) {
        HBaseManagedConnection mconn = (HBaseManagedConnection)this.getStoreManager().getConnection(this.ec);
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021046", (Object)"JPQL", (Object)this.getSingleStringQuery(), null));
            }
            boolean filterInMemory = true;
            List candidates = null;
            if (this.candidateCollection != null) {
                candidates = new ArrayList(this.candidateCollection);
            } else if (this.candidateExtent != null) {
                candidates = new ArrayList();
                Iterator iter = this.candidateExtent.iterator();
                while (iter.hasNext()) {
                    candidates.add(iter.next());
                }
            } else {
                Filter filter = null;
                if (this.datastoreCompilation != null && this.datastoreCompilation.isFilterComplete()) {
                    filter = this.datastoreCompilation.getFilter();
                    if (this.datastoreCompilation.isFilterComplete()) {
                        filterInMemory = false;
                    }
                }
                candidates = HBaseQueryUtils.getObjectsOfCandidateType(this.ec, mconn, this.candidateClass, this.subclasses, this.ignoreCache, this.getFetchPlan(), filter);
            }
            JPQLEvaluator resultMapper = new JPQLEvaluator((Query)this, candidates, this.compilation, parameters, this.ec.getClassLoaderResolver());
            Collection results = resultMapper.execute(filterInMemory, true, true, true, true);
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021074", (Object)"JPQL", (Object)("" + (System.currentTimeMillis() - startTime))));
            }
            if (this.type == 2) {
                this.ec.deleteObjects(results.toArray());
                Long l = results.size();
                return l;
            }
            if (this.type == 1) {
                throw new NucleusException("Bulk Update is not yet supported");
            }
            Collection collection = results;
            return collection;
        }
        finally {
            mconn.release();
        }
    }

    private void compileQueryFull(Map parameters, AbstractClassMetaData candidateCmd) {
        if (this.type != 0) {
            return;
        }
        long startTime = 0L;
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021083", (Object)this.getLanguage(), (Object)this.toString()));
        }
        QueryToHBaseMapper mapper = new QueryToHBaseMapper(this.compilation, parameters, candidateCmd, this.ec, (Query)this);
        mapper.compile();
        this.datastoreCompilation.setFilter(mapper.getFilter());
        this.datastoreCompilation.setFilterComplete(mapper.isFilterComplete());
        if (this.range != null) {
            // empty if block
        }
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021084", (Object)this.getLanguage(), (Object)(System.currentTimeMillis() - startTime)));
        }
    }
}

