/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase.query;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.FieldValues2;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.Type;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.hbase.HBaseFetchFieldManager;
import org.datanucleus.store.hbase.HBaseManagedConnection;
import org.datanucleus.store.hbase.HBaseUtils;

class HBaseQueryUtils {
    HBaseQueryUtils() {
    }

    static List getObjectsOfCandidateType(ExecutionContext om, final HBaseManagedConnection mconn, Class candidateClass, boolean subclasses, boolean ignoreCache) {
        ArrayList<Object> results = new ArrayList<Object>();
        try {
            ClassLoaderResolver clr = om.getClassLoaderResolver();
            final AbstractClassMetaData acmd = om.getMetaDataManager().getMetaDataForClass(candidateClass, clr);
            Iterator it = (Iterator)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    HTable table = mconn.getHTable(HBaseUtils.getTableName(acmd));
                    Scan scan = new Scan();
                    int[] fieldNumbers = acmd.getAllMemberPositions();
                    for (int i = 0; i < fieldNumbers.length; ++i) {
                        byte[] familyNames = HBaseUtils.getFamilyName(acmd, fieldNumbers[i]).getBytes();
                        byte[] columnNames = HBaseUtils.getQualifierName(acmd, fieldNumbers[i]).getBytes();
                        scan.addColumn(familyNames, columnNames);
                    }
                    ResultScanner scanner = table.getScanner(scan);
                    Iterator it = scanner.iterator();
                    return it;
                }
            });
            while (it.hasNext()) {
                final Result result = (Result)it.next();
                results.add(om.findObjectUsingAID(new Type(clr.classForName(acmd.getFullClassName())), new FieldValues2(){

                    public void fetchFields(ObjectProvider sm) {
                        HBaseFetchFieldManager fm = new HBaseFetchFieldManager(acmd, result);
                        sm.replaceFields(acmd.getDFGMemberPositions(), (FieldManager)fm);
                    }

                    public void fetchNonLoadedFields(ObjectProvider sm) {
                        sm.replaceNonLoadedFields(acmd.getAllMemberPositions(), (FieldManager)new HBaseFetchFieldManager(acmd, result));
                    }

                    public FetchPlan getFetchPlanForLoading() {
                        return null;
                    }
                }, ignoreCache, true));
            }
        }
        catch (PrivilegedActionException e) {
            throw new NucleusDataStoreException(e.getMessage(), e.getCause());
        }
        return results;
    }
}

