/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.util.Collection;
import java.util.HashSet;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManager;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.metadata.MetaDataListener;
import org.datanucleus.store.AbstractStoreManager;
import org.datanucleus.store.NucleusConnection;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.hbase.HBaseMetaDataListener;
import org.datanucleus.store.hbase.HBasePersistenceHandler;

public class HBaseStoreManager
extends AbstractStoreManager {
    MetaDataListener metadataListener = new HBaseMetaDataListener(this);
    private HBaseConfiguration hbaseConfig;
    private boolean autoCreateTables = false;
    private boolean autoCreateColumns = false;
    private int poolTimeBetweenEvictionRunsMillis;
    private int poolMinEvictableIdleTimeMillis;

    public HBaseStoreManager(ClassLoaderResolver clr, OMFContext omfContext) {
        super("hbase", clr, omfContext);
        omfContext.getMetaDataManager().registerListener(this.metadataListener);
        this.persistenceHandler = new HBasePersistenceHandler((StoreManager)this);
        this.hbaseConfig = new HBaseConfiguration();
        PersistenceConfiguration conf = omfContext.getPersistenceConfiguration();
        boolean autoCreateSchema = conf.getBooleanProperty("datanucleus.autoCreateSchema");
        if (autoCreateSchema) {
            this.autoCreateTables = true;
            this.autoCreateColumns = true;
        } else {
            this.autoCreateTables = conf.getBooleanProperty("datanucleus.autoCreateTables");
            this.autoCreateColumns = conf.getBooleanProperty("datanucleus.autoCreateColumns");
        }
        this.poolTimeBetweenEvictionRunsMillis = conf.getIntProperty("datanucleus.connectionPool.timeBetweenEvictionRunsMillis");
        if (this.poolTimeBetweenEvictionRunsMillis == 0) {
            this.poolTimeBetweenEvictionRunsMillis = 15000;
        }
        this.poolMinEvictableIdleTimeMillis = conf.getIntProperty("datanucleus.connectionPool.minEvictableIdleTimeMillis");
        if (this.poolMinEvictableIdleTimeMillis == 0) {
            this.poolMinEvictableIdleTimeMillis = 30000;
        }
        this.logConfiguration();
    }

    protected void registerConnectionMgr() {
        super.registerConnectionMgr();
        this.connectionMgr.disableConnectionPool();
    }

    public void close() {
        this.omfContext.getMetaDataManager().deregisterListener(this.metadataListener);
        super.close();
    }

    public NucleusConnection getNucleusConnection(ObjectManager om) {
        throw new UnsupportedOperationException();
    }

    public Collection getSupportedOptions() {
        HashSet<String> set = new HashSet<String>();
        set.add("ApplicationIdentity");
        set.add("TransactionIsolationLevel.read-committed");
        return set;
    }

    public HBaseConfiguration getHbaseConfig() {
        return this.hbaseConfig;
    }

    public boolean isAutoCreateColumns() {
        return this.autoCreateColumns;
    }

    public boolean isAutoCreateTables() {
        return this.autoCreateTables;
    }

    public int getPoolMinEvictableIdleTimeMillis() {
        return this.poolMinEvictableIdleTimeMillis;
    }

    public int getPoolTimeBetweenEvictionRunsMillis() {
        return this.poolTimeBetweenEvictionRunsMillis;
    }
}

