/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.StorePersistenceHandler;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.hbase.HBaseFetchFieldManager;
import org.datanucleus.store.hbase.HBaseInsertFieldManager;
import org.datanucleus.store.hbase.HBaseManagedConnection;
import org.datanucleus.store.hbase.HBaseStoreManager;
import org.datanucleus.store.hbase.HBaseUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

public class HBasePersistenceHandler
implements StorePersistenceHandler {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.hbase.Localisation", (ClassLoader)HBaseStoreManager.class.getClassLoader());
    protected final HBaseStoreManager storeMgr;

    HBasePersistenceHandler(StoreManager storeMgr) {
        this.storeMgr = (HBaseStoreManager)storeMgr;
    }

    public void close() {
    }

    public void deleteObject(StateManager sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(sm.getObjectManager());
        try {
            AbstractClassMetaData acmd = sm.getClassMetaData();
            HTable table = mconn.getHTable(HBaseUtils.getTableName(acmd));
            table.delete(this.newDelete(sm));
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void fetchObject(StateManager sm, int[] fieldNumbers) {
        HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(sm.getObjectManager());
        try {
            AbstractClassMetaData acmd = sm.getClassMetaData();
            HTable table = mconn.getHTable(HBaseUtils.getTableName(acmd));
            Result result = this.getResult(sm, table);
            if (result.getRow() == null) {
                throw new NucleusObjectNotFoundException();
            }
            HBaseFetchFieldManager fm = new HBaseFetchFieldManager(sm, result);
            sm.replaceFields(acmd.getAllMemberPositions(), (FieldManager)fm);
            table.close();
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public Object findObject(ObjectManager om, Object id) {
        return null;
    }

    public void insertObject(StateManager sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        if (!this.storeMgr.managesClass(sm.getClassMetaData().getFullClassName())) {
            this.storeMgr.addClass(sm.getClassMetaData().getFullClassName(), sm.getObjectManager().getClassLoaderResolver());
        }
        try {
            this.locateObject(sm);
            throw new NucleusUserException(LOCALISER.msg("HBase.Insert.ObjectWithIdAlreadyExists", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
        }
        catch (NucleusObjectNotFoundException onfe) {
            HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(sm.getObjectManager());
            try {
                AbstractClassMetaData acmd = sm.getClassMetaData();
                HTable table = mconn.getHTable(HBaseUtils.getTableName(acmd));
                Put put = this.newPut(sm);
                Delete delete = this.newDelete(sm);
                HBaseInsertFieldManager fm = new HBaseInsertFieldManager(sm, put, delete);
                sm.provideFields(acmd.getAllMemberPositions(), (FieldManager)fm);
                table.put(put);
                table.close();
            }
            catch (IOException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            finally {
                mconn.release();
            }
            return;
        }
    }

    private Put newPut(StateManager sm) throws IOException {
        Object pkValue = sm.provideField(sm.getClassMetaData().getPKMemberPositions()[0]);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(pkValue);
        Put batch = new Put(bos.toByteArray());
        oos.close();
        bos.close();
        return batch;
    }

    private Delete newDelete(StateManager sm) throws IOException {
        Object pkValue = sm.provideField(sm.getClassMetaData().getPKMemberPositions()[0]);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(pkValue);
        Delete batch = new Delete(bos.toByteArray());
        oos.close();
        bos.close();
        return batch;
    }

    private Result getResult(StateManager sm, HTable table) throws IOException {
        Object pkValue = sm.provideField(sm.getClassMetaData().getPKMemberPositions()[0]);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(pkValue);
        Get get = new Get(bos.toByteArray());
        Result result = table.get(get);
        oos.close();
        bos.close();
        return result;
    }

    private boolean exists(StateManager sm, HTable table) throws IOException {
        Object pkValue = sm.provideField(sm.getClassMetaData().getPKMemberPositions()[0]);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(pkValue);
        Get get = new Get(bos.toByteArray());
        boolean result = table.exists(get);
        oos.close();
        bos.close();
        return result;
    }

    public void locateObject(StateManager sm) {
        HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(sm.getObjectManager());
        try {
            AbstractClassMetaData acmd = sm.getClassMetaData();
            HTable table = mconn.getHTable(HBaseUtils.getTableName(acmd));
            if (!this.exists(sm, table)) {
                throw new NucleusObjectNotFoundException();
            }
            table.close();
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void updateObject(StateManager sm, int[] fieldNumbers) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        HBaseManagedConnection mconn = (HBaseManagedConnection)this.storeMgr.getConnection(sm.getObjectManager());
        try {
            AbstractClassMetaData acmd = sm.getClassMetaData();
            HTable table = mconn.getHTable(HBaseUtils.getTableName(acmd));
            Put put = this.newPut(sm);
            Delete delete = this.newDelete(sm);
            HBaseInsertFieldManager fm = new HBaseInsertFieldManager(sm, put, delete);
            sm.provideFields(fieldNumbers, (FieldManager)fm);
            if (!put.isEmpty()) {
                table.put(put);
            }
            if (!put.isEmpty()) {
                table.delete(delete);
            }
            table.close();
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }
}

