/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Scanner;
import org.apache.hadoop.hbase.io.RowResult;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.hbase.HBaseFetchFieldManager;

public class HBaseUtils {
    public static String getTableName(AbstractClassMetaData acmd) {
        if (acmd.getTable() != null) {
            return acmd.getTable();
        }
        return acmd.getName();
    }

    public static String getColumnName(AbstractClassMetaData acmd, int fieldNumber) {
        AbstractMemberMetaData ammd = acmd.getMetaDataForManagedMemberAtPosition(fieldNumber);
        String columnName = null;
        ColumnMetaData[] colmds = ammd.getColumnMetaData();
        if (colmds != null && colmds.length > 0) {
            columnName = colmds[0].getName();
        }
        if (columnName == null) {
            columnName = ammd.getName();
        }
        return HBaseUtils.getTableName(acmd) + ":" + columnName;
    }

    public static List getObjectsOfCandidateType(final ObjectManager om, ManagedConnection mconn, Class candidateClass, boolean subclasses, boolean ignoreCache) {
        ArrayList<Object> results = new ArrayList<Object>();
        HBaseConfiguration config = (HBaseConfiguration)mconn.getConnection();
        try {
            final ClassLoaderResolver clr = om.getClassLoaderResolver();
            final AbstractClassMetaData acmd = om.getMetaDataManager().getMetaDataForClass(candidateClass, clr);
            HTable table = new HTable(config, HBaseUtils.getTableName(acmd));
            byte[][] columnNames = new byte[acmd.getMemberCount()][];
            for (int i = 0; i < acmd.getMemberCount(); ++i) {
                columnNames[i] = HBaseUtils.getColumnName(acmd, acmd.getManagedMembers()[i].getAbsoluteFieldNumber()).getBytes();
            }
            Scanner scanner = table.getScanner((byte[][])columnNames);
            for (final RowResult result : scanner) {
                results.add(om.findObjectUsingAID(clr.classForName(acmd.getFullClassName()), new FieldValues(){

                    public void fetchFields(StateManager sm) {
                        sm.replaceFields(acmd.getPKMemberPositions(), (FieldManager)new HBaseFetchFieldManager(sm, result));
                        sm.replaceFields(acmd.getBasicMemberPositions(clr, om.getMetaDataManager()), (FieldManager)new HBaseFetchFieldManager(sm, result));
                    }

                    public void fetchNonLoadedFields(StateManager sm) {
                        sm.replaceNonLoadedFields(acmd.getAllMemberPositions(), (FieldManager)new HBaseFetchFieldManager(sm, result));
                    }

                    public FetchPlan getFetchPlanForLoading() {
                        return null;
                    }
                }, ignoreCache, true));
            }
            table.getScanner(new String[]{"myColumnFamily:columnQualifier1"});
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        return results;
    }
}

