/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.sql.method;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.expression.GeometryExpression;

public class SpatialDistanceMethod2
implements SQLMethod {
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression expr, List args) {
        if (args == null) {
            throw new NucleusUserException("Cannot invoke Spatial.distance without arguments");
        }
        if (expr == null && args.size() != 2) {
            throw new NucleusUserException("Cannot invoke Spatial.distance without 2 arguments");
        }
        if (expr != null && args.size() != 1) {
            throw new NucleusUserException("Cannot invoke geom.distance without 1 argument");
        }
        SQLExpression argExpr1 = expr;
        SQLExpression argExpr2 = (SQLExpression)args.get(0);
        if (expr == null) {
            argExpr1 = (SQLExpression)args.get(0);
            argExpr2 = (SQLExpression)args.get(1);
        }
        ArrayList<SQLExpression> geomFunc1Args = new ArrayList<SQLExpression>();
        geomFunc1Args.add(argExpr1);
        GeometryExpression geom1Expr = new GeometryExpression(stmt, null, "geometry.from_sdo_geom", geomFunc1Args, null);
        ArrayList<SQLExpression> geomFunc2Args = new ArrayList<SQLExpression>();
        geomFunc2Args.add(argExpr2);
        GeometryExpression geom2Expr = new GeometryExpression(stmt, null, "geometry.from_sdo_geom", geomFunc2Args, null);
        ArrayList<GeometryExpression> funcArgs = new ArrayList<GeometryExpression>();
        funcArgs.add(geom1Expr);
        funcArgs.add(geom2Expr);
        JavaTypeMapping m = stmt.getSQLExpressionFactory().getMappingForType(Double.TYPE);
        return new NumericExpression(stmt, m, "distance", funcArgs);
    }
}

