/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.mapping;

import java.awt.geom.QuadCurve2D;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMultiMapping;
import org.datanucleus.store.rdbms.table.Table;

public class QuadCurve2dFloatMapping
extends SingleFieldMultiMapping {
    public void initialize(AbstractMemberMetaData fmd, Table table, ClassLoaderResolver clr) {
        super.initialize(fmd, table, clr);
        this.addColumns();
    }

    public void initialize(RDBMSStoreManager storeMgr, String type) {
        super.initialize(storeMgr, type);
        this.addColumns();
    }

    protected void addColumns() {
        this.addColumns(ClassNameConstants.FLOAT);
        this.addColumns(ClassNameConstants.FLOAT);
        this.addColumns(ClassNameConstants.FLOAT);
        this.addColumns(ClassNameConstants.FLOAT);
        this.addColumns(ClassNameConstants.FLOAT);
        this.addColumns(ClassNameConstants.FLOAT);
    }

    public Class getJavaType() {
        return QuadCurve2D.Float.class;
    }

    public Object getValueForColumnMapping(NucleusContext nucleusCtx, int index, Object value) {
        QuadCurve2D.Float qc = (QuadCurve2D.Float)value;
        if (index == 0) {
            return qc.getX1();
        }
        if (index == 1) {
            return qc.getY1();
        }
        if (index == 2) {
            return qc.getCtrlX();
        }
        if (index == 3) {
            return qc.getCtrlY();
        }
        if (index == 4) {
            return qc.getX2();
        }
        if (index == 5) {
            return qc.getY2();
        }
        throw new IndexOutOfBoundsException();
    }

    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, Object value) {
        QuadCurve2D.Float line = (QuadCurve2D.Float)value;
        if (line == null) {
            for (int i = 0; i < exprIndex.length; ++i) {
                this.getColumnMapping(i).setObject(ps, exprIndex[i], null);
            }
        } else {
            this.getColumnMapping(0).setFloat(ps, exprIndex[0], line.x1);
            this.getColumnMapping(1).setFloat(ps, exprIndex[1], line.y1);
            this.getColumnMapping(2).setFloat(ps, exprIndex[2], line.ctrlx);
            this.getColumnMapping(3).setFloat(ps, exprIndex[3], line.ctrly);
            this.getColumnMapping(4).setFloat(ps, exprIndex[4], line.x2);
            this.getColumnMapping(5).setFloat(ps, exprIndex[5], line.y2);
        }
    }

    public Object getObject(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (this.getColumnMapping(0).getObject(resultSet, exprIndex[0]) == null) {
            return null;
        }
        float x1 = this.getColumnMapping(0).getFloat(resultSet, exprIndex[0]);
        float y1 = this.getColumnMapping(1).getFloat(resultSet, exprIndex[1]);
        float ctrlx = this.getColumnMapping(2).getFloat(resultSet, exprIndex[2]);
        float ctrly = this.getColumnMapping(3).getFloat(resultSet, exprIndex[3]);
        float x2 = this.getColumnMapping(4).getFloat(resultSet, exprIndex[5]);
        float y2 = this.getColumnMapping(5).getFloat(resultSet, exprIndex[6]);
        return new QuadCurve2D.Float(x1, y1, ctrlx, ctrly, x2, y2);
    }
}

