/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.converters;

import java.awt.geom.Ellipse2D;
import java.util.StringTokenizer;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;

public class Ellipse2dDoubleStringConverter
implements TypeConverter<Ellipse2D.Double, String> {
    private static final long serialVersionUID = 3468739359296883796L;

    public Ellipse2D.Double toMemberType(String str) {
        if (str == null) {
            return null;
        }
        Ellipse2D.Double r = new Ellipse2D.Double();
        StringTokenizer tokeniser = new StringTokenizer(str.substring(1, str.length() - 1), ",");
        double x = 0.0;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                x = Double.valueOf(token);
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(Localiser.msg((String)"016002", (Object[])new Object[]{str, Ellipse2D.Double.class.getName()}), (Throwable)nfe);
            }
        } else {
            return null;
        }
        double y = 0.0;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                y = Double.valueOf(token);
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(Localiser.msg((String)"016002", (Object[])new Object[]{str, Ellipse2D.Double.class.getName()}), (Throwable)nfe);
            }
        } else {
            return null;
        }
        double width = 0.0;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                width = Double.valueOf(token);
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(Localiser.msg((String)"016002", (Object[])new Object[]{str, Ellipse2D.Double.class.getName()}), (Throwable)nfe);
            }
        } else {
            return null;
        }
        double height = 0.0;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                height = Double.valueOf(token);
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(Localiser.msg((String)"016002", (Object[])new Object[]{str, Ellipse2D.Double.class.getName()}), (Throwable)nfe);
            }
        } else {
            return null;
        }
        r.setFrame(x, y, width, height);
        return r;
    }

    public String toDatastoreType(Ellipse2D.Double rect) {
        return rect != null ? "(" + rect.getX() + "," + rect.getY() + "," + rect.getWidth() + "," + rect.getHeight() + ")" : null;
    }
}

