/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.wrappers;

import java.awt.geom.Point2D;
import org.datanucleus.FetchPlanState;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.types.SCO;

public class Point2dDouble
extends Point2D.Double
implements SCO<Point2D.Double> {
    private static final long serialVersionUID = 2414040714206923039L;
    protected transient ObjectProvider ownerOP;
    protected transient String fieldName;

    public Point2dDouble(ObjectProvider ownerOP, AbstractMemberMetaData mmd) {
        this.ownerOP = ownerOP;
        this.fieldName = mmd.getName();
    }

    public void initialise(Point2D.Double newValue, Object oldValue) {
        super.setLocation(newValue);
    }

    public void initialise(Point2D.Double value) {
        super.setLocation(value);
    }

    public void initialise() {
    }

    public Point2D.Double getValue() {
        return new Point2D.Double(this.getX(), this.getY());
    }

    public void unsetOwner() {
        this.ownerOP = null;
    }

    public Object getOwner() {
        return this.ownerOP != null ? this.ownerOP.getObject() : null;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void makeDirty() {
        if (this.ownerOP != null) {
            this.ownerOP.getExecutionContext().getApiAdapter().makeDirty(this.ownerOP.getObject(), this.fieldName);
        }
    }

    public Point2D.Double detachCopy(FetchPlanState state) {
        return new Point2D.Double(this.getX(), this.getY());
    }

    public void attachCopy(Point2D.Double value) {
        double oldX = this.getX();
        double oldY = this.getY();
        this.initialise(value, null);
        Point2dDouble rect = (Point2dDouble)value;
        double newX = rect.getX();
        double newY = rect.getY();
        if (oldX != newX || oldY != newY) {
            this.makeDirty();
        }
    }

    @Override
    public Object clone() {
        Object obj = super.clone();
        ((Point2dDouble)obj).unsetOwner();
        return obj;
    }

    @Override
    public void setLocation(double x, double y) {
        super.setLocation(x, y);
        this.makeDirty();
    }

    @Override
    public void setLocation(Point2D p) {
        super.setLocation(p);
        this.makeDirty();
    }
}

