/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.sql.method;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.store.types.geospatial.rdbms.sql.expression.GeometryExpression;
import org.datanucleus.store.types.geospatial.rdbms.sql.method.SpatialMethodHelper;

public class SpatialAsTextMethod2
implements SQLMethod {
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression expr, List args) {
        if (expr == null && (args == null || args.size() != 1)) {
            throw new NucleusUserException("Cannot invoke Spatial.asText without 1 argument");
        }
        if (expr != null && args != null && !args.isEmpty()) {
            throw new NucleusUserException("Cannot invoke geom.asText() with arguments");
        }
        SQLExpression argExpr = expr;
        if (expr == null) {
            argExpr = (SQLExpression)args.get(0);
        }
        ClassLoaderResolver clr = stmt.getQueryGenerator().getClassLoaderResolver();
        ArrayList<SQLExpression> geomFuncArgs = new ArrayList<SQLExpression>();
        geomFuncArgs.add(argExpr);
        GeometryExpression geomExpr = new GeometryExpression(stmt, SpatialMethodHelper.getGeometryMapping(clr, argExpr), "geometry.from_sdo_geom", geomFuncArgs, null);
        ArrayList<GeometryExpression> funcArgs = new ArrayList<GeometryExpression>();
        funcArgs.add(geomExpr);
        JavaTypeMapping m = stmt.getSQLExpressionFactory().getMappingForType(String.class, true);
        return new StringExpression(stmt, m, "asText", funcArgs);
    }
}

