/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.sql.method;

import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.CharacterLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;

public class SpatialMethodHelper {
    public static JavaTypeMapping getGeometryMapping(ClassLoaderResolver clr, SQLExpression expr) {
        String className;
        if (expr.getJavaTypeMapping() == null) {
            return null;
        }
        String geometryPackageName = expr.getJavaTypeMapping().getJavaType().getPackage().getName();
        if (geometryPackageName.equals("org.postgis")) {
            className = geometryPackageName + ".Geometry";
        } else if (geometryPackageName.equals("com.vividsolutions.jts.geom")) {
            className = geometryPackageName + ".Geometry";
        } else if (geometryPackageName.equals("oracle.spatial.geometry")) {
            className = geometryPackageName + ".JGeometry";
        } else {
            return null;
        }
        Class geometryClass = clr.classForName(className);
        if (geometryClass == null) {
            return null;
        }
        return expr.getSQLStatement().getRDBMSManager().getMappingManager().getMappingWithDatastoreMapping(geometryClass, false, false, clr);
    }

    public static BooleanExpression getBooleanExpression(SQLStatement stmt, String funcName, List funcArgs, SQLExpressionFactory exprFactory) {
        JavaTypeMapping boolMapping = exprFactory.getMappingForType(Boolean.TYPE, true);
        StringExpression left = new StringExpression(stmt, boolMapping, funcName, funcArgs);
        JavaTypeMapping charMapping = exprFactory.getMappingForType(Character.class, false);
        CharacterLiteral right = new CharacterLiteral(stmt, charMapping, (Object)Character.valueOf('1'), null);
        return new BooleanExpression((SQLExpression)left, Expression.OP_EQ, (SQLExpression)right);
    }
}

