/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.mapping.jts2mysql;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.types.geospatial.rdbms.mapping.mysql.MySQLSpatialRDBMSMapping;
import org.datanucleus.store.types.geospatial.rdbms.schema.MySQLSpatialTypeInfo;

public class GeometryRDBMSMapping
extends MySQLSpatialRDBMSMapping {
    private static final SQLTypeInfo typeInfo = (SQLTypeInfo)MySQLSpatialTypeInfo.TYPEINFO_PROTOTYPE.clone();

    public GeometryRDBMSMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(mapping, storeMgr, col);
    }

    public int getJDBCType() {
        return typeInfo.getDataType();
    }

    public SQLTypeInfo getTypeInfo() {
        return typeInfo;
    }

    public Object getObject(ResultSet rs, int exprIndex) {
        Geometry value;
        try {
            byte[] mysqlBinary = rs.getBytes(exprIndex);
            if (rs.wasNull() || mysqlBinary == null) {
                value = null;
            } else {
                WKBReader wkbReader = new WKBReader();
                value = wkbReader.read(this.mysqlBinaryToWkb(mysqlBinary));
                value.setSRID(this.mysqlBinaryToSrid(mysqlBinary));
            }
        }
        catch (Exception e) {
            throw new NucleusDataStoreException(this.failureMessage("getObject", exprIndex, e), (Throwable)e);
        }
        return value;
    }

    public void setObject(PreparedStatement ps, int exprIndex, Object value) {
        try {
            if (value == null) {
                ps.setNull(exprIndex, this.getTypeInfo().getDataType(), this.getTypeInfo().getTypeName());
            } else {
                WKBWriter wkbWriter = new WKBWriter(2, 2);
                byte[] wkb = wkbWriter.write((Geometry)value);
                int srid = ((Geometry)value).getSRID();
                ps.setBytes(exprIndex, this.wkbToMysqlBinary(wkb, srid));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(this.failureMessage("setObject", value, e), (Throwable)e);
        }
    }

    static {
        typeInfo.setTypeName("GEOMETRY");
        typeInfo.setLocalTypeName("GEOMETRY");
    }
}

