/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.awt.geom.Ellipse2D;
import java.util.StringTokenizer;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;

public class Ellipse2dFloatStringConverter
implements TypeConverter<Ellipse2D.Float, String> {
    public Ellipse2D.Float toMemberType(String str) {
        if (str == null) {
            return null;
        }
        Ellipse2D.Float r = new Ellipse2D.Float();
        StringTokenizer tokeniser = new StringTokenizer(str.substring(1, str.length() - 1), ",");
        float x = 0.0f;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                x = Float.valueOf(token).floatValue();
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Ellipse2D.Float.class.getName()), (Throwable)nfe);
            }
        } else {
            return null;
        }
        float y = 0.0f;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                y = Float.valueOf(token).floatValue();
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Ellipse2D.Float.class.getName()), (Throwable)nfe);
            }
        } else {
            return null;
        }
        float width = 0.0f;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                width = Float.valueOf(token).floatValue();
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Ellipse2D.Float.class.getName()), (Throwable)nfe);
            }
        } else {
            return null;
        }
        float height = 0.0f;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                height = Float.valueOf(token).floatValue();
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Ellipse2D.Float.class.getName()), (Throwable)nfe);
            }
        } else {
            return null;
        }
        r.setFrame(x, y, width, height);
        return r;
    }

    public String toDatastoreType(Ellipse2D.Float rect) {
        return rect != null ? "(" + rect.getX() + "," + rect.getY() + "," + rect.getWidth() + "," + rect.getHeight() + ")" : null;
    }
}

