/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache.redis;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.datanucleus.Configuration;
import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryUtils;
import org.datanucleus.store.query.cache.AbstractQueryResultsCache;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.util.Pool;

public class RedisQueryResultsCache
extends AbstractQueryResultsCache {
    private static final long serialVersionUID = 491530711712812608L;
    public static final String PROPERTY_CACHE_QUERYRESULTS_REDIS_DATABASE = "datanucleus.cache.queryResults.redis.database";
    public static final String PROPERTY_CACHE_QUERYRESULTS_REDIS_TIMEOUT = "datanucleus.cache.queryResults.redis.timeout";
    public static final String PROPERTY_CACHE_QUERYRESULTS_REDIS_SENTINELS = "datanucleus.cache.queryResults.redis.sentinels";
    public static final String PROPERTY_CACHE_QUERYRESULTS_REDIS_SERVER = "datanucleus.cache.queryResults.redis.server";
    public static final String PROPERTY_CACHE_QUERYRESULTS_REDIS_PORT = "datanucleus.cache.queryResults.redis.port";
    Pool<Jedis> pool;
    int expirySeconds;
    private static final String DEFAULT_SERVER = "localhost";
    private static final int DEFAULT_DATABASE = 1;
    private static final int DEFAULT_PORT = 6379;
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final String KEY_PREFIX = "datanucleus-query:";

    public RedisQueryResultsCache(NucleusContext nucleusCtx) {
        super(nucleusCtx);
        Configuration conf = nucleusCtx.getConfiguration();
        int database = conf.getIntProperty(PROPERTY_CACHE_QUERYRESULTS_REDIS_DATABASE);
        database = database == 0 ? 1 : database;
        this.expirySeconds = (int)(this.expiryMillis / 1000L);
        int timeout = conf.getIntProperty(PROPERTY_CACHE_QUERYRESULTS_REDIS_TIMEOUT);
        timeout = timeout == 0 ? 5000 : timeout;
        String sentinelsStr = conf.getStringProperty(PROPERTY_CACHE_QUERYRESULTS_REDIS_SENTINELS);
        if (sentinelsStr != null && sentinelsStr.length() > 0) {
            LinkedHashSet<String> sentinels = new LinkedHashSet<String>();
            sentinels.addAll(Arrays.asList(sentinelsStr.split(",")));
            this.pool = new JedisSentinelPool("mymaster", sentinels, new GenericObjectPoolConfig(), timeout, null, database);
        } else {
            String server = conf.getStringProperty(PROPERTY_CACHE_QUERYRESULTS_REDIS_SERVER);
            int port = conf.getIntProperty(PROPERTY_CACHE_QUERYRESULTS_REDIS_PORT);
            server = server == null ? DEFAULT_SERVER : server;
            port = port == 0 ? 6379 : port;
            this.pool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), server, port, timeout, null, database);
        }
    }

    public void close() {
        if (this.clearAtClose) {
            try {
                Jedis jedis = (Jedis)this.pool.getResource();
                jedis.flushDB();
                jedis.close();
                this.pool.close();
            }
            catch (Exception e) {
                throw new NucleusException("Could not close connection to Redis cache", (Throwable)e);
            }
        }
        try {
            this.pool.close();
        }
        catch (Exception e) {
            throw new NucleusException("Could not close connection to Redis cache", (Throwable)e);
        }
    }

    public void evict(Class candidate) {
    }

    public void evict(Query query) {
        Jedis jedis = null;
        String key = null;
        try {
            jedis = (Jedis)this.pool.getResource();
            key = QueryUtils.getKeyForQueryResultsCache((Query)query, null);
            jedis.del(key);
            this.pool.returnResource((Object)jedis);
        }
        catch (Exception e) {
            this.pool.returnBrokenResource((Object)jedis);
            throw new NucleusException(String.format("Failed to evict key %s from Redis cache", key), (Throwable)e);
        }
    }

    public void evict(Query query, Map params) {
        Jedis jedis = null;
        String key = null;
        try {
            jedis = (Jedis)this.pool.getResource();
            key = QueryUtils.getKeyForQueryResultsCache((Query)query, (Map)params);
            jedis.del(key);
            this.pool.returnResource((Object)jedis);
        }
        catch (Exception e) {
            this.pool.returnBrokenResource((Object)jedis);
            throw new NucleusException(String.format("Failed to evict key %s from Redis cache", key), (Throwable)e);
        }
    }

    public void evictAll() {
        Jedis jedis = null;
        try {
            jedis = (Jedis)this.pool.getResource();
            jedis.flushDB();
            this.pool.returnResource((Object)jedis);
        }
        catch (Exception e) {
            this.pool.returnBrokenResource((Object)jedis);
            throw new NucleusException("Failed to evict-all from Redis cache", (Throwable)e);
        }
    }

    public List<Object> get(String queryKey) {
        Object value;
        String key = KEY_PREFIX + queryKey;
        Jedis jedis = null;
        try {
            jedis = (Jedis)this.pool.getResource();
            value = this.getObjectFromBytes(jedis.get(key.getBytes()));
            this.pool.returnResource((Object)jedis);
        }
        catch (Exception e) {
            this.pool.returnBrokenResource((Object)jedis);
            throw new NucleusException("Failed to get from Redis cache", (Throwable)e);
        }
        return (List)value;
    }

    public List<Object> put(String queryKey, List<Object> results) {
        if (queryKey == null || results == null) {
            return null;
        }
        Jedis jedis = null;
        String key = KEY_PREFIX + queryKey;
        try {
            jedis = (Jedis)this.pool.getResource();
            jedis.setex(key.getBytes(), this.expirySeconds, this.getBytesForObject(results));
            this.pool.returnResource((Object)jedis);
        }
        catch (Exception e) {
            this.pool.returnBrokenResource((Object)jedis);
            throw new NucleusException(String.format("Failed to set object %s with ID %s into Redis cache", results, queryKey));
        }
        return results;
    }

    public boolean contains(String queryKey) {
        return this.get(KEY_PREFIX + queryKey) != null;
    }

    private Object getObjectFromBytes(byte[] bytes) {
        Object o = null;
        if (bytes != null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream in = null;
            try {
                in = new ObjectInputStream(bis);
                o = in.readObject();
            }
            catch (IOException | ClassNotFoundException e) {
                throw new NucleusException("Failed to convert object", (Throwable)e);
            }
            finally {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return o;
    }

    private byte[] getBytesForObject(Object obj) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objStream = new ObjectOutputStream(bos);
            objStream.writeObject(obj);
        }
        catch (IOException e) {
            throw new NucleusException("Exception in serializing Object for Redis cache", (Throwable)e);
        }
        return bos.toByteArray();
    }
}

