/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache.cacheonix;

import cacheonix.Cacheonix;
import cacheonix.cache.Cache;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.Configuration;
import org.datanucleus.NucleusContext;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryUtils;
import org.datanucleus.store.query.cache.AbstractQueryResultsCache;

public class CacheonixQueryResultCache
extends AbstractQueryResultsCache {
    private static final long serialVersionUID = -7951373996155521704L;
    Cacheonix cacheManager;
    Cache<Serializable, Serializable> queryCache;

    public CacheonixQueryResultCache(NucleusContext nucleusCtx) {
        super(nucleusCtx);
        Configuration conf = nucleusCtx.getConfiguration();
        String configFile = conf.getStringProperty("datanucleus.cache.queryResults.configurationFile");
        this.cacheManager = configFile == null ? Cacheonix.getInstance() : Cacheonix.getInstance((String)configFile);
        this.queryCache = this.cacheManager.getCache(this.cacheName);
    }

    public void close() {
        this.evictAll();
        this.cacheManager.shutdown();
    }

    public void evict(Class candidate) {
    }

    public void evict(Query query) {
        String baseKey = QueryUtils.getKeyForQueryResultsCache((Query)query, null);
        Iterator iter = this.queryCache.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith(baseKey)) continue;
            iter.remove();
        }
    }

    public void evict(Query query, Map params) {
        String key = QueryUtils.getKeyForQueryResultsCache((Query)query, (Map)params);
        this.queryCache.remove((Object)key);
    }

    public void evictAll() {
        this.queryCache.clear();
    }

    public int size() {
        return this.queryCache.size();
    }

    public List<Object> get(String queryKey) {
        return (List)((Object)this.queryCache.get((Object)queryKey));
    }

    public List<Object> put(String queryKey, List<Object> results) {
        if (queryKey == null || results == null) {
            return null;
        }
        if (this.expiryMillis > 0L) {
            this.queryCache.put((Serializable)((Object)queryKey), (Serializable)((Object)results), this.expiryMillis);
        } else {
            this.queryCache.put((Serializable)((Object)queryKey), (Serializable)((Object)results));
        }
        return results;
    }

    public boolean contains(String queryKey) {
        return this.get(queryKey) != null;
    }
}

