/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache.redis;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.datanucleus.Configuration;
import org.datanucleus.NucleusContext;
import org.datanucleus.cache.AbstractLevel2Cache;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.identity.SingleFieldId;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.util.Pool;

public class RedisLevel2Cache
extends AbstractLevel2Cache {
    private static final long serialVersionUID = 4428364640009394044L;
    public static final String PROPERTY_CACHE_L2_REDIS_DATABASE = "datanucleus.cache.level2.redis.database";
    public static final String PROPERTY_CACHE_L2_REDIS_TIMEOUT = "datanucleus.cache.level2.redis.timeout";
    public static final String PROPERTY_CACHE_L2_REDIS_SENTINELS = "datanucleus.cache.level2.redis.sentinels";
    public static final String PROPERTY_CACHE_L2_REDIS_SERVER = "datanucleus.cache.level2.redis.server";
    public static final String PROPERTY_CACHE_L2_REDIS_PORT = "datanucleus.cache.level2.redis.port";
    private Pool<Jedis> pool;
    private int expirySeconds;
    private static final String DEFAULT_SERVER = "localhost";
    private static final int DEFAULT_DATABASE = 1;
    private static final int DEFAULT_PORT = 6379;
    private static final int DEFAULT_TIMEOUT = 5000;

    public RedisLevel2Cache(NucleusContext nucleusCtx) {
        super(nucleusCtx);
        Configuration conf = nucleusCtx.getConfiguration();
        int database = conf.getIntProperty(PROPERTY_CACHE_L2_REDIS_DATABASE);
        database = database == 0 ? 1 : database;
        int timeout = conf.getIntProperty(PROPERTY_CACHE_L2_REDIS_TIMEOUT);
        timeout = timeout == 0 ? 5000 : timeout;
        this.expirySeconds = (int)(this.expiryMillis / 1000L);
        String sentinelsStr = conf.getStringProperty(PROPERTY_CACHE_L2_REDIS_SENTINELS);
        if (sentinelsStr != null && sentinelsStr.length() > 0) {
            LinkedHashSet<String> sentinels = new LinkedHashSet<String>();
            sentinels.addAll(Arrays.asList(sentinelsStr.split(",")));
            this.pool = new JedisSentinelPool("mymaster", sentinels, new GenericObjectPoolConfig(), timeout, null, database);
        } else {
            String server = conf.getStringProperty(PROPERTY_CACHE_L2_REDIS_SERVER);
            int port = conf.getIntProperty(PROPERTY_CACHE_L2_REDIS_PORT);
            server = server == null ? DEFAULT_SERVER : server;
            port = port == 0 ? 6379 : port;
            this.pool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), server, port, timeout, null, database);
        }
    }

    public void close() {
        if (this.clearAtClose) {
            try {
                Jedis jedis = (Jedis)this.pool.getResource();
                jedis.flushDB();
                jedis.close();
                this.pool.close();
            }
            catch (Exception e) {
                throw new NucleusException("Error closing connection to Redis cache", (Throwable)e);
            }
        }
        try {
            this.pool.close();
        }
        catch (Exception e) {
            throw new NucleusException("Error closing connection to Redis cache", (Throwable)e);
        }
    }

    public void evict(Object oid) {
        Jedis jedis = null;
        try {
            jedis = (Jedis)this.pool.getResource();
            jedis.del(this.getCacheKeyForId(oid).getBytes());
            this.pool.returnResource((Object)jedis);
        }
        catch (Exception e) {
            this.pool.returnBrokenResource((Object)jedis);
            throw new NucleusException(String.format("Failed to evict key %s from Redis cache", oid), (Throwable)e);
        }
    }

    public void evictAll() {
        Jedis jedis = null;
        try {
            jedis = (Jedis)this.pool.getResource();
            jedis.flushDB();
            this.pool.returnResource((Object)jedis);
        }
        catch (Exception e) {
            this.pool.returnBrokenResource((Object)jedis);
            throw new NucleusException("Failed to evict-all from Redis cache", (Throwable)e);
        }
    }

    public void evictAll(Object[] objects) {
        Jedis jedis = null;
        jedis = (Jedis)this.pool.getResource();
        for (Object oid : objects) {
            try {
                jedis.del(this.getCacheKeyForId(oid).getBytes());
            }
            catch (Exception e) {
                this.pool.returnBrokenResource((Object)jedis);
                throw new NucleusException(String.format("Failed to evict keys %s from cache {0}", objects), (Throwable)e);
            }
        }
        this.pool.returnResource((Object)jedis);
    }

    public void evictAll(Collection collection) {
        this.evictAll(collection.toArray());
    }

    public void evictAll(Class aClass, boolean b) {
    }

    public CachedPC get(Object oid) {
        Object value;
        Jedis jedis = null;
        try {
            jedis = (Jedis)this.pool.getResource();
            value = this.getObjectInternal(jedis.get(this.getCacheKeyForId(oid).getBytes()));
            this.pool.returnResource((Object)jedis);
        }
        catch (Exception e) {
            this.pool.returnBrokenResource((Object)jedis);
            throw new NucleusException(String.format("Failed to get key %s from cache {0}", oid), (Throwable)e);
        }
        return (CachedPC)value;
    }

    private Object getObjectInternal(byte[] bytes) {
        Object o = null;
        if (bytes != null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream in = null;
            try {
                in = new ObjectInputStream(bis);
                o = in.readObject();
            }
            catch (IOException | ClassNotFoundException e) {
                throw new NucleusException("Failed to convert object", (Throwable)e);
            }
            finally {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return o;
    }

    public CachedPC put(Object o, CachedPC cachedPC) {
        if (o == null || cachedPC == null) {
            return null;
        }
        Jedis jedis = null;
        try {
            jedis = (Jedis)this.pool.getResource();
            jedis.setex(this.getCacheKeyForId(o).getBytes(), this.expirySeconds, this.getBytesForObject(cachedPC));
            this.pool.returnResource((Object)jedis);
        }
        catch (Exception e) {
            this.pool.returnBrokenResource((Object)jedis);
            throw new NucleusException(String.format("Failed to set object %s with id %s into Redis cache", cachedPC, o));
        }
        return cachedPC;
    }

    public boolean containsOid(Object o) {
        return this.get(o) != null;
    }

    protected byte[] getBytesForObject(Object obj) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream outputStream = new ObjectOutputStream(bos);
        outputStream.writeObject(obj);
        return bos.toByteArray();
    }

    protected String getCacheKeyForId(Object id) {
        if (IdentityUtils.isSingleFieldIdentity((Object)id)) {
            String targetClassName = ((SingleFieldId)id).getTargetClassName();
            return this.cacheName + targetClassName + ":" + id.toString().hashCode();
        }
        return this.cacheName + id.toString().hashCode();
    }
}

