/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache.cacheonix;

import cacheonix.Cacheonix;
import cacheonix.cache.Cache;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.Configuration;
import org.datanucleus.NucleusContext;
import org.datanucleus.cache.AbstractLevel2Cache;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.util.NucleusLogger;

public class CacheonixLevel2Cache
extends AbstractLevel2Cache {
    private static final long serialVersionUID = -4980918853861817672L;
    Cacheonix cacheManager;
    final Map<String, Cache> caches = new HashMap<String, Cache>();
    Cache<Serializable, Serializable> defaultCache;

    public CacheonixLevel2Cache(NucleusContext nucleusCtx) {
        super(nucleusCtx);
        Configuration conf = nucleusCtx.getConfiguration();
        String configFile = conf.getStringProperty("datanucleus.cache.level2.configurationFile");
        this.cacheManager = configFile == null ? Cacheonix.getInstance() : Cacheonix.getInstance((String)configFile);
        this.defaultCache = this.cacheManager.getCache(this.cacheName);
        if (this.defaultCache == null) {
            this.defaultCache = this.cacheManager.createCache(this.cacheName);
        }
    }

    public void close() {
        if (this.clearAtClose) {
            this.evictAll();
        }
        this.cacheManager.shutdown();
    }

    public void evict(Object oid) {
        CachedPC pc = this.get(oid);
        if (pc != null) {
            this.getCacheForId(oid).remove(oid);
        }
    }

    public void evictAll() {
        Iterator<Cache> i = this.caches.values().iterator();
        while (i.hasNext()) {
            i.next().clear();
        }
        this.defaultCache.clear();
    }

    public void evictAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        for (int i = 0; i < oids.length; ++i) {
            this.evict(oids[i]);
        }
    }

    public void evictAll(Collection oids) {
        if (oids == null) {
            return;
        }
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            this.evict(iter.next());
        }
    }

    public void evictAll(Class pcClass, boolean subclasses) {
        String[] subclassNames;
        if (!this.nucleusCtx.getApiAdapter().isPersistable(pcClass)) {
            return;
        }
        this.evictAllOfClass(pcClass.getName());
        if (subclasses && (subclassNames = this.nucleusCtx.getMetaDataManager().getSubclassesForClass(pcClass.getName(), true)) != null) {
            for (int i = 0; i < subclassNames.length; ++i) {
                this.evictAllOfClass(subclassNames[i]);
            }
        }
    }

    void evictAllOfClass(String className) {
        AbstractClassMetaData cmd = this.nucleusCtx.getMetaDataManager().getMetaDataForClass(className, this.nucleusCtx.getClassLoaderResolver(null));
        Cache cache = null;
        if (cmd.usesSingleFieldIdentityClass() || cmd.getIdentityType() == IdentityType.DATASTORE) {
            cache = this.caches.get(cmd.getFullClassName());
            cache.clear();
        } else {
            cache = this.defaultCache;
            Iterator keyIter = cache.keySet().iterator();
            while (keyIter.hasNext()) {
                String targetClassName;
                Object key = keyIter.next();
                if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                    targetClassName = IdentityUtils.getTargetClassNameForIdentity(key);
                    if (!className.equals(targetClassName)) continue;
                    keyIter.remove();
                    continue;
                }
                if (cmd.getIdentityType() != IdentityType.DATASTORE || !className.equals(targetClassName = IdentityUtils.getTargetClassNameForIdentity(key))) continue;
                keyIter.remove();
            }
        }
    }

    public int getSize() {
        int size = this.defaultCache.size();
        Iterator<Cache> i = this.caches.values().iterator();
        while (i.hasNext()) {
            size += i.next().size();
        }
        return size;
    }

    public CachedPC get(Object oid) {
        return (CachedPC)this.getCacheForId(oid).get(oid);
    }

    public CachedPC put(Object oid, CachedPC pc) {
        if (oid == null || pc == null) {
            return null;
        }
        if (this.maxSize >= 0 && this.getSize() == this.maxSize) {
            return null;
        }
        try {
            if (this.timeout > 0L) {
                this.getCacheForId(oid).put((Serializable)oid, (Serializable)pc, this.timeout);
            } else {
                this.getCacheForId(oid).put(oid, (Object)pc);
            }
        }
        catch (RuntimeException re) {
            NucleusLogger.CACHE.debug((Object)("Object with id " + oid + " not cached due to : " + re.getMessage()));
        }
        return pc;
    }

    public boolean containsOid(Object oid) {
        try {
            return this.get(oid) != null;
        }
        catch (IllegalStateException e) {
            NucleusLogger.CACHE.warn((Object)("Error invoking Cache.containsOid : " + e.getMessage()));
            return false;
        }
    }

    private Cache<Serializable, Serializable> getCacheForClass(String cacheName) {
        Cache cache = this.caches.get(cacheName);
        if (cache == null) {
            cache = this.cacheManager.getCache(cacheName);
            if (cache == null) {
                cache = this.cacheManager.createCache(cacheName);
            }
            this.caches.put(cacheName, cache);
        }
        return cache;
    }

    private Cache getCacheForId(Object id) {
        if (IdentityUtils.isSingleFieldIdentity((Object)id) || IdentityUtils.isDatastoreIdentity((Object)id)) {
            return this.getCacheForClass(IdentityUtils.getTargetClassNameForIdentity((Object)id));
        }
        return this.defaultCache;
    }
}

