/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache.jcache;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.jsr107cache.Cache;
import net.sf.jsr107cache.CacheException;
import net.sf.jsr107cache.CacheManager;
import org.datanucleus.NucleusContext;
import org.datanucleus.cache.AbstractLevel2Cache;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.OID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.util.NucleusLogger;

public class JCacheLevel2Cache
extends AbstractLevel2Cache {
    private final Cache cache;

    public JCacheLevel2Cache(NucleusContext nucleusCtx) {
        super(nucleusCtx);
        try {
            Cache tmpcache = CacheManager.getInstance().getCache(this.cacheName);
            if (tmpcache == null) {
                HashMap<Integer, Long> props = new HashMap<Integer, Long>();
                if (this.timeout > 0L) {
                    props.put(1, this.timeout);
                }
                this.cache = CacheManager.getInstance().getCacheFactory().createCache(props);
                CacheManager.getInstance().registerCache(this.cacheName, this.cache);
            } else {
                this.cache = tmpcache;
            }
        }
        catch (CacheException e) {
            throw new NucleusException("Error creating cache", (Throwable)e);
        }
    }

    public void close() {
        if (this.clearAtClose) {
            this.evictAll();
        }
    }

    public boolean containsOid(Object oid) {
        return this.get(oid) != null;
    }

    public CachedPC get(Object oid) {
        return (CachedPC)this.cache.get(oid);
    }

    public Map<Object, CachedPC> getAll(Collection oids) {
        try {
            return this.cache.getAll(oids);
        }
        catch (CacheException ce) {
            throw new NucleusException("Exception occurred during get from cache", (Throwable)ce);
        }
    }

    public int getSize() {
        throw new UnsupportedOperationException("size() method not supported by this plugin");
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public synchronized CachedPC put(Object oid, CachedPC pc) {
        if (oid == null || pc == null) {
            return null;
        }
        if (this.maxSize >= 0 && this.getSize() == this.maxSize) {
            return null;
        }
        try {
            this.cache.put(oid, (Object)pc);
        }
        catch (RuntimeException re) {
            NucleusLogger.CACHE.info((Object)("Object with id " + oid + " not cached due to : " + re.getMessage()));
        }
        return pc;
    }

    public void putAll(Map<Object, CachedPC> objs) {
        if (objs == null) {
            return;
        }
        try {
            this.cache.putAll(objs);
        }
        catch (RuntimeException re) {
            NucleusLogger.CACHE.info((Object)("Objects not cached due to : " + re.getMessage()));
        }
    }

    public synchronized void evict(Object oid) {
        this.cache.remove(oid);
    }

    public synchronized void evictAll() {
        this.cache.clear();
    }

    public synchronized void evictAll(Collection oids) {
        if (oids == null) {
            return;
        }
        for (Object oid : oids) {
            this.cache.remove(oid);
        }
    }

    public synchronized void evictAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        for (int i = 0; i < oids.length; ++i) {
            this.cache.remove(oids[i]);
        }
    }

    public synchronized void evictAll(Class pcClass, boolean subclasses) {
        String[] subclassNames;
        if (!this.nucleusCtx.getApiAdapter().isPersistable(pcClass)) {
            return;
        }
        this.evictAllOfClass(pcClass.getName());
        if (subclasses && (subclassNames = this.nucleusCtx.getMetaDataManager().getSubclassesForClass(pcClass.getName(), true)) != null) {
            for (int i = 0; i < subclassNames.length; ++i) {
                this.evictAllOfClass(subclassNames[i]);
            }
        }
    }

    void evictAllOfClass(String className) {
        AbstractClassMetaData cmd = this.nucleusCtx.getMetaDataManager().getMetaDataForClass(className, this.nucleusCtx.getClassLoaderResolver(null));
        Iterator entryIter = this.cache.entrySet().iterator();
        while (entryIter.hasNext()) {
            OID oid;
            Map.Entry entry = (Map.Entry)entryIter.next();
            Object key = entry.getKey();
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                String targetClassName = this.nucleusCtx.getApiAdapter().getTargetClassNameForSingleFieldIdentity(key);
                if (!className.equals(targetClassName)) continue;
                entryIter.remove();
                continue;
            }
            if (cmd.getIdentityType() != IdentityType.DATASTORE || !(key instanceof OID) || !className.equals((oid = (OID)key).getPcClass())) continue;
            entryIter.remove();
        }
    }
}

