/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache.memcache;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.MemcachedClient;
import org.datanucleus.OMFContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.cache.QueryResultsCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemcacheQueryResultCache
implements QueryResultsCache {
    private MemcachedClient client;
    private String keyPrefix = "datanucleus-query:";
    private int expireSeconds = 0;

    public MemcacheQueryResultCache(OMFContext omfCtx) {
        PersistenceConfiguration conf = omfCtx.getPersistenceConfiguration();
        String keyPrefix = conf.getStringProperty("datanucleus.cache.query.memcache.keyprefix");
        String servers = conf.getStringProperty("datanucleus.cache.query.memcache.servers");
        String expireStr = conf.getStringProperty("datanucleus.cache.query.memcache.expireSeconds");
        if (keyPrefix != null) {
            this.keyPrefix = keyPrefix;
        }
        try {
            this.client = new MemcachedClient(AddrUtil.getAddresses((String)servers));
            if (expireStr != null && !"".equals(expireStr)) {
                this.expireSeconds = Integer.parseInt(expireStr);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new NucleusException("Cant create cache", (Throwable)e);
        }
        catch (NumberFormatException ex) {
            throw new NucleusException("Cant create cache: Bad expireSeconds value:" + expireStr, (Throwable)ex);
        }
    }

    public void close() {
        this.client.shutdown();
    }

    public boolean contains(String queryKey) {
        return this.get(queryKey) != null;
    }

    public synchronized void evict(Query query) {
        String baseKey = QueryUtils.getKeyForQueryResultsCache((Query)query, null);
        this.client.delete(this.keyPrefix + baseKey);
    }

    public synchronized void evict(Query query, Map params) {
        String key = QueryUtils.getKeyForQueryResultsCache((Query)query, (Map)params);
        this.client.delete(this.keyPrefix + key);
    }

    public synchronized void evictAll() {
        this.client.flush();
    }

    public List<Object> get(String queryKey) {
        return (List)this.client.get(this.keyPrefix + queryKey);
    }

    public boolean isEmpty() {
        throw new UnsupportedOperationException("isEmpty() method not supported by Memcache plugin");
    }

    public synchronized List<Object> put(String queryKey, List<Object> results) {
        if (queryKey == null || results == null) {
            return null;
        }
        this.client.set(this.keyPrefix + queryKey, this.expireSeconds, results);
        return results;
    }

    public int size() {
        throw new UnsupportedOperationException("size() method not supported by Memcache plugin");
    }
}

