/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.state;

import org.datanucleus.FetchPlan;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.state.IllegalStateTransitionException;
import org.datanucleus.state.LifeCycleState;
import org.datanucleus.transaction.Transaction;
import org.datanucleus.util.Localiser;

class PersistentNontransactional
extends LifeCycleState {
    protected PersistentNontransactional() {
        this.isPersistent = true;
        this.isDirty = false;
        this.isNew = false;
        this.isDeleted = false;
        this.isTransactional = false;
        this.stateType = 9;
    }

    public LifeCycleState transitionDeletePersistent(DNStateManager sm) {
        return this.changeState(sm, 8);
    }

    public LifeCycleState transitionMakeTransactional(DNStateManager sm, boolean refreshFields) {
        if (refreshFields) {
            sm.refreshLoadedFields();
        }
        return this.changeState(sm, 2);
    }

    public LifeCycleState transitionMakeTransient(DNStateManager sm, boolean useFetchPlan, boolean detachAllOnCommit) {
        if (useFetchPlan) {
            sm.loadUnloadedFieldsInFetchPlan();
        }
        return this.changeState(sm, 0);
    }

    public LifeCycleState transitionCommit(DNStateManager sm, Transaction tx) {
        throw new IllegalStateTransitionException((LifeCycleState)this, "commit", sm);
    }

    public LifeCycleState transitionRollback(DNStateManager sm, Transaction tx) {
        throw new IllegalStateTransitionException((LifeCycleState)this, "rollback", sm);
    }

    public LifeCycleState transitionRefresh(DNStateManager sm) {
        sm.refreshFieldsInFetchPlan();
        sm.unloadNonFetchPlanFields();
        return this;
    }

    public LifeCycleState transitionEvict(DNStateManager sm) {
        sm.clearNonPrimaryKeyFields();
        sm.clearSavedFields();
        return this.changeState(sm, 4);
    }

    public LifeCycleState transitionReadField(DNStateManager sm, boolean isLoaded) {
        Transaction tx = sm.getExecutionContext().getTransaction();
        if (!tx.isActive() && !tx.getNontransactionalRead()) {
            throw new NucleusUserException(Localiser.msg((String)"027002"), sm.getInternalObjectId());
        }
        if (tx.isActive() && !tx.getOptimistic()) {
            sm.saveFields();
            sm.refreshLoadedFields();
            return this.changeState(sm, 2);
        }
        return this;
    }

    public LifeCycleState transitionWriteField(DNStateManager sm) {
        Transaction tx = sm.getExecutionContext().getTransaction();
        if (!tx.isActive() && !tx.getNontransactionalWrite()) {
            throw new NucleusUserException(Localiser.msg((String)"027001"), sm.getInternalObjectId());
        }
        if (tx.isActive()) {
            sm.saveFields();
            return this.changeState(sm, 3);
        }
        return this;
    }

    public LifeCycleState transitionRetrieve(DNStateManager sm, boolean fgOnly) {
        Transaction tx = sm.getExecutionContext().getTransaction();
        if (tx.isActive() && !tx.getOptimistic()) {
            sm.saveFields();
            if (fgOnly) {
                sm.loadUnloadedFieldsInFetchPlan();
            } else {
                sm.loadUnloadedFields();
            }
            return this.changeState(sm, 2);
        }
        if (tx.isActive() && tx.getOptimistic()) {
            sm.saveFields();
            if (fgOnly) {
                sm.loadUnloadedFieldsInFetchPlan();
            } else {
                sm.loadUnloadedFields();
            }
            return this;
        }
        if (fgOnly) {
            sm.loadUnloadedFieldsInFetchPlan();
        } else {
            sm.loadUnloadedFields();
        }
        return this;
    }

    public LifeCycleState transitionRetrieve(DNStateManager sm, FetchPlan fetchPlan) {
        Transaction tx = sm.getExecutionContext().getTransaction();
        if (tx.isActive() && !tx.getOptimistic()) {
            sm.saveFields();
            sm.loadUnloadedFieldsOfClassInFetchPlan(fetchPlan);
            return this.changeState(sm, 2);
        }
        if (tx.isActive() && tx.getOptimistic()) {
            sm.saveFields();
            sm.loadUnloadedFieldsOfClassInFetchPlan(fetchPlan);
            return this;
        }
        sm.loadUnloadedFieldsOfClassInFetchPlan(fetchPlan);
        return this;
    }

    public LifeCycleState transitionSerialize(DNStateManager sm) {
        Transaction tx = sm.getExecutionContext().getTransaction();
        if (tx.isActive() && !tx.getOptimistic()) {
            return this.changeState(sm, 2);
        }
        return this;
    }

    public LifeCycleState transitionDetach(DNStateManager sm) {
        return this.changeState(sm, 11);
    }

    public String toString() {
        return "P_NONTRANS";
    }
}

