/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.criteria;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.persistence.Tuple;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.CompoundSelection;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.SetJoin;
import javax.persistence.criteria.Subquery;
import org.datanucleus.api.jpa.JPAEntityManagerFactory;
import org.datanucleus.api.jpa.criteria.CaseExpressionImpl;
import org.datanucleus.api.jpa.criteria.CoalesceExpression;
import org.datanucleus.api.jpa.criteria.CompoundSelectionImpl;
import org.datanucleus.api.jpa.criteria.ConcatExpression;
import org.datanucleus.api.jpa.criteria.CriteriaDeleteImpl;
import org.datanucleus.api.jpa.criteria.CriteriaQueryImpl;
import org.datanucleus.api.jpa.criteria.CriteriaUpdateImpl;
import org.datanucleus.api.jpa.criteria.ExpressionImpl;
import org.datanucleus.api.jpa.criteria.InPredicate;
import org.datanucleus.api.jpa.criteria.LiteralExpression;
import org.datanucleus.api.jpa.criteria.OrderImpl;
import org.datanucleus.api.jpa.criteria.ParameterExpressionImpl;
import org.datanucleus.api.jpa.criteria.PathImpl;
import org.datanucleus.api.jpa.criteria.PredicateImpl;
import org.datanucleus.api.jpa.criteria.RootImpl;
import org.datanucleus.api.jpa.criteria.SimpleCaseExpressionImpl;
import org.datanucleus.api.jpa.criteria.SubqueryImpl;
import org.datanucleus.api.jpa.criteria.TreatPathImpl;
import org.datanucleus.api.jpa.criteria.TreatRootImpl;
import org.datanucleus.query.expression.CreatorExpression;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.SubqueryExpression;
import org.datanucleus.query.expression.VariableExpression;

public class CriteriaBuilderImpl
implements CriteriaBuilder,
Serializable {
    static final long serialVersionUID = -1798682551615240941L;
    JPAEntityManagerFactory emf;
    private static long PARAM_NUMBER = 0L;

    public CriteriaBuilderImpl(JPAEntityManagerFactory emf) {
        this.emf = emf;
    }

    public JPAEntityManagerFactory getEntityManagerFactory() {
        return this.emf;
    }

    public CriteriaQuery<Object> createQuery() {
        return new CriteriaQueryImpl<Object>(this, null);
    }

    public <T> CriteriaQuery<T> createQuery(Class<T> resultCls) {
        return new CriteriaQueryImpl<T>(this, resultCls);
    }

    public CriteriaQuery<Tuple> createTupleQuery() {
        return new CriteriaQueryImpl<Tuple>(this, Tuple.class);
    }

    public <T> CriteriaDelete<T> createCriteriaDelete(Class<T> cls) {
        CriteriaDeleteImpl crit = new CriteriaDeleteImpl(this);
        crit.from(cls);
        return crit;
    }

    public <T> CriteriaUpdate<T> createCriteriaUpdate(Class<T> cls) {
        CriteriaUpdateImpl crit = new CriteriaUpdateImpl(this);
        crit.from(cls);
        return crit;
    }

    public Order asc(javax.persistence.criteria.Expression<?> expr) {
        return new OrderImpl(expr, true);
    }

    public Order desc(javax.persistence.criteria.Expression<?> expr) {
        return new OrderImpl(expr, false);
    }

    public <N extends Number> javax.persistence.criteria.Expression<N> abs(javax.persistence.criteria.Expression<N> expr) {
        ExpressionImpl select = new ExpressionImpl(this, expr.getJavaType());
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(((ExpressionImpl)expr).getQueryExpression());
        select.queryExpr = new InvokeExpression(null, "avg", args);
        return select;
    }

    public <N extends Number> javax.persistence.criteria.Expression<Double> avg(javax.persistence.criteria.Expression<N> expr) {
        ExpressionImpl<Double> select = new ExpressionImpl<Double>(this, expr.getJavaType());
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(((ExpressionImpl)expr).getQueryExpression());
        select.queryExpr = new InvokeExpression(null, "avg", args);
        return select;
    }

    public javax.persistence.criteria.Expression<Long> count(javax.persistence.criteria.Expression<?> expr) {
        ExpressionImpl<Long> select = new ExpressionImpl<Long>(this, expr.getJavaType());
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(((ExpressionImpl)expr).getQueryExpression());
        select.queryExpr = new InvokeExpression(null, "count", args);
        return select;
    }

    public javax.persistence.criteria.Expression<Long> countDistinct(javax.persistence.criteria.Expression<?> expr) {
        ExpressionImpl<Long> select = new ExpressionImpl<Long>(this, expr.getJavaType());
        DyadicExpression dyExpr = new DyadicExpression(Expression.OP_DISTINCT, ((ExpressionImpl)expr).getQueryExpression());
        ArrayList<DyadicExpression> args = new ArrayList<DyadicExpression>();
        args.add(dyExpr);
        select.queryExpr = new InvokeExpression(null, "count", args);
        return select;
    }

    public <N extends Number> javax.persistence.criteria.Expression<N> max(javax.persistence.criteria.Expression<N> expr) {
        ExpressionImpl select = new ExpressionImpl(this, expr.getJavaType());
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(((ExpressionImpl)expr).getQueryExpression());
        select.queryExpr = new InvokeExpression(null, "max", args);
        return select;
    }

    public <X extends Comparable<? super X>> javax.persistence.criteria.Expression<X> greatest(javax.persistence.criteria.Expression<X> expr) {
        ExpressionImpl select = new ExpressionImpl(this, expr.getJavaType());
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(((ExpressionImpl)expr).getQueryExpression());
        select.queryExpr = new InvokeExpression(null, "max", args);
        return select;
    }

    public <N extends Number> javax.persistence.criteria.Expression<N> min(javax.persistence.criteria.Expression<N> expr) {
        ExpressionImpl select = new ExpressionImpl(this, expr.getJavaType());
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(((ExpressionImpl)expr).getQueryExpression());
        select.queryExpr = new InvokeExpression(null, "min", args);
        return select;
    }

    public <X extends Comparable<? super X>> javax.persistence.criteria.Expression<X> least(javax.persistence.criteria.Expression<X> expr) {
        ExpressionImpl select = new ExpressionImpl(this, expr.getJavaType());
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(((ExpressionImpl)expr).getQueryExpression());
        select.queryExpr = new InvokeExpression(null, "min", args);
        return select;
    }

    public javax.persistence.criteria.Expression<Double> sqrt(javax.persistence.criteria.Expression<? extends Number> expr) {
        ExpressionImpl<Double> select = new ExpressionImpl<Double>(this, expr.getJavaType());
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(((ExpressionImpl)expr).getQueryExpression());
        select.queryExpr = new InvokeExpression(null, "sqrt", args);
        return select;
    }

    public <N extends Number> javax.persistence.criteria.Expression<N> sum(javax.persistence.criteria.Expression<N> expr) {
        ExpressionImpl select = new ExpressionImpl(this, expr.getJavaType());
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(((ExpressionImpl)expr).getQueryExpression());
        select.queryExpr = new InvokeExpression(null, "sum", args);
        return select;
    }

    public javax.persistence.criteria.Expression<Double> sumAsDouble(javax.persistence.criteria.Expression<Float> expr) {
        ExpressionImpl<Double> select = new ExpressionImpl<Double>(this, expr.getJavaType());
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(((ExpressionImpl)expr).getQueryExpression());
        select.queryExpr = new InvokeExpression(null, "sum", args);
        return select;
    }

    public javax.persistence.criteria.Expression<Long> sumAsLong(javax.persistence.criteria.Expression<Integer> expr) {
        ExpressionImpl<Long> select = new ExpressionImpl<Long>(this, expr.getJavaType());
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(((ExpressionImpl)expr).getQueryExpression());
        select.queryExpr = new InvokeExpression(null, "sum", args);
        return select;
    }

    public Predicate and(Predicate ... preds) {
        PredicateImpl pred = new PredicateImpl(this);
        for (int i = 0; i < preds.length; ++i) {
            pred.append(preds[i]);
        }
        return pred;
    }

    public Predicate and(javax.persistence.criteria.Expression<Boolean> expr0, javax.persistence.criteria.Expression<Boolean> expr1) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), Expression.OP_AND, ((ExpressionImpl)expr1).getQueryExpression());
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Predicate or(Predicate ... preds) {
        PredicateImpl pred = new PredicateImpl(this, Predicate.BooleanOperator.OR);
        for (int i = 0; i < preds.length; ++i) {
            pred.append(preds[i]);
        }
        return pred;
    }

    public Predicate or(javax.persistence.criteria.Expression<Boolean> expr0, javax.persistence.criteria.Expression<Boolean> expr1) {
        PredicateImpl pred = new PredicateImpl(this, Predicate.BooleanOperator.OR);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), Expression.OP_OR, ((ExpressionImpl)expr1).getQueryExpression());
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Predicate equal(javax.persistence.criteria.Expression<?> expr0, javax.persistence.criteria.Expression<?> expr1) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), Expression.OP_EQ, ((ExpressionImpl)expr1).getQueryExpression());
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Predicate equal(javax.persistence.criteria.Expression<?> expr, Object obj) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), Expression.OP_EQ, (Expression)new Literal(obj));
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Predicate notEqual(javax.persistence.criteria.Expression<?> expr0, javax.persistence.criteria.Expression<?> expr1) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), Expression.OP_NOTEQ, ((ExpressionImpl)expr1).getQueryExpression());
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Predicate notEqual(javax.persistence.criteria.Expression<?> expr, Object obj) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), Expression.OP_NOTEQ, (Expression)new Literal(obj));
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Predicate isNotNull(javax.persistence.criteria.Expression<?> expr) {
        return expr.isNotNull();
    }

    public Predicate isNull(javax.persistence.criteria.Expression<?> expr) {
        return expr.isNull();
    }

    public Predicate ge(javax.persistence.criteria.Expression<? extends Number> expr0, javax.persistence.criteria.Expression<? extends Number> expr1) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), Expression.OP_GTEQ, ((ExpressionImpl)expr1).getQueryExpression());
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Predicate ge(javax.persistence.criteria.Expression<? extends Number> expr, Number obj) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), Expression.OP_GTEQ, (Expression)new Literal((Object)obj));
        pred.queryExpr = queryExpr;
        return pred;
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThan(javax.persistence.criteria.Expression<? extends Y> expr0, javax.persistence.criteria.Expression<? extends Y> expr1) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), Expression.OP_GT, ((ExpressionImpl)expr1).getQueryExpression());
        pred.queryExpr = queryExpr;
        return pred;
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThan(javax.persistence.criteria.Expression<? extends Y> expr, Y obj) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), Expression.OP_GT, (Expression)new Literal(obj));
        pred.queryExpr = queryExpr;
        return pred;
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThanOrEqualTo(javax.persistence.criteria.Expression<? extends Y> expr0, javax.persistence.criteria.Expression<? extends Y> expr1) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), Expression.OP_GTEQ, ((ExpressionImpl)expr1).getQueryExpression());
        pred.queryExpr = queryExpr;
        return pred;
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThanOrEqualTo(javax.persistence.criteria.Expression<? extends Y> expr, Y obj) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), Expression.OP_GTEQ, (Expression)new Literal(obj));
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Predicate gt(javax.persistence.criteria.Expression<? extends Number> expr0, javax.persistence.criteria.Expression<? extends Number> expr1) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), Expression.OP_GT, ((ExpressionImpl)expr1).getQueryExpression());
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Predicate gt(javax.persistence.criteria.Expression<? extends Number> expr, Number obj) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), Expression.OP_GT, (Expression)new Literal((Object)obj));
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Predicate le(javax.persistence.criteria.Expression<? extends Number> expr0, javax.persistence.criteria.Expression<? extends Number> expr1) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), Expression.OP_LTEQ, ((ExpressionImpl)expr1).getQueryExpression());
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Predicate le(javax.persistence.criteria.Expression<? extends Number> expr, Number obj) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), Expression.OP_LTEQ, (Expression)new Literal((Object)obj));
        pred.queryExpr = queryExpr;
        return pred;
    }

    public <Y extends Comparable<? super Y>> Predicate lessThan(javax.persistence.criteria.Expression<? extends Y> expr0, javax.persistence.criteria.Expression<? extends Y> expr1) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), Expression.OP_LT, ((ExpressionImpl)expr1).getQueryExpression());
        pred.queryExpr = queryExpr;
        return pred;
    }

    public <Y extends Comparable<? super Y>> Predicate lessThan(javax.persistence.criteria.Expression<? extends Y> expr, Y obj) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), Expression.OP_LT, (Expression)new Literal(obj));
        pred.queryExpr = queryExpr;
        return pred;
    }

    public <Y extends Comparable<? super Y>> Predicate lessThanOrEqualTo(javax.persistence.criteria.Expression<? extends Y> expr0, javax.persistence.criteria.Expression<? extends Y> expr1) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), Expression.OP_LTEQ, ((ExpressionImpl)expr1).getQueryExpression());
        pred.queryExpr = queryExpr;
        return pred;
    }

    public <Y extends Comparable<? super Y>> Predicate lessThanOrEqualTo(javax.persistence.criteria.Expression<? extends Y> expr, Y obj) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), Expression.OP_LTEQ, (Expression)new Literal(obj));
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Predicate lt(javax.persistence.criteria.Expression<? extends Number> expr0, javax.persistence.criteria.Expression<? extends Number> expr1) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), Expression.OP_LT, ((ExpressionImpl)expr1).getQueryExpression());
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Predicate lt(javax.persistence.criteria.Expression<? extends Number> expr, Number obj) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), Expression.OP_LT, (Expression)new Literal((Object)obj));
        pred.queryExpr = queryExpr;
        return pred;
    }

    public <N extends Number> javax.persistence.criteria.Expression<N> sum(javax.persistence.criteria.Expression<? extends N> expr0, javax.persistence.criteria.Expression<? extends N> expr1) {
        ExpressionImpl sumExpr = new ExpressionImpl(this, expr0.getJavaType());
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), Expression.OP_ADD, ((ExpressionImpl)expr1).getQueryExpression());
        sumExpr.queryExpr = queryExpr;
        return sumExpr;
    }

    public <N extends Number> javax.persistence.criteria.Expression<N> sum(javax.persistence.criteria.Expression<? extends N> expr, N obj) {
        ExpressionImpl sumExpr = new ExpressionImpl(this, expr.getJavaType());
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), Expression.OP_ADD, (Expression)new Literal(obj));
        sumExpr.queryExpr = queryExpr;
        return sumExpr;
    }

    public <N extends Number> javax.persistence.criteria.Expression<N> sum(N obj, javax.persistence.criteria.Expression<? extends N> expr) {
        ExpressionImpl sumExpr = new ExpressionImpl(this, expr.getJavaType());
        DyadicExpression queryExpr = new DyadicExpression((Expression)new Literal(obj), Expression.OP_ADD, ((ExpressionImpl)expr).getQueryExpression());
        sumExpr.queryExpr = queryExpr;
        return sumExpr;
    }

    public javax.persistence.criteria.Expression<Number> quot(javax.persistence.criteria.Expression<? extends Number> expr0, javax.persistence.criteria.Expression<? extends Number> expr1) {
        ExpressionImpl<Number> sumExpr = new ExpressionImpl<Number>(this, Number.class);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), Expression.OP_DIV, ((ExpressionImpl)expr1).getQueryExpression());
        sumExpr.queryExpr = queryExpr;
        return sumExpr;
    }

    public javax.persistence.criteria.Expression<Number> quot(javax.persistence.criteria.Expression<? extends Number> expr, Number obj) {
        ExpressionImpl<Number> sumExpr = new ExpressionImpl<Number>(this, Number.class);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), Expression.OP_DIV, (Expression)new Literal((Object)obj));
        sumExpr.queryExpr = queryExpr;
        return sumExpr;
    }

    public javax.persistence.criteria.Expression<Number> quot(Number obj, javax.persistence.criteria.Expression<? extends Number> expr) {
        ExpressionImpl<Number> sumExpr = new ExpressionImpl<Number>(this, Number.class);
        DyadicExpression queryExpr = new DyadicExpression((Expression)new Literal((Object)obj), Expression.OP_DIV, ((ExpressionImpl)expr).getQueryExpression());
        sumExpr.queryExpr = queryExpr;
        return sumExpr;
    }

    public <N extends Number> javax.persistence.criteria.Expression<N> diff(javax.persistence.criteria.Expression<? extends N> expr0, javax.persistence.criteria.Expression<? extends N> expr1) {
        ExpressionImpl sumExpr = new ExpressionImpl(this, expr0.getJavaType());
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), Expression.OP_SUB, ((ExpressionImpl)expr1).getQueryExpression());
        sumExpr.queryExpr = queryExpr;
        return sumExpr;
    }

    public <N extends Number> javax.persistence.criteria.Expression<N> diff(javax.persistence.criteria.Expression<? extends N> expr, N obj) {
        ExpressionImpl sumExpr = new ExpressionImpl(this, expr.getJavaType());
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), Expression.OP_SUB, (Expression)new Literal(obj));
        sumExpr.queryExpr = queryExpr;
        return sumExpr;
    }

    public <N extends Number> javax.persistence.criteria.Expression<N> diff(N obj, javax.persistence.criteria.Expression<? extends N> expr) {
        ExpressionImpl sumExpr = new ExpressionImpl(this, expr.getJavaType());
        DyadicExpression queryExpr = new DyadicExpression((Expression)new Literal(obj), Expression.OP_SUB, ((ExpressionImpl)expr).getQueryExpression());
        sumExpr.queryExpr = queryExpr;
        return sumExpr;
    }

    public <N extends Number> javax.persistence.criteria.Expression<N> prod(javax.persistence.criteria.Expression<? extends N> expr0, javax.persistence.criteria.Expression<? extends N> expr1) {
        ExpressionImpl sumExpr = new ExpressionImpl(this, expr0.getJavaType());
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), Expression.OP_MUL, ((ExpressionImpl)expr1).getQueryExpression());
        sumExpr.queryExpr = queryExpr;
        return sumExpr;
    }

    public <N extends Number> javax.persistence.criteria.Expression<N> prod(javax.persistence.criteria.Expression<? extends N> expr, N obj) {
        ExpressionImpl sumExpr = new ExpressionImpl(this, expr.getJavaType());
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), Expression.OP_MUL, (Expression)new Literal(obj));
        sumExpr.queryExpr = queryExpr;
        return sumExpr;
    }

    public <N extends Number> javax.persistence.criteria.Expression<N> prod(N obj, javax.persistence.criteria.Expression<? extends N> expr) {
        ExpressionImpl sumExpr = new ExpressionImpl(this, expr.getJavaType());
        DyadicExpression queryExpr = new DyadicExpression((Expression)new Literal(obj), Expression.OP_MUL, ((ExpressionImpl)expr).getQueryExpression());
        sumExpr.queryExpr = queryExpr;
        return sumExpr;
    }

    public javax.persistence.criteria.Expression<Integer> mod(javax.persistence.criteria.Expression<Integer> expr0, javax.persistence.criteria.Expression<Integer> expr1) {
        ExpressionImpl<Integer> sumExpr = new ExpressionImpl<Integer>(this, Integer.class);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr0).getQueryExpression(), Expression.OP_MOD, ((ExpressionImpl)expr1).getQueryExpression());
        sumExpr.queryExpr = queryExpr;
        return sumExpr;
    }

    public javax.persistence.criteria.Expression<Integer> mod(javax.persistence.criteria.Expression<Integer> expr, Integer obj) {
        ExpressionImpl<Integer> sumExpr = new ExpressionImpl<Integer>(this, Integer.class);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), Expression.OP_MOD, (Expression)new Literal((Object)obj));
        sumExpr.queryExpr = queryExpr;
        return sumExpr;
    }

    public javax.persistence.criteria.Expression<Integer> mod(Integer obj, javax.persistence.criteria.Expression<Integer> expr) {
        ExpressionImpl<Integer> sumExpr = new ExpressionImpl<Integer>(this, Integer.class);
        DyadicExpression queryExpr = new DyadicExpression((Expression)new Literal((Object)obj), Expression.OP_MOD, ((ExpressionImpl)expr).getQueryExpression());
        sumExpr.queryExpr = queryExpr;
        return sumExpr;
    }

    public <Y extends Comparable<? super Y>> Predicate between(javax.persistence.criteria.Expression<? extends Y> expr0, javax.persistence.criteria.Expression<? extends Y> expr1, javax.persistence.criteria.Expression<? extends Y> expr2) {
        PredicateImpl pred = new PredicateImpl(this);
        Expression theExpr = ((ExpressionImpl)expr0).getQueryExpression();
        Expression lowerExpr = ((ExpressionImpl)expr1).getQueryExpression();
        Expression upperExpr = ((ExpressionImpl)expr2).getQueryExpression();
        DyadicExpression lowerDyadic = new DyadicExpression(theExpr, Expression.OP_GTEQ, lowerExpr);
        DyadicExpression upperDyadic = new DyadicExpression(theExpr, Expression.OP_LTEQ, upperExpr);
        DyadicExpression overallDyadic = new DyadicExpression((Expression)lowerDyadic, Expression.OP_AND, (Expression)upperDyadic);
        pred.queryExpr = overallDyadic;
        return pred;
    }

    public <Y extends Comparable<? super Y>> Predicate between(javax.persistence.criteria.Expression<? extends Y> expr, Y obj0, Y obj1) {
        PredicateImpl pred = new PredicateImpl(this);
        Expression theExpr = ((ExpressionImpl)expr).getQueryExpression();
        DyadicExpression lowerDyadic = new DyadicExpression(theExpr, Expression.OP_GTEQ, (Expression)new Literal(obj0));
        DyadicExpression upperDyadic = new DyadicExpression(theExpr, Expression.OP_LTEQ, (Expression)new Literal(obj1));
        DyadicExpression overallDyadic = new DyadicExpression((Expression)lowerDyadic, Expression.OP_AND, (Expression)upperDyadic);
        pred.queryExpr = overallDyadic;
        return pred;
    }

    public <T> CriteriaBuilder.Coalesce<T> coalesce() {
        return new CoalesceExpression<Object>(this, Object.class);
    }

    public <Y> javax.persistence.criteria.Expression<Y> coalesce(javax.persistence.criteria.Expression<? extends Y> expr0, javax.persistence.criteria.Expression<? extends Y> expr1) {
        CoalesceExpression<javax.persistence.criteria.Expression<? extends Y>> coalesceExpr = new CoalesceExpression<javax.persistence.criteria.Expression<? extends Y>>(this, expr0.getJavaType());
        coalesceExpr.value(expr0);
        coalesceExpr.value(expr1);
        return coalesceExpr;
    }

    public <Y> javax.persistence.criteria.Expression<Y> coalesce(javax.persistence.criteria.Expression<? extends Y> expr, Y val) {
        CoalesceExpression<Object> coalesceExpr = new CoalesceExpression<Object>(this, expr.getJavaType());
        coalesceExpr.value(expr);
        coalesceExpr.value(val);
        return coalesceExpr;
    }

    public <Y> javax.persistence.criteria.Expression<Y> nullif(javax.persistence.criteria.Expression<Y> expr0, javax.persistence.criteria.Expression<?> expr1) {
        ExpressionImpl coalExpr = new ExpressionImpl(this, expr0.getJavaType());
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(((ExpressionImpl)expr0).getQueryExpression());
        args.add(((ExpressionImpl)expr1).getQueryExpression());
        coalExpr.queryExpr = new InvokeExpression(null, "NULLIF", args);
        return coalExpr;
    }

    public <Y> javax.persistence.criteria.Expression<Y> nullif(javax.persistence.criteria.Expression<Y> expr, Y val) {
        ExpressionImpl coalExpr = new ExpressionImpl(this, expr.getJavaType());
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(((ExpressionImpl)expr).getQueryExpression());
        args.add(new Literal(val));
        coalExpr.queryExpr = new InvokeExpression(null, "NULLIF", args);
        return coalExpr;
    }

    public Predicate conjunction() {
        PredicateImpl pred = new PredicateImpl(this);
        pred.queryExpr = new Literal((Object)Boolean.TRUE);
        return pred;
    }

    public Predicate disjunction() {
        PredicateImpl pred = new PredicateImpl(this);
        pred.queryExpr = new Literal((Object)Boolean.FALSE);
        return pred;
    }

    public <Y> CompoundSelection<Y> construct(Class<Y> cls, Selection<?> ... args) {
        CompoundSelectionImpl<Y> select = new CompoundSelectionImpl<Y>(this, cls, args);
        ArrayList<String> clsNameComponents = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(cls.getName(), ".");
        while (tok.hasMoreTokens()) {
            clsNameComponents.add(tok.nextToken());
        }
        ArrayList<Expression> ctrArgs = new ArrayList<Expression>();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                ExpressionImpl argExpr = (ExpressionImpl)args[i];
                ctrArgs.add(argExpr.queryExpr);
            }
        }
        select.queryExpr = new CreatorExpression(clsNameComponents, ctrArgs);
        return select;
    }

    public javax.persistence.criteria.Expression<Date> currentDate() {
        ExpressionImpl<Date> select = new ExpressionImpl<Date>(this, Date.class);
        select.queryExpr = new InvokeExpression(null, "CURRENT_DATE", null);
        return select;
    }

    public javax.persistence.criteria.Expression<Time> currentTime() {
        ExpressionImpl<Time> select = new ExpressionImpl<Time>(this, Time.class);
        select.queryExpr = new InvokeExpression(null, "CURRENT_TIME", null);
        return select;
    }

    public javax.persistence.criteria.Expression<Timestamp> currentTimestamp() {
        ExpressionImpl<Timestamp> select = new ExpressionImpl<Timestamp>(this, Timestamp.class);
        select.queryExpr = new InvokeExpression(null, "CURRENT_TIMESTAMP", null);
        return select;
    }

    public javax.persistence.criteria.Expression<Integer> year(javax.persistence.criteria.Expression<? extends java.util.Date> expr) {
        ExpressionImpl<Integer> select = new ExpressionImpl<Integer>(this, expr.getJavaType());
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "getYear", null);
        return select;
    }

    public javax.persistence.criteria.Expression<Integer> month(javax.persistence.criteria.Expression<? extends java.util.Date> expr) {
        ExpressionImpl<Integer> select = new ExpressionImpl<Integer>(this, expr.getJavaType());
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "getMonth", null);
        return select;
    }

    public javax.persistence.criteria.Expression<Integer> day(javax.persistence.criteria.Expression<? extends java.util.Date> expr) {
        ExpressionImpl<Integer> select = new ExpressionImpl<Integer>(this, expr.getJavaType());
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "getDay", null);
        return select;
    }

    public javax.persistence.criteria.Expression<Integer> hour(javax.persistence.criteria.Expression<? extends java.util.Date> expr) {
        ExpressionImpl<Integer> select = new ExpressionImpl<Integer>(this, expr.getJavaType());
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "getHour", null);
        return select;
    }

    public javax.persistence.criteria.Expression<Integer> minute(javax.persistence.criteria.Expression<? extends java.util.Date> expr) {
        ExpressionImpl<Integer> select = new ExpressionImpl<Integer>(this, expr.getJavaType());
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "getMinute", null);
        return select;
    }

    public javax.persistence.criteria.Expression<Integer> second(javax.persistence.criteria.Expression<? extends java.util.Date> expr) {
        ExpressionImpl<Integer> select = new ExpressionImpl<Integer>(this, expr.getJavaType());
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "getSecond", null);
        return select;
    }

    public <T> javax.persistence.criteria.Expression<T> function(String funcName, Class<T> returnType, javax.persistence.criteria.Expression<?> ... argExprs) {
        ExpressionImpl<T> funcExpr = new ExpressionImpl<T>(this, returnType);
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(new Literal((Object)funcName));
        if (argExprs != null) {
            for (int i = 0; i < argExprs.length; ++i) {
                args.add(((ExpressionImpl)argExprs[i]).getQueryExpression());
            }
        }
        funcExpr.queryExpr = new InvokeExpression(null, "SQL_function", args);
        return funcExpr;
    }

    public <Y> javax.persistence.criteria.Expression<Y> all(Subquery<Y> sub) {
        ExpressionImpl allExpr = new ExpressionImpl(this, sub.getJavaType());
        Expression subExpr = ((SubqueryImpl)sub).getQueryExpression();
        String varName = null;
        varName = subExpr instanceof VariableExpression ? ((VariableExpression)subExpr).getId() : "SUB" + SubqueryImpl.random.nextInt();
        allExpr.queryExpr = new SubqueryExpression("ALL", new VariableExpression(varName));
        return allExpr;
    }

    public <Y> javax.persistence.criteria.Expression<Y> any(Subquery<Y> sub) {
        ExpressionImpl allExpr = new ExpressionImpl(this, sub.getJavaType());
        Expression subExpr = ((SubqueryImpl)sub).getQueryExpression();
        String varName = null;
        varName = subExpr instanceof VariableExpression ? ((VariableExpression)subExpr).getId() : "SUB" + SubqueryImpl.random.nextInt();
        allExpr.queryExpr = new SubqueryExpression("ANY", new VariableExpression(varName));
        return allExpr;
    }

    public <Y> javax.persistence.criteria.Expression<Y> some(Subquery<Y> sub) {
        ExpressionImpl allExpr = new ExpressionImpl(this, sub.getJavaType());
        Expression subExpr = ((SubqueryImpl)sub).getQueryExpression();
        String varName = null;
        varName = subExpr instanceof VariableExpression ? ((VariableExpression)subExpr).getId() : "SUB" + SubqueryImpl.random.nextInt();
        allExpr.queryExpr = new SubqueryExpression("SOME", new VariableExpression(varName));
        return allExpr;
    }

    public Predicate exists(Subquery<?> sub) {
        PredicateImpl pred = new PredicateImpl(this);
        Expression subExpr = ((SubqueryImpl)sub).getQueryExpression();
        String varName = null;
        varName = subExpr instanceof VariableExpression ? ((VariableExpression)subExpr).getId() : "SUB" + SubqueryImpl.random.nextInt();
        pred.queryExpr = new SubqueryExpression("EXISTS", new VariableExpression(varName));
        return pred;
    }

    public <X> CriteriaBuilder.In<X> in(javax.persistence.criteria.Expression<? extends X> expr) {
        return new InPredicate<X>(this, expr);
    }

    public <X> CriteriaBuilder.In<X> in(javax.persistence.criteria.Expression<? extends X> expr, javax.persistence.criteria.Expression<? extends X> ... values) {
        return new InPredicate<X>(this, expr, values);
    }

    public <X> CriteriaBuilder.In<X> in(javax.persistence.criteria.Expression<? extends X> expr, X ... values) {
        return new InPredicate<X>(this, expr, values);
    }

    public <X> CriteriaBuilder.In<X> in(javax.persistence.criteria.Expression<? extends X> expr, Collection<X> values) {
        return new InPredicate<X>(this, expr, values);
    }

    public <C extends Collection<?>> Predicate isEmpty(javax.persistence.criteria.Expression<C> collExpr) {
        PredicateImpl pred = new PredicateImpl(this);
        InvokeExpression queryExpr = new InvokeExpression(((ExpressionImpl)collExpr).getQueryExpression(), "isEmpty", null);
        pred.queryExpr = queryExpr;
        return pred;
    }

    public <E, C extends Collection<E>> Predicate isMember(javax.persistence.criteria.Expression<E> expr, javax.persistence.criteria.Expression<C> collExpr) {
        PredicateImpl pred = new PredicateImpl(this);
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(((ExpressionImpl)expr).getQueryExpression());
        InvokeExpression queryExpr = new InvokeExpression(((ExpressionImpl)collExpr).getQueryExpression(), "contains", args);
        pred.queryExpr = queryExpr;
        return pred;
    }

    public <E, C extends Collection<E>> Predicate isMember(E val, javax.persistence.criteria.Expression<C> collExpr) {
        PredicateImpl pred = new PredicateImpl(this);
        ArrayList<Literal> args = new ArrayList<Literal>();
        args.add(new Literal(val));
        InvokeExpression queryExpr = new InvokeExpression(((ExpressionImpl)collExpr).getQueryExpression(), "contains", args);
        pred.queryExpr = queryExpr;
        return pred;
    }

    public <C extends Collection<?>> Predicate isNotEmpty(javax.persistence.criteria.Expression<C> collExpr) {
        return this.isEmpty(collExpr).not();
    }

    public <E, C extends Collection<E>> Predicate isNotMember(javax.persistence.criteria.Expression<E> expr, javax.persistence.criteria.Expression<C> collExpr) {
        return this.isMember((E)expr, collExpr).not();
    }

    public <E, C extends Collection<E>> Predicate isNotMember(E val, javax.persistence.criteria.Expression<C> collExpr) {
        return this.isMember(val, collExpr).not();
    }

    public <C extends Collection<?>> javax.persistence.criteria.Expression<Integer> size(javax.persistence.criteria.Expression<C> expr) {
        ExpressionImpl<Integer> collSizeExpr = new ExpressionImpl<Integer>(this, expr.getJavaType());
        collSizeExpr.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "size", null);
        return collSizeExpr;
    }

    public <C extends Collection<?>> javax.persistence.criteria.Expression<Integer> size(C coll) {
        ExpressionImpl<Integer> collSizeExpr = new ExpressionImpl<Integer>(this, Integer.class);
        collSizeExpr.queryExpr = new Literal((Object)coll.size());
        return collSizeExpr;
    }

    public Predicate isFalse(javax.persistence.criteria.Expression<Boolean> expr) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), Expression.OP_EQ, (Expression)new Literal((Object)Boolean.FALSE));
        pred.queryExpr = queryExpr;
        return pred;
    }

    public Predicate isTrue(javax.persistence.criteria.Expression<Boolean> expr) {
        PredicateImpl pred = new PredicateImpl(this);
        DyadicExpression queryExpr = new DyadicExpression(((ExpressionImpl)expr).getQueryExpression(), Expression.OP_EQ, (Expression)new Literal((Object)Boolean.TRUE));
        pred.queryExpr = queryExpr;
        return pred;
    }

    public CompoundSelection<Tuple> tuple(Selection<?> ... selections) {
        return new CompoundSelectionImpl<Tuple>(this, Tuple.class, selections);
    }

    public CompoundSelection<Object[]> array(Selection<?> ... selections) {
        return new CompoundSelectionImpl<Object[]>(this, Object[].class, selections);
    }

    public <K, M extends Map<K, ?>> javax.persistence.criteria.Expression<Set<K>> keys(M map) {
        throw new UnsupportedOperationException("CriteriaBuilder.keys not yet implemented. Provide a testcase that uses this and raise an issue attaching your testcase");
    }

    public <V, M extends Map<?, V>> javax.persistence.criteria.Expression<Collection<V>> values(M map) {
        throw new UnsupportedOperationException("CriteriaBuilder.values not yet implemented. Provide a testcase that uses this and raise an issue attaching your testcase");
    }

    public Predicate like(javax.persistence.criteria.Expression<String> expr, javax.persistence.criteria.Expression<String> expr1) {
        PredicateImpl pred = new PredicateImpl(this);
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(((ExpressionImpl)expr1).getQueryExpression());
        pred.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "matches", args);
        return pred;
    }

    public Predicate like(javax.persistence.criteria.Expression<String> expr, String regex) {
        PredicateImpl pred = new PredicateImpl(this);
        ArrayList<Literal> args = new ArrayList<Literal>();
        args.add(new Literal((Object)regex));
        pred.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "matches", args);
        return pred;
    }

    public Predicate like(javax.persistence.criteria.Expression<String> expr, javax.persistence.criteria.Expression<String> expr1, javax.persistence.criteria.Expression<Character> escExpr) {
        PredicateImpl pred = new PredicateImpl(this);
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(((ExpressionImpl)expr1).getQueryExpression());
        args.add(((ExpressionImpl)escExpr).getQueryExpression());
        pred.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "matches", args);
        return pred;
    }

    public Predicate like(javax.persistence.criteria.Expression<String> expr, javax.persistence.criteria.Expression<String> expr1, char escChr) {
        PredicateImpl pred = new PredicateImpl(this);
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(((ExpressionImpl)expr1).getQueryExpression());
        args.add(new Literal((Object)Character.valueOf(escChr)));
        pred.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "matches", args);
        return pred;
    }

    public Predicate like(javax.persistence.criteria.Expression<String> expr, String regex, javax.persistence.criteria.Expression<Character> escExpr) {
        PredicateImpl pred = new PredicateImpl(this);
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(new Literal((Object)regex));
        args.add(((ExpressionImpl)escExpr).getQueryExpression());
        pred.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "matches", args);
        return pred;
    }

    public Predicate like(javax.persistence.criteria.Expression<String> expr, String regex, char escChr) {
        PredicateImpl pred = new PredicateImpl(this);
        ArrayList<Literal> args = new ArrayList<Literal>();
        args.add(new Literal((Object)regex));
        args.add(new Literal((Object)Character.valueOf(escChr)));
        pred.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "matches", args);
        return pred;
    }

    public <N extends Number> javax.persistence.criteria.Expression<N> neg(javax.persistence.criteria.Expression<N> expr) {
        ExpressionImpl negExpr = new ExpressionImpl(this, expr.getJavaType());
        negExpr.queryExpr = new DyadicExpression(Expression.OP_NEG, ((ExpressionImpl)expr).getQueryExpression());
        return negExpr;
    }

    public Predicate not(javax.persistence.criteria.Expression<Boolean> expr) {
        PredicateImpl pred = new PredicateImpl(this);
        pred.queryExpr = new DyadicExpression(Expression.OP_NOT, ((ExpressionImpl)expr).getQueryExpression());
        return pred;
    }

    public Predicate notLike(javax.persistence.criteria.Expression<String> expr, javax.persistence.criteria.Expression<String> expr1) {
        return this.like(expr, expr1).not();
    }

    public Predicate notLike(javax.persistence.criteria.Expression<String> expr, String regex) {
        return this.like(expr, regex).not();
    }

    public Predicate notLike(javax.persistence.criteria.Expression<String> expr, javax.persistence.criteria.Expression<String> expr1, javax.persistence.criteria.Expression<Character> escExpr) {
        return this.like(expr, expr1, escExpr).not();
    }

    public Predicate notLike(javax.persistence.criteria.Expression<String> expr, javax.persistence.criteria.Expression<String> expr1, char escChr) {
        return this.like(expr, expr1, escChr).not();
    }

    public Predicate notLike(javax.persistence.criteria.Expression<String> expr, String regex, javax.persistence.criteria.Expression<Character> escExpr) {
        return this.like(expr, regex, escExpr).not();
    }

    public Predicate notLike(javax.persistence.criteria.Expression<String> expr, String regex, char escChr) {
        return this.like(expr, regex, escChr).not();
    }

    public <T> ParameterExpression<T> parameter(Class<T> cls) {
        String paramName = "DN_PARAM_" + PARAM_NUMBER++;
        ParameterExpressionImpl<T> param = new ParameterExpressionImpl<T>(this, cls, paramName);
        param.queryExpr = new org.datanucleus.query.expression.ParameterExpression(paramName, cls);
        return param;
    }

    public <T> ParameterExpression<T> parameter(Class<T> cls, String name) {
        ParameterExpressionImpl<T> param = new ParameterExpressionImpl<T>(this, cls, name);
        param.queryExpr = new org.datanucleus.query.expression.ParameterExpression(name, cls);
        return param;
    }

    public <R> CriteriaBuilder.Case<R> selectCase() {
        CaseExpressionImpl caseExpr = new CaseExpressionImpl(this);
        return caseExpr;
    }

    public <C, R> CriteriaBuilder.SimpleCase<C, R> selectCase(javax.persistence.criteria.Expression<? extends C> expr) {
        SimpleCaseExpressionImpl caseExpr = new SimpleCaseExpressionImpl(this, (ExpressionImpl)expr);
        return caseExpr;
    }

    public javax.persistence.criteria.Expression<BigDecimal> toBigDecimal(javax.persistence.criteria.Expression<? extends Number> expr) {
        return expr.as(BigDecimal.class);
    }

    public javax.persistence.criteria.Expression<BigInteger> toBigInteger(javax.persistence.criteria.Expression<? extends Number> expr) {
        return expr.as(BigInteger.class);
    }

    public javax.persistence.criteria.Expression<Double> toDouble(javax.persistence.criteria.Expression<? extends Number> expr) {
        return expr.as(Double.class);
    }

    public javax.persistence.criteria.Expression<Float> toFloat(javax.persistence.criteria.Expression<? extends Number> expr) {
        return expr.as(Float.class);
    }

    public javax.persistence.criteria.Expression<Integer> toInteger(javax.persistence.criteria.Expression<? extends Number> expr) {
        return expr.as(Integer.class);
    }

    public javax.persistence.criteria.Expression<Long> toLong(javax.persistence.criteria.Expression<? extends Number> expr) {
        return expr.as(Long.class);
    }

    public javax.persistence.criteria.Expression<String> toString(javax.persistence.criteria.Expression<Character> expr) {
        return expr.as(String.class);
    }

    public javax.persistence.criteria.Expression<String> concat(javax.persistence.criteria.Expression<String> expr0, javax.persistence.criteria.Expression<String> expr1) {
        return new ConcatExpression(this, expr0, expr1);
    }

    public javax.persistence.criteria.Expression<String> concat(javax.persistence.criteria.Expression<String> expr, String val) {
        return new ConcatExpression(this, expr, new LiteralExpression<String>(this, val));
    }

    public javax.persistence.criteria.Expression<String> concat(String val, javax.persistence.criteria.Expression<String> expr) {
        return new ConcatExpression(this, new LiteralExpression<String>(this, val), expr);
    }

    public javax.persistence.criteria.Expression<Integer> locate(javax.persistence.criteria.Expression<String> expr, javax.persistence.criteria.Expression<String> exprSubstr) {
        ExpressionImpl<Integer> select = new ExpressionImpl<Integer>(this, Integer.class);
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(((ExpressionImpl)exprSubstr).getQueryExpression());
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "indexOf", args);
        return select;
    }

    public javax.persistence.criteria.Expression<Integer> locate(javax.persistence.criteria.Expression<String> expr, String substr) {
        ExpressionImpl<Integer> select = new ExpressionImpl<Integer>(this, Integer.class);
        ArrayList<Literal> args = new ArrayList<Literal>();
        args.add(new Literal((Object)substr));
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "indexOf", args);
        return select;
    }

    public javax.persistence.criteria.Expression<Integer> locate(javax.persistence.criteria.Expression<String> expr, javax.persistence.criteria.Expression<String> exprSubstr, javax.persistence.criteria.Expression<Integer> exprPos) {
        ExpressionImpl<Integer> select = new ExpressionImpl<Integer>(this, Integer.class);
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(((ExpressionImpl)exprSubstr).getQueryExpression());
        args.add(((ExpressionImpl)exprPos).getQueryExpression());
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "indexOf", args);
        return select;
    }

    public javax.persistence.criteria.Expression<Integer> locate(javax.persistence.criteria.Expression<String> expr, String substr, int pos) {
        ExpressionImpl<Integer> select = new ExpressionImpl<Integer>(this, Integer.class);
        ArrayList<Literal> args = new ArrayList<Literal>();
        args.add(new Literal((Object)substr));
        args.add(new Literal((Object)pos));
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "indexOf", args);
        return select;
    }

    public javax.persistence.criteria.Expression<String> substring(javax.persistence.criteria.Expression<String> expr, javax.persistence.criteria.Expression<Integer> posExpr) {
        ExpressionImpl<String> select = new ExpressionImpl<String>(this, expr.getJavaType());
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(((ExpressionImpl)posExpr).getQueryExpression());
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "substring", args);
        return select;
    }

    public javax.persistence.criteria.Expression<String> substring(javax.persistence.criteria.Expression<String> expr, int pos) {
        ExpressionImpl<String> select = new ExpressionImpl<String>(this, expr.getJavaType());
        ArrayList<Literal> args = new ArrayList<Literal>();
        args.add(new Literal((Object)pos));
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "substring", args);
        return select;
    }

    public javax.persistence.criteria.Expression<String> substring(javax.persistence.criteria.Expression<String> expr, javax.persistence.criteria.Expression<Integer> posExpr0, javax.persistence.criteria.Expression<Integer> posExpr1) {
        ExpressionImpl<String> select = new ExpressionImpl<String>(this, expr.getJavaType());
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(((ExpressionImpl)posExpr0).getQueryExpression());
        args.add(((ExpressionImpl)posExpr1).getQueryExpression());
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "substring", args);
        return select;
    }

    public javax.persistence.criteria.Expression<String> substring(javax.persistence.criteria.Expression<String> expr, int pos0, int pos1) {
        ExpressionImpl<String> select = new ExpressionImpl<String>(this, expr.getJavaType());
        ArrayList<Literal> args = new ArrayList<Literal>();
        args.add(new Literal((Object)pos0));
        args.add(new Literal((Object)pos1));
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "substring", args);
        return select;
    }

    public javax.persistence.criteria.Expression<String> trim(javax.persistence.criteria.Expression<String> expr) {
        ExpressionImpl<String> select = new ExpressionImpl<String>(this, expr.getJavaType());
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "trim", null);
        return select;
    }

    public javax.persistence.criteria.Expression<String> trim(CriteriaBuilder.Trimspec spec, javax.persistence.criteria.Expression<String> expr) {
        ExpressionImpl<String> select = new ExpressionImpl<String>(this, expr.getJavaType());
        String method = "trim";
        if (spec == CriteriaBuilder.Trimspec.LEADING) {
            method = "trimLeft";
        } else if (spec == CriteriaBuilder.Trimspec.TRAILING) {
            method = "trimRight";
        }
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), method, null);
        return select;
    }

    public javax.persistence.criteria.Expression<String> trim(javax.persistence.criteria.Expression<Character> chr, javax.persistence.criteria.Expression<String> expr) {
        ExpressionImpl<String> select = new ExpressionImpl<String>(this, expr.getJavaType());
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(((ExpressionImpl)chr).getQueryExpression());
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "trim", args);
        return select;
    }

    public javax.persistence.criteria.Expression<String> trim(char chr, javax.persistence.criteria.Expression<String> expr) {
        ExpressionImpl<String> select = new ExpressionImpl<String>(this, expr.getJavaType());
        ArrayList<Literal> args = new ArrayList<Literal>();
        args.add(new Literal((Object)Character.valueOf(chr)));
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "trim", args);
        return select;
    }

    public javax.persistence.criteria.Expression<String> trim(CriteriaBuilder.Trimspec spec, javax.persistence.criteria.Expression<Character> chr, javax.persistence.criteria.Expression<String> expr) {
        ExpressionImpl<String> select = new ExpressionImpl<String>(this, expr.getJavaType());
        String method = "trim";
        if (spec == CriteriaBuilder.Trimspec.LEADING) {
            method = "trimLeft";
        } else if (spec == CriteriaBuilder.Trimspec.TRAILING) {
            method = "trimRight";
        }
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(((ExpressionImpl)chr).getQueryExpression());
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), method, args);
        return select;
    }

    public javax.persistence.criteria.Expression<String> trim(CriteriaBuilder.Trimspec spec, char chr, javax.persistence.criteria.Expression<String> expr) {
        ExpressionImpl<String> select = new ExpressionImpl<String>(this, expr.getJavaType());
        String method = "trim";
        if (spec == CriteriaBuilder.Trimspec.LEADING) {
            method = "trimLeft";
        } else if (spec == CriteriaBuilder.Trimspec.TRAILING) {
            method = "trimRight";
        }
        ArrayList<Literal> args = new ArrayList<Literal>();
        args.add(new Literal((Object)Character.valueOf(chr)));
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), method, args);
        return select;
    }

    public javax.persistence.criteria.Expression<String> lower(javax.persistence.criteria.Expression<String> expr) {
        ExpressionImpl<String> select = new ExpressionImpl<String>(this, expr.getJavaType());
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "toLowerCase", null);
        return select;
    }

    public javax.persistence.criteria.Expression<String> upper(javax.persistence.criteria.Expression<String> expr) {
        ExpressionImpl<String> select = new ExpressionImpl<String>(this, expr.getJavaType());
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "toUpperCase", null);
        return select;
    }

    public javax.persistence.criteria.Expression<Integer> length(javax.persistence.criteria.Expression<String> expr) {
        ExpressionImpl<Integer> select = new ExpressionImpl<Integer>(this, Integer.class);
        select.queryExpr = new InvokeExpression(((ExpressionImpl)expr).getQueryExpression(), "length", null);
        return select;
    }

    public <T> javax.persistence.criteria.Expression<T> literal(T obj) {
        ExpressionImpl expr = new ExpressionImpl(this, obj.getClass());
        expr.queryExpr = new Literal(obj);
        return expr;
    }

    public <T> javax.persistence.criteria.Expression<T> nullLiteral(Class<T> cls) {
        ExpressionImpl<T> expr = new ExpressionImpl<T>(this, cls);
        expr.queryExpr = new Literal(null);
        return expr;
    }

    public <X, T, V extends T> Join<X, V> treat(Join<X, T> join, Class<V> type) {
        throw new UnsupportedOperationException("CriteriaBuilder.treat(Join, Class) not yet implemented. Provide a testcase that uses this and raise an issue attaching your testcase");
    }

    public <X, T, E extends T> CollectionJoin<X, E> treat(CollectionJoin<X, T> join, Class<E> type) {
        throw new UnsupportedOperationException("CriteriaBuilder.treat(CollectionJoin, Class) not yet implemented. Provide a testcase that uses this and raise an issue attaching your testcase");
    }

    public <X, T, E extends T> SetJoin<X, E> treat(SetJoin<X, T> join, Class<E> type) {
        throw new UnsupportedOperationException("CriteriaBuilder.treat(SetJoin, Class) not yet implemented. Provide a testcase that uses this and raise an issue attaching your testcase");
    }

    public <X, T, E extends T> ListJoin<X, E> treat(ListJoin<X, T> join, Class<E> type) {
        throw new UnsupportedOperationException("CriteriaBuilder.treat(ListJoin, Class) not yet implemented. Provide a testcase that uses this and raise an issue attaching your testcase");
    }

    public <X, K, T, V extends T> MapJoin<X, K, V> treat(MapJoin<X, K, T> join, Class<V> type) {
        throw new UnsupportedOperationException("CriteriaBuilder.treat(MapJoin, Class) not yet implemented. Provide a testcase that uses this and raise an issue attaching your testcase");
    }

    public <X, T extends X> Path<T> treat(Path<X> path, Class<T> type) {
        return new TreatPathImpl(this, (PathImpl)path, type);
    }

    public <X, T extends X> Root<T> treat(Root<X> root, Class<T> type) {
        return new TreatRootImpl(this, (RootImpl)root, type);
    }
}

