/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa;

import java.util.Map;
import javax.persistence.AttributeNode;
import javax.persistence.Subgraph;
import org.datanucleus.api.jpa.AbstractJPAGraph;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.util.StringUtils;

public class JPASubgraph<T>
extends AbstractJPAGraph<T>
implements Subgraph<T> {
    public JPASubgraph(MetaDataManager mmgr, Class<T> clsType) {
        super(mmgr, clsType);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("Graph(");
        str.append("type=").append(this.classType.getName());
        if (this.attributeNodeMap != null) {
            boolean hasSubgraphs = false;
            str.append(", attributes=[");
            int i = 0;
            for (AttributeNode attr : this.attributeNodeMap.values()) {
                if (i > 0) {
                    str.append(",");
                }
                if (!hasSubgraphs && attr.getSubgraphs() != null && !attr.getSubgraphs().isEmpty()) {
                    hasSubgraphs = true;
                }
                str.append(attr.toString());
                ++i;
            }
            str.append("]");
            if (hasSubgraphs) {
                str.append(", subgraphs=[");
                for (AttributeNode attr : this.attributeNodeMap.values()) {
                    Map subgraphs = attr.getSubgraphs();
                    if (subgraphs == null || subgraphs.isEmpty()) continue;
                    str.append(StringUtils.collectionToString(subgraphs.values()));
                }
                str.append("]");
            }
        }
        str.append(")");
        return str.toString();
    }
}

