/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import org.datanucleus.api.jpa.JPAQueryTupleElement;

public class JPAQueryTuple
implements Tuple {
    protected List<JPAQueryTupleElement> elements = new ArrayList<JPAQueryTupleElement>();
    protected Map<String, JPAQueryTupleElement> elementByAlias = new HashMap<String, JPAQueryTupleElement>();

    public void put(Object key, Object val) {
        JPAQueryTupleElement te = new JPAQueryTupleElement((String)key, val != null ? val.getClass() : null, val);
        this.elements.add(te);
        this.elementByAlias.put((String)key, te);
    }

    public <X> X get(TupleElement<X> tupleElement) {
        if (!this.elements.contains(tupleElement)) {
            throw new IllegalArgumentException("TupleElement is not present in this Tuple");
        }
        for (JPAQueryTupleElement te : this.elements) {
            if (!te.equals(tupleElement)) continue;
            return (X)te.getValue();
        }
        return null;
    }

    public <X> X get(String alias, Class<X> type) {
        JPAQueryTupleElement te = this.elementByAlias.get(alias);
        if (te == null) {
            throw new IllegalArgumentException("Cannot find element of Tuple with alias=" + alias);
        }
        if (!type.isAssignableFrom(te.getJavaType())) {
            throw new IllegalArgumentException("Cannot return value for alias=" + alias + " of this Tuple to be type=" + type.getName() + " because type is " + te.getJavaType());
        }
        return (X)te.getValue();
    }

    public Object get(String alias) {
        JPAQueryTupleElement te = this.elementByAlias.get(alias);
        if (te == null) {
            throw new IllegalArgumentException("Cannot find element of Tuple with alias=" + alias);
        }
        return te.getValue();
    }

    public <X> X get(int i, Class<X> type) {
        if (i < 0 || i >= this.elements.size()) {
            throw new IllegalArgumentException("Cannot return value for position " + i + " of this Tuple. Max position=" + (this.elements.size() - 1));
        }
        JPAQueryTupleElement te = this.elements.get(i);
        if (!type.isAssignableFrom(te.getJavaType())) {
            throw new IllegalArgumentException("Cannot return value for position " + i + " of this Tuple to be type=" + type.getName() + " because type is " + te.getJavaType());
        }
        return (X)te.getValue();
    }

    public Object get(int i) {
        if (i < 0 || i >= this.elements.size()) {
            throw new IllegalArgumentException("Cannot return value for position " + i + " of this Tuple. Max position=" + (this.elements.size() - 1));
        }
        JPAQueryTupleElement te = this.elements.get(i);
        return te.getValue();
    }

    public Object[] toArray() {
        Object[] values = new Object[this.elements.size()];
        int i = 0;
        for (JPAQueryTupleElement te : this.elements) {
            values[i] = te.getValue();
        }
        return values;
    }

    public List<TupleElement<?>> getElements() {
        ArrayList tupleElements = new ArrayList();
        for (JPAQueryTupleElement te : this.elements) {
            tupleElements.add(te);
        }
        return tupleElements;
    }

    public String toString() {
        return "JPAQueryTuple : " + this.elements.size() + " elements";
    }
}

