/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.metadata;

import javax.persistence.AttributeConverter;
import org.datanucleus.store.types.converters.TypeConverter;

public class JPATypeConverter<X, Y>
implements TypeConverter<X, Y> {
    private static final long serialVersionUID = -4533920769365489446L;
    AttributeConverter<X, Y> entityConverter;
    Class<X> memberType;
    Class<Y> dbType;

    public JPATypeConverter(AttributeConverter<X, Y> entityConv, Class<X> memberType, Class<Y> dbType) {
        this.entityConverter = entityConv;
        this.dbType = dbType;
        this.memberType = memberType;
    }

    public Class<X> getMemberClass() {
        return this.memberType;
    }

    public Class<Y> getDatastoreClass() {
        return this.dbType;
    }

    public Y toDatastoreType(X memberValue) {
        return (Y)this.entityConverter.convertToDatabaseColumn(memberValue);
    }

    public X toMemberType(Y datastoreValue) {
        return (X)this.entityConverter.convertToEntityAttribute(datastoreValue);
    }

    public String toString() {
        return "JPATypeConverter<" + this.memberType.getName() + "," + this.dbType.getName() + ">";
    }
}

