/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.criteria;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.jpa.criteria.ExpressionImpl;
import org.datanucleus.api.jpa.criteria.FromImpl;
import org.datanucleus.api.jpa.criteria.JoinImpl;
import org.datanucleus.api.jpa.criteria.OrderImpl;
import org.datanucleus.api.jpa.criteria.ParameterExpressionImpl;
import org.datanucleus.api.jpa.criteria.PredicateImpl;
import org.datanucleus.api.jpa.criteria.RootImpl;
import org.datanucleus.api.jpa.criteria.SubqueryImpl;
import org.datanucleus.api.jpa.metamodel.MetamodelImpl;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.query.compiler.JPQLSymbolResolver;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.expression.ClassExpression;
import org.datanucleus.query.expression.CreatorExpression;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.OrderExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.query.expression.SubqueryExpression;
import org.datanucleus.query.expression.VariableExpression;
import org.datanucleus.query.symbol.PropertySymbol;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.query.symbol.SymbolResolver;
import org.datanucleus.query.symbol.SymbolTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CriteriaQueryImpl<T>
implements CriteriaQuery<T>,
Serializable {
    private MetamodelImpl model;
    private boolean distinct;
    private Class<T> resultClass;
    private List<Selection<?>> result;
    private List<RootImpl<?>> from;
    private PredicateImpl filter;
    private List<javax.persistence.criteria.Expression<?>> grouping;
    private PredicateImpl having;
    private List<Order> ordering;
    private List<SubqueryImpl<?>> subqueries;
    String jpqlString = null;
    QueryCompilation compilation = null;
    Set<ParameterExpression<?>> params = null;

    public CriteriaQueryImpl(MetamodelImpl model, Class<T> resultClass) {
        this.model = model;
        this.resultClass = resultClass;
    }

    public Metamodel getMetamodel() {
        return this.model;
    }

    public CriteriaQuery<T> distinct(boolean flag) {
        this.discardCompiled();
        this.distinct = flag;
        return this;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public CriteriaQuery<T> select(Selection<? extends T> select) {
        this.discardCompiled();
        this.result = new ArrayList();
        this.result.add(select);
        return this;
    }

    public CriteriaQuery<T> multiselect(List<Selection<?>> selects) {
        this.discardCompiled();
        this.result = new ArrayList(selects);
        return this;
    }

    public CriteriaQuery<T> multiselect(Selection<?> ... selects) {
        this.discardCompiled();
        this.result = new ArrayList();
        for (int i = 0; i < selects.length; ++i) {
            this.result.add(selects[i]);
        }
        return this;
    }

    public Selection<T> getSelection() {
        if (this.result != null) {
            return this.result.get(0);
        }
        return null;
    }

    public Class<T> getResultType() {
        return this.resultClass;
    }

    public <X> Root<X> from(Class<X> cls) {
        if (this.model == null) {
            throw new IllegalArgumentException("Metamodel on this CriteriaQuery is null. Use 'from(EntityType)' method instead");
        }
        this.discardCompiled();
        EntityType<X> entity = this.model.entity(cls);
        if (entity == null) {
            throw new IllegalArgumentException("The specified class (" + cls.getName() + ") is not an entity");
        }
        return this.from(entity);
    }

    public <X> Root<X> from(EntityType<X> type) {
        this.discardCompiled();
        if (this.from == null) {
            this.from = new ArrayList();
        }
        RootImpl<X> root = new RootImpl<X>(type);
        this.from.add(root);
        return root;
    }

    public Set<Root<?>> getRoots() {
        if (this.from == null) {
            return null;
        }
        return new HashSet(this.from);
    }

    public CriteriaQuery<T> where(javax.persistence.criteria.Expression<Boolean> expr) {
        this.discardCompiled();
        if (expr == null) {
            this.filter = null;
            return this;
        }
        this.filter = (PredicateImpl)expr;
        return this;
    }

    public CriteriaQuery<T> where(Predicate ... exprs) {
        this.discardCompiled();
        if (exprs == null) {
            this.filter = null;
            return this;
        }
        if (this.filter == null) {
            this.filter = new PredicateImpl();
        }
        for (int i = 0; i < exprs.length; ++i) {
            this.filter = this.filter.append(exprs[i]);
        }
        return this;
    }

    public Predicate getRestriction() {
        return this.filter;
    }

    public CriteriaQuery<T> groupBy(javax.persistence.criteria.Expression<?> ... exprs) {
        this.discardCompiled();
        if (exprs == null) {
            this.grouping = null;
            return this;
        }
        this.grouping = new ArrayList();
        for (int i = 0; i < exprs.length; ++i) {
            this.grouping.add(exprs[i]);
        }
        return this;
    }

    public CriteriaQuery<T> groupBy(List<javax.persistence.criteria.Expression<?>> exprs) {
        this.discardCompiled();
        if (exprs == null) {
            this.grouping = null;
            return this;
        }
        this.grouping = new ArrayList();
        this.grouping.addAll(exprs);
        return this;
    }

    public List<javax.persistence.criteria.Expression<?>> getGroupList() {
        if (this.grouping == null) {
            return null;
        }
        return new ArrayList(this.grouping);
    }

    public Predicate getGroupRestriction() {
        return this.having;
    }

    public CriteriaQuery<T> having(javax.persistence.criteria.Expression<Boolean> expr) {
        this.discardCompiled();
        this.having = (PredicateImpl)expr;
        return this;
    }

    public CriteriaQuery<T> having(Predicate ... exprs) {
        this.discardCompiled();
        if (exprs == null) {
            this.having = null;
            return this;
        }
        if (this.having == null) {
            this.having = new PredicateImpl();
        }
        for (int i = 0; i < exprs.length; ++i) {
            this.having = (PredicateImpl)exprs[i];
        }
        return this;
    }

    public List<Order> getOrderList() {
        if (this.ordering == null) {
            return null;
        }
        return new ArrayList<Order>(this.ordering);
    }

    public CriteriaQuery<T> orderBy(List<Order> orders) {
        this.discardCompiled();
        if (orders == null) {
            this.ordering = null;
            return this;
        }
        this.ordering = new ArrayList<Order>();
        this.ordering.addAll(orders);
        return this;
    }

    public CriteriaQuery<T> orderBy(Order ... orders) {
        this.discardCompiled();
        if (orders == null) {
            this.ordering = null;
            return this;
        }
        this.ordering = new ArrayList<Order>();
        for (int i = 0; i < orders.length; ++i) {
            this.ordering.add(orders[i]);
        }
        return this;
    }

    public <U> Subquery<U> subquery(Class<U> type) {
        this.discardCompiled();
        if (this.subqueries == null) {
            this.subqueries = new ArrayList();
        }
        SubqueryImpl<U> subquery = new SubqueryImpl<U>(type, this);
        this.subqueries.add(subquery);
        return subquery;
    }

    protected void discardCompiled() {
        this.jpqlString = null;
        this.compilation = null;
        this.params = null;
    }

    public Set<ParameterExpression<?>> getParameters() {
        Expression expr;
        Iterator<Selection<?>> iter;
        if (this.params != null) {
            return this.params;
        }
        ArrayList paramExprs = new ArrayList();
        if (this.result != null) {
            iter = this.result.iterator();
            while (iter.hasNext()) {
                expr = ((ExpressionImpl)iter.next()).getQueryExpression();
                this.getParametersForQueryExpression(expr, paramExprs);
            }
        }
        if (this.filter != null) {
            this.getParametersForQueryExpression(this.filter.getQueryExpression(), paramExprs);
        }
        if (this.grouping != null) {
            iter = this.grouping.iterator();
            while (iter.hasNext()) {
                expr = ((ExpressionImpl)iter.next()).getQueryExpression();
                this.getParametersForQueryExpression(expr, paramExprs);
            }
        }
        if (this.having != null) {
            this.getParametersForQueryExpression(this.having.getQueryExpression(), paramExprs);
        }
        if (paramExprs.isEmpty()) {
            this.params = Collections.EMPTY_SET;
        } else {
            this.params = new HashSet();
            Boolean namedParams = null;
            for (org.datanucleus.query.expression.ParameterExpression paramExpr : paramExprs) {
                if (namedParams == null) {
                    namedParams = paramExpr.getId() != null ? Boolean.TRUE : Boolean.FALSE;
                } else if (namedParams == Boolean.TRUE && paramExpr.getId() == null || namedParams == Boolean.FALSE && paramExpr.getId() != null) {
                    throw new IllegalArgumentException("Parameters specified are a mix of named and numbered!");
                }
                ParameterExpressionImpl param = new ParameterExpressionImpl(paramExpr.getType(), paramExpr.getId());
                this.params.add(param);
            }
        }
        return this.params;
    }

    public QueryCompilation getCompilation(MetaDataManager mmgr, ClassLoaderResolver clr) {
        return this.getCompilation(mmgr, clr, null);
    }

    /*
     * WARNING - void declaration
     */
    public QueryCompilation getCompilation(MetaDataManager mmgr, ClassLoaderResolver clr, SymbolTable parentSymtbl) {
        if (this.compilation == null) {
            void var14_22;
            Class candidateClass = this.from.get(0).getJavaType();
            String candidateAlias = this.from.get(0).getAlias();
            if (candidateAlias == null) {
                candidateAlias = "DN_THIS";
                this.from.get(0).alias(candidateAlias);
            }
            SymbolTable symtbl = new SymbolTable();
            symtbl.setSymbolResolver((SymbolResolver)new JPQLSymbolResolver(mmgr, clr, symtbl, candidateClass, candidateAlias));
            symtbl.addSymbol((Symbol)new PropertySymbol(candidateAlias, candidateClass));
            if (parentSymtbl != null) {
                symtbl.setParentSymbolTable(parentSymtbl);
            }
            Expression[] resultExprs = null;
            if (this.result != null && !this.result.isEmpty()) {
                String resultExprId;
                resultExprs = new Expression[this.result.size()];
                Iterator<Selection<?>> iter = this.result.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    ExpressionImpl result = (ExpressionImpl)iter.next();
                    Expression resultExpr = result.getQueryExpression();
                    resultExpr.bind(symtbl);
                    resultExprs[i++] = resultExpr;
                }
                if (resultExprs != null && resultExprs.length == 1 && resultExprs[0] instanceof PrimaryExpression && (resultExprId = ((PrimaryExpression)resultExprs[0]).getId()).equalsIgnoreCase(candidateAlias)) {
                    resultExprs = null;
                }
            }
            Expression[] fromExprs = new Expression[this.from.size()];
            Iterator<RootImpl<?>> iter = this.from.iterator();
            int i = 0;
            while (iter.hasNext()) {
                FromImpl frm = iter.next();
                Set frmJoins = frm.getJoins();
                if (frmJoins != null && !frmJoins.isEmpty()) {
                    for (JoinImpl joinImpl : frmJoins) {
                        if (joinImpl.getAlias() == null) continue;
                        Class frmJoinCls = joinImpl.getType().getJavaType();
                        symtbl.addSymbol((Symbol)new PropertySymbol(joinImpl.getAlias(), frmJoinCls));
                    }
                }
                ClassExpression clsExpr = (ClassExpression)frm.getQueryExpression(true);
                clsExpr.bind(symtbl);
                fromExprs[i++] = clsExpr;
            }
            Expression filterExpr = null;
            if (this.filter != null && (filterExpr = this.filter.getQueryExpression()) != null) {
                filterExpr.bind(symtbl);
            }
            Expression[] groupingExprs = null;
            if (this.grouping != null && !this.grouping.isEmpty()) {
                groupingExprs = new Expression[this.grouping.size()];
                Iterator<javax.persistence.criteria.Expression<?>> grpIter = this.grouping.iterator();
                i = 0;
                while (grpIter.hasNext()) {
                    ExpressionImpl expressionImpl = (ExpressionImpl)grpIter.next();
                    Expression groupingExpr = expressionImpl.getQueryExpression();
                    groupingExpr.bind(symtbl);
                    groupingExprs[i++] = groupingExpr;
                }
            }
            Expression havingExpr = null;
            if (this.having != null) {
                havingExpr = this.having.getQueryExpression();
                havingExpr.bind(symtbl);
            }
            Object var14_20 = null;
            if (this.ordering != null && !this.ordering.isEmpty()) {
                Expression[] expressionArray = new Expression[this.ordering.size()];
                Iterator<Order> orderIter = this.ordering.iterator();
                i = 0;
                while (orderIter.hasNext()) {
                    OrderImpl order = (OrderImpl)orderIter.next();
                    OrderExpression orderExpr = order.getQueryExpression();
                    orderExpr.bind(symtbl);
                    expressionArray[i++] = orderExpr;
                }
            }
            this.compilation = new QueryCompilation(candidateClass, candidateAlias, symtbl, resultExprs, fromExprs, filterExpr, groupingExprs, havingExpr, (Expression[])var14_22, null);
            this.compilation.setQueryLanguage("JPQL");
        }
        if (this.subqueries != null && !this.subqueries.isEmpty()) {
            for (SubqueryImpl<?> sub : this.subqueries) {
                Expression subExpr = sub.getQueryExpression();
                if (subExpr instanceof SubqueryExpression) {
                    SubqueryExpression subqueryExpr = (SubqueryExpression)sub.getQueryExpression();
                    VariableExpression subqueryVar = (VariableExpression)subqueryExpr.getRight();
                    CriteriaQueryImpl subDelegate = (CriteriaQueryImpl)sub.getDelegate();
                    QueryCompilation subCompilation = subDelegate.getCompilation(mmgr, clr, this.compilation.getSymbolTable());
                    subCompilation.setQueryLanguage("JPQL");
                    this.compilation.addSubqueryCompilation(subqueryVar.getId(), subCompilation);
                    continue;
                }
                if (!(subExpr instanceof VariableExpression)) continue;
                VariableExpression subVarExpr = (VariableExpression)subExpr;
                CriteriaQueryImpl subDelegate = (CriteriaQueryImpl)sub.getDelegate();
                QueryCompilation subCompilation = subDelegate.getCompilation(mmgr, clr, this.compilation.getSymbolTable());
                subCompilation.setQueryLanguage("JPQL");
                this.compilation.addSubqueryCompilation(subVarExpr.getId(), subCompilation);
            }
        }
        return this.compilation;
    }

    public String toString() {
        if (this.jpqlString == null) {
            Iterator<javax.persistence.criteria.Expression<?>> iter;
            StringBuffer str = new StringBuffer();
            str.append("SELECT ");
            if (this.distinct) {
                str.append("DISTINCT ");
            }
            if (this.result != null) {
                Iterator<Selection<?>> iter2 = this.result.iterator();
                while (iter2.hasNext()) {
                    Selection<?> select = iter2.next();
                    str.append(select.toString());
                    if (!iter2.hasNext()) continue;
                    str.append(",");
                }
                str.append(" ");
            }
            str.append("FROM ");
            Iterator<RootImpl<?>> fromIter = this.from.iterator();
            while (fromIter.hasNext()) {
                RootImpl<?> root = fromIter.next();
                str.append(root.toString(true));
                if (!fromIter.hasNext()) continue;
                str.append(",");
            }
            str.append(" ");
            if (this.filter != null) {
                str.append("WHERE ").append(this.filter.toString());
            }
            if (this.grouping != null) {
                str.append("GROUP BY ");
                iter = this.grouping.iterator();
                while (iter.hasNext()) {
                    javax.persistence.criteria.Expression<?> groupExpr = iter.next();
                    str.append(groupExpr.toString());
                    if (!iter.hasNext()) continue;
                    str.append(",");
                }
                str.append(" ");
            }
            if (this.having != null) {
                str.append("HAVING ");
                str.append(this.having.toString());
            }
            if (this.ordering != null) {
                str.append("ORDER BY ");
                iter = this.ordering.iterator();
                while (iter.hasNext()) {
                    Order order = (Order)iter.next();
                    str.append(order.toString());
                    if (!iter.hasNext()) continue;
                    str.append(",");
                }
                str.append(" ");
            }
            this.jpqlString = str.toString().trim();
        }
        return this.jpqlString;
    }

    protected void getParametersForQueryExpression(Expression expr, List params) {
        if (expr == null) {
            return;
        }
        if (expr instanceof DyadicExpression) {
            this.getParametersForQueryExpression(expr.getLeft(), params);
            this.getParametersForQueryExpression(expr.getRight(), params);
        } else if (expr instanceof InvokeExpression) {
            InvokeExpression invokeExpr = (InvokeExpression)expr;
            this.getParametersForQueryExpression(invokeExpr.getLeft(), params);
            List args = invokeExpr.getArguments();
            if (args != null && !args.isEmpty()) {
                Iterator iter = args.iterator();
                while (iter.hasNext()) {
                    this.getParametersForQueryExpression((Expression)iter.next(), params);
                }
            }
        } else if (expr instanceof PrimaryExpression) {
            if (expr.getLeft() != null) {
                this.getParametersForQueryExpression(expr.getLeft(), params);
            }
        } else if (expr instanceof org.datanucleus.query.expression.ParameterExpression) {
            params.add(expr);
        } else if (expr instanceof CreatorExpression) {
            CreatorExpression createExpr = (CreatorExpression)expr;
            List args = createExpr.getArguments();
            if (args != null && !args.isEmpty()) {
                Iterator iter = args.iterator();
                while (iter.hasNext()) {
                    this.getParametersForQueryExpression((Expression)iter.next(), params);
                }
            }
        } else if (expr instanceof VariableExpression || expr instanceof Literal) {
            // empty if block
        }
    }
}

