/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa;

import java.util.Map;
import java.util.Set;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.TransactionRequiredException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.jpa21.StoredProcedureQuery;
import javax.persistence.metamodel.Metamodel;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.MultithreadedObjectManager;
import org.datanucleus.NucleusContext;
import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerImpl;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.api.jpa.JPAEntityManagerFactory;
import org.datanucleus.api.jpa.JPAEntityTransaction;
import org.datanucleus.api.jpa.JPAFetchPlan;
import org.datanucleus.api.jpa.JPAPersistenceManager;
import org.datanucleus.api.jpa.JPAQuery;
import org.datanucleus.api.jpa.JPAStoredProcedureQuery;
import org.datanucleus.api.jpa.NucleusJPAHelper;
import org.datanucleus.api.jpa.criteria.CriteriaBuilderImpl;
import org.datanucleus.api.jpa.criteria.CriteriaQueryImpl;
import org.datanucleus.api.jpa.metamodel.MetamodelImpl;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.QueryLanguage;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.QueryResultMetaData;
import org.datanucleus.metadata.StoredProcQueryMetaData;
import org.datanucleus.metadata.StoredProcQueryParameterMetaData;
import org.datanucleus.metadata.TransactionType;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.state.CallbackHandler;
import org.datanucleus.state.DetachState;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.query.AbstractStoredProcedureQuery;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;
import org.datanucleus.util.TypeConversionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAEntityManager
implements EntityManager {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.api.jpa.Localisation", (ClassLoader)NucleusJPAHelper.class.getClassLoader());
    protected ObjectManager om;
    protected EntityManagerFactory emf;
    protected EntityTransaction tx;
    protected FlushModeType flushMode = FlushModeType.AUTO;
    protected PersistenceContextType persistenceContextType;
    protected JPAFetchPlan fetchPlan = null;

    public JPAEntityManager(EntityManagerFactory theEMF, NucleusContext nucleusCtx, PersistenceContextType contextType) {
        CallbackHandler beanValidator;
        this.emf = theEMF;
        this.persistenceContextType = contextType;
        this.om = nucleusCtx.getPersistenceConfiguration().getBooleanProperty("datanucleus.Multithreaded") ? new MultithreadedObjectManager(nucleusCtx, (Object)new JPAPersistenceManager(this), nucleusCtx.getPersistenceConfiguration().getStringProperty("datanucleus.ConnectionUserName"), nucleusCtx.getPersistenceConfiguration().getStringProperty("datanucleus.ConnectionPassword")) : new ObjectManagerImpl(nucleusCtx, (Object)new JPAPersistenceManager(this), nucleusCtx.getPersistenceConfiguration().getStringProperty("datanucleus.ConnectionUserName"), nucleusCtx.getPersistenceConfiguration().getStringProperty("datanucleus.ConnectionPassword"));
        if (nucleusCtx.getPersistenceConfiguration().getStringProperty("datanucleus.TransactionType").equalsIgnoreCase(TransactionType.RESOURCE_LOCAL.toString())) {
            this.tx = new JPAEntityTransaction((ExecutionContext)this.om);
        }
        if ((beanValidator = nucleusCtx.getValidationHandler((ExecutionContext)this.om)) != null) {
            this.om.getCallbackHandler().setValidationListener(beanValidator);
        }
        this.fetchPlan = new JPAFetchPlan(this.om.getFetchPlan());
    }

    public void clear() {
        this.assertIsOpen();
        this.om.detachAll();
        this.om.clearDirty();
        this.om.evictAllObjects();
    }

    public boolean isOpen() {
        return !this.om.isClosed();
    }

    public ExecutionContext getExecutionContext() {
        return this.om;
    }

    public void close() {
        this.assertIsOpen();
        if (((JPAEntityManagerFactory)this.emf).isContainerManaged()) {
            throw new IllegalStateException(LOCALISER.msg("EM.ContainerManagedClose"));
        }
        try {
            this.om.close();
        }
        catch (NucleusException ne) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(ne);
        }
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.emf;
    }

    public JPAFetchPlan getFetchPlan() {
        return this.fetchPlan;
    }

    public boolean contains(Object entity) {
        this.assertIsOpen();
        this.assertEntity(entity);
        if (this.om.getApiAdapter().getExecutionContext(entity) != this.om) {
            return false;
        }
        if (this.om.getApiAdapter().isDeleted(entity)) {
            return false;
        }
        return !this.om.getApiAdapter().isDetached(entity);
    }

    public Object find(Class entityClass, Object primaryKey) {
        return this.find(entityClass, primaryKey, null, null);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        return this.find(entityClass, primaryKey, null, properties);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lock) {
        return this.find(entityClass, primaryKey, null, null);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lock, Map<String, Object> properties) {
        Object pc;
        this.assertLockModeValid(lock);
        this.assertIsOpen();
        this.assertEntity(entityClass);
        AbstractClassMetaData acmd = this.om.getMetaDataManager().getMetaDataForClass(entityClass, this.om.getClassLoaderResolver());
        if (acmd == null) {
            this.throwException((RuntimeException)new EntityNotFoundException());
        }
        try {
            Object id = primaryKey;
            if (acmd.getIdentityType() == IdentityType.DATASTORE) {
                if (!(primaryKey instanceof OID)) {
                    id = OIDFactory.getInstance((NucleusContext)this.om.getNucleusContext(), (String)acmd.getFullClassName(), (Object)primaryKey);
                }
            } else if (!acmd.getObjectidClass().equals(primaryKey.getClass().getName())) {
                if (acmd.usesSingleFieldIdentityClass() && this.om.getNucleusContext().getIdentityKeyTranslator() == null && this.om.getNucleusContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.api.findTypeConversion")) {
                    String[] pkNames = acmd.getPrimaryKeyMemberNames();
                    AbstractMemberMetaData mmd = acmd.getMetaDataForMember(pkNames[0]);
                    if (primaryKey instanceof Long && mmd.getType() != Long.class) {
                        primaryKey = TypeConversionHelper.convertTo((Object)primaryKey, (Class)mmd.getType());
                    } else if (primaryKey instanceof Integer && mmd.getType() != Integer.class) {
                        primaryKey = TypeConversionHelper.convertTo((Object)primaryKey, (Class)mmd.getType());
                    } else if (primaryKey instanceof Short && mmd.getType() != Short.class) {
                        primaryKey = TypeConversionHelper.convertTo((Object)primaryKey, (Class)mmd.getType());
                    }
                }
                try {
                    id = this.om.newObjectId(entityClass, primaryKey);
                }
                catch (NucleusException ne) {
                    throw new IllegalArgumentException(ne);
                }
            }
            if (lock != null && lock != LockModeType.NONE) {
                this.om.getLockManager().lock(id, JPAEntityManager.getLockTypeForJPALockModeType(lock));
            }
            pc = this.om.findObject(id, true, true, null);
        }
        catch (NucleusObjectNotFoundException ex) {
            return null;
        }
        if (this.om.getApiAdapter().isTransactional(pc)) {
            ObjectProvider sm = this.om.findObjectProvider(pc);
            if (this.om.getApiAdapter().isDeleted(pc)) {
                try {
                    sm.locate();
                }
                catch (NucleusObjectNotFoundException ex) {
                    return null;
                }
            }
        }
        return (T)pc;
    }

    public Object getDelegate() {
        this.assertIsOpen();
        return this.om;
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls == ObjectManager.class || cls == ObjectManagerImpl.class) {
            return (T)this.om;
        }
        return (T)this.throwException((RuntimeException)new PersistenceException("Not yet supported"));
    }

    public Object getReference(Class entityClass, Object primaryKey) {
        this.assertIsOpen();
        this.assertEntity(entityClass);
        Object id = null;
        try {
            id = this.om.newObjectId(entityClass, primaryKey);
        }
        catch (NucleusException ne) {
            throw new IllegalArgumentException(ne);
        }
        try {
            return this.om.findObject(id, false, false, null);
        }
        catch (NucleusObjectNotFoundException ne) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException((NucleusException)((Object)ne));
        }
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.lock(entity, lockMode, null);
    }

    public void lock(Object entity, LockModeType lock, Map<String, Object> properties) {
        this.assertLockModeValid(lock);
        this.assertIsOpen();
        this.assertIsActive();
        this.assertEntity(entity);
        if (this.om.getApiAdapter().isDetached(entity)) {
            throw new IllegalArgumentException(LOCALISER.msg("EM.EntityIsDetached", (Object)StringUtils.toJVMIDString((Object)entity), (Object)("" + this.om.getApiAdapter().getIdForObject(entity))));
        }
        if (!this.contains(entity)) {
            this.throwException((RuntimeException)new PersistenceException("Entity is not contained in this persistence context so cant lock it"));
        }
        AbstractClassMetaData cmd = this.om.getMetaDataManager().getMetaDataForClass(entity.getClass(), this.om.getClassLoaderResolver());
        if (lock == LockModeType.OPTIMISTIC || lock == LockModeType.OPTIMISTIC_FORCE_INCREMENT && !cmd.isVersioned()) {
            throw new PersistenceException("Object of type " + entity.getClass().getName() + " is not versioned so cannot lock optimistically!");
        }
        if (lock != null && lock != LockModeType.NONE) {
            this.om.getLockManager().lock(this.om.findObjectProvider(entity), JPAEntityManager.getLockTypeForJPALockModeType(lock));
        }
    }

    public void persist(Object entity) {
        this.assertIsOpen();
        this.assertTransactionNotRequired();
        this.assertEntity(entity);
        if (this.om.exists(entity) && this.om.getApiAdapter().isDetached(entity)) {
            this.throwException((RuntimeException)new EntityExistsException(LOCALISER.msg("EM.EntityIsPersistent", (Object)StringUtils.toJVMIDString((Object)entity))));
        }
        try {
            this.om.persistObject(entity, false);
        }
        catch (NucleusException ne) {
            this.throwException((RuntimeException)NucleusJPAHelper.getJPAExceptionForNucleusException(ne));
        }
    }

    public Object merge(Object entity) {
        this.assertIsOpen();
        this.assertTransactionNotRequired();
        this.assertEntity(entity);
        if (this.om.getApiAdapter().isDeleted(entity)) {
            throw new IllegalArgumentException(LOCALISER.msg("EM.EntityIsDeleted", (Object)StringUtils.toJVMIDString((Object)entity), (Object)("" + this.om.getApiAdapter().getIdForObject(entity))));
        }
        try {
            return this.om.persistObject(entity, true);
        }
        catch (NucleusException ne) {
            return this.throwException((RuntimeException)NucleusJPAHelper.getJPAExceptionForNucleusException(ne));
        }
    }

    public void detach(Object entity) {
        this.assertIsOpen();
        this.assertEntity(entity);
        try {
            this.om.detachObject(entity, (FetchPlanState)new DetachState(this.om.getApiAdapter()));
        }
        catch (NucleusException ne) {
            this.throwException((RuntimeException)NucleusJPAHelper.getJPAExceptionForNucleusException(ne));
        }
    }

    public void refresh(Object entity) {
        this.refresh(entity, null, null);
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        this.refresh(entity, null, properties);
    }

    public void refresh(Object entity, LockModeType lock) {
        this.refresh(entity, lock, null);
    }

    public void refresh(Object entity, LockModeType lock, Map<String, Object> properties) {
        this.assertLockModeValid(lock);
        this.assertIsOpen();
        this.assertTransactionNotRequired();
        this.assertEntity(entity);
        if (this.om.getApiAdapter().getExecutionContext(entity) != this.om) {
            throw new IllegalArgumentException(LOCALISER.msg("EM.EntityIsNotManaged", (Object)StringUtils.toJVMIDString((Object)entity)));
        }
        if (!this.om.exists(entity)) {
            this.throwException((RuntimeException)new EntityNotFoundException(LOCALISER.msg("EM.EntityNotInDatastore", (Object)StringUtils.toJVMIDString((Object)entity))));
        }
        try {
            if (lock != null && lock != LockModeType.NONE) {
                this.om.getLockManager().lock(this.om.getApiAdapter().getIdForObject(entity), JPAEntityManager.getLockTypeForJPALockModeType(lock));
            }
            this.om.refreshObject(entity);
        }
        catch (NucleusException ne) {
            this.throwException((RuntimeException)NucleusJPAHelper.getJPAExceptionForNucleusException(ne));
        }
    }

    public void remove(Object entity) {
        this.assertIsOpen();
        this.assertTransactionNotRequired();
        if (entity == null) {
            return;
        }
        this.assertEntity(entity);
        if (this.om.getApiAdapter().isDetached(entity)) {
            throw new IllegalArgumentException(LOCALISER.msg("EM.EntityIsDetached", (Object)StringUtils.toJVMIDString((Object)entity), (Object)("" + this.om.getApiAdapter().getIdForObject(entity))));
        }
        try {
            this.om.deleteObject(entity);
        }
        catch (NucleusException ne) {
            this.throwException((RuntimeException)NucleusJPAHelper.getJPAExceptionForNucleusException(ne));
        }
    }

    public void flush() {
        this.assertIsOpen();
        this.assertIsActive();
        try {
            this.om.flush();
        }
        catch (NucleusException ne) {
            this.throwException((RuntimeException)NucleusJPAHelper.getJPAExceptionForNucleusException(ne));
        }
    }

    public FlushModeType getFlushMode() {
        this.assertIsOpen();
        return this.flushMode;
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.assertIsOpen();
        this.flushMode = flushMode;
    }

    public LockModeType getLockMode(Object entity) {
        this.assertIsActive();
        this.assertEntity(entity);
        if (this.om.getApiAdapter().getExecutionContext(entity) != this.om) {
            throw new IllegalArgumentException(LOCALISER.msg("EM.EntityIsNotManaged", (Object)StringUtils.toJVMIDString((Object)entity)));
        }
        if (this.om.getApiAdapter().isDetached(entity)) {
            throw new IllegalArgumentException(LOCALISER.msg("EM.EntityIsNotManaged", (Object)StringUtils.toJVMIDString((Object)entity)));
        }
        ObjectProvider sm = this.om.findObjectProvider(entity);
        return JPAEntityManager.getJPALockModeTypeForLockType(sm.getLockMode());
    }

    public EntityTransaction getTransaction() {
        if (this.tx == null) {
            throw new IllegalStateException(LOCALISER.msg("EM.TransactionNotLocal"));
        }
        return this.tx;
    }

    public void joinTransaction() {
        this.assertIsOpen();
        this.tx = new JPAEntityTransaction((ExecutionContext)this.om);
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        CriteriaQueryImpl criteria = (CriteriaQueryImpl)criteriaQuery;
        String jpqlString = criteria.toString();
        TypedQuery query = null;
        QueryCompilation compilation = criteria.getCompilation(this.om.getMetaDataManager(), this.om.getClassLoaderResolver());
        query = criteria.getResultType() != null && criteria.getResultType() != compilation.getCandidateClass() ? this.createQuery(jpqlString, criteria.getResultType()) : this.createQuery(jpqlString);
        org.datanucleus.store.query.Query internalQuery = query.getInternalQuery();
        if (compilation.getExprResult() == null) {
            internalQuery.setResult(null);
        }
        internalQuery.setCompilation(compilation);
        return query;
    }

    public CriteriaBuilder getCriteriaBuilder() {
        this.assertIsOpen();
        return new CriteriaBuilderImpl((MetamodelImpl)this.getMetamodel());
    }

    public <T> TypedQuery<T> createNamedQuery(String queryName, Class<T> resultClass) {
        return this.createNamedQuery(queryName).setResultClass(resultClass);
    }

    public JPAQuery createNamedQuery(String queryName) {
        this.assertIsOpen();
        if (queryName == null) {
            throw new IllegalArgumentException(LOCALISER.msg("Query.NamedQueryNotFound", (Object)queryName));
        }
        ClassLoaderResolver clr = this.om.getClassLoaderResolver();
        QueryMetaData qmd = this.om.getMetaDataManager().getMetaDataForQuery(null, clr, queryName);
        if (qmd == null) {
            throw new IllegalArgumentException(LOCALISER.msg("Query.NamedQueryNotFound", (Object)queryName));
        }
        try {
            if (qmd.getLanguage().equals(QueryLanguage.JPQL.toString())) {
                org.datanucleus.store.query.Query internalQuery = this.om.getStoreManager().getQueryManager().newQuery(qmd.getLanguage().toString(), (ExecutionContext)this.om, (Object)qmd.getQuery());
                return new JPAQuery(this, internalQuery, qmd.getLanguage());
            }
            if (qmd.getLanguage().equals(QueryLanguage.SQL.toString())) {
                org.datanucleus.store.query.Query internalQuery = this.om.getStoreManager().getQueryManager().newQuery(qmd.getLanguage(), (ExecutionContext)this.om, (Object)qmd.getQuery());
                if (qmd.getResultClass() != null) {
                    String resultClassName = qmd.getResultClass();
                    Class resultClass = null;
                    try {
                        resultClass = this.om.getClassLoaderResolver().classForName(resultClassName);
                        internalQuery.setResultClass(resultClass);
                        return new JPAQuery(this, internalQuery, qmd.getLanguage());
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(LOCALISER.msg("Query.ResultClassNotFound", (Object)qmd.getName(), (Object)resultClassName));
                    }
                }
                if (qmd.getResultMetaDataName() != null) {
                    QueryResultMetaData qrmd = this.om.getMetaDataManager().getMetaDataForQueryResult(qmd.getResultMetaDataName());
                    if (qrmd == null) {
                        throw new IllegalArgumentException(LOCALISER.msg("Query.ResultSetMappingNotFound", (Object)qmd.getResultMetaDataName()));
                    }
                    internalQuery.setResultMetaData(qrmd);
                    return new JPAQuery(this, internalQuery, qmd.getLanguage());
                }
                return new JPAQuery(this, internalQuery, qmd.getLanguage());
            }
            throw new IllegalArgumentException(LOCALISER.msg("Query.LanguageNotSupportedByStore", (Object)qmd.getLanguage()));
        }
        catch (NucleusException ne) {
            throw new IllegalArgumentException(ne.getMessage(), ne);
        }
    }

    public Query createNativeQuery(String sqlString) {
        return this.createNativeQuery(sqlString, (Class)null);
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        this.assertIsOpen();
        try {
            org.datanucleus.store.query.Query internalQuery = this.om.getStoreManager().getQueryManager().newQuery(QueryLanguage.SQL.toString(), (ExecutionContext)this.om, (Object)sqlString);
            if (resultClass != null) {
                internalQuery.setResultClass(resultClass);
            }
            return new JPAQuery(this, internalQuery, QueryLanguage.SQL.toString());
        }
        catch (NucleusException ne) {
            throw new IllegalArgumentException(ne.getMessage(), ne);
        }
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        this.assertIsOpen();
        try {
            org.datanucleus.store.query.Query internalQuery = this.om.getStoreManager().getQueryManager().newQuery(QueryLanguage.SQL.toString(), (ExecutionContext)this.om, (Object)sqlString);
            QueryResultMetaData qrmd = this.om.getMetaDataManager().getMetaDataForQueryResult(resultSetMapping);
            if (qrmd == null) {
                throw new IllegalArgumentException(LOCALISER.msg("Query.ResultSetMappingNotFound", (Object)resultSetMapping));
            }
            internalQuery.setResultMetaData(qrmd);
            return new JPAQuery(this, internalQuery, QueryLanguage.SQL.toString());
        }
        catch (NucleusException ne) {
            throw new IllegalArgumentException(ne.getMessage(), ne);
        }
    }

    public StoredProcedureQuery createNamedStoredProcedureQuery(String procName) {
        if (procName == null) {
            throw new IllegalArgumentException(LOCALISER.msg("Query.NamedStoredProcedureQueryNotFound", (Object)procName));
        }
        ClassLoaderResolver clr = this.om.getClassLoaderResolver();
        StoredProcQueryMetaData qmd = this.om.getMetaDataManager().getMetaDataForStoredProcQuery(null, clr, procName);
        if (qmd == null) {
            throw new IllegalArgumentException(LOCALISER.msg("Query.NamedStoredProcedureQueryNotFound", (Object)procName));
        }
        try {
            AbstractStoredProcedureQuery internalQuery = (AbstractStoredProcedureQuery)this.om.getStoreManager().getQueryManager().newQuery(QueryLanguage.STOREDPROC.toString(), (ExecutionContext)this.om, (Object)qmd.getProcedureName());
            if (qmd.getParameters() != null) {
                for (StoredProcQueryParameterMetaData parammd : qmd.getParameters()) {
                    Class type = clr.classForName(parammd.getType());
                    internalQuery.registerParameter(parammd.getName(), type, parammd.getMode());
                }
            }
            if (qmd.getResultClasses() != null) {
                Class[] resultClasses = new Class[qmd.getResultClasses().size()];
                int i = 0;
                for (String clsName : qmd.getResultClasses()) {
                    resultClasses[i++] = clr.classForName(clsName);
                }
                internalQuery.setResultClasses(resultClasses);
            } else if (qmd.getResultSetMappings() != null) {
                QueryResultMetaData[] qrmds = new QueryResultMetaData[qmd.getResultSetMappings().size()];
                int i = 0;
                for (String resultSetMappingName : qmd.getResultSetMappings()) {
                    qrmds[i] = this.om.getMetaDataManager().getMetaDataForQueryResult(resultSetMappingName);
                    if (qrmds[i] == null) {
                        throw new IllegalArgumentException(LOCALISER.msg("Query.ResultSetMappingNotFound", (Object)resultSetMappingName));
                    }
                    ++i;
                }
                internalQuery.setResultMetaData(qrmds);
            }
            return new JPAStoredProcedureQuery(this, (org.datanucleus.store.query.Query)internalQuery);
        }
        catch (NucleusException ne) {
            throw new IllegalArgumentException(ne.getMessage(), ne);
        }
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procName) {
        this.assertIsOpen();
        try {
            org.datanucleus.store.query.Query internalQuery = this.om.getStoreManager().getQueryManager().newQuery(QueryLanguage.STOREDPROC.toString(), (ExecutionContext)this.om, (Object)procName);
            return new JPAStoredProcedureQuery(this, internalQuery);
        }
        catch (NucleusException ne) {
            throw new IllegalArgumentException(ne.getMessage(), ne);
        }
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, Class ... resultClasses) {
        this.assertIsOpen();
        try {
            org.datanucleus.store.query.Query internalQuery = this.om.getStoreManager().getQueryManager().newQuery(QueryLanguage.STOREDPROC.toString(), (ExecutionContext)this.om, (Object)procedureName);
            if (resultClasses != null && resultClasses.length > 0) {
                ((AbstractStoredProcedureQuery)internalQuery).setResultClasses(resultClasses);
            }
            return new JPAStoredProcedureQuery(this, internalQuery);
        }
        catch (NucleusException ne) {
            throw new IllegalArgumentException(ne.getMessage(), ne);
        }
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        this.assertIsOpen();
        try {
            org.datanucleus.store.query.Query internalQuery = this.om.getStoreManager().getQueryManager().newQuery(QueryLanguage.STOREDPROC.toString(), (ExecutionContext)this.om, (Object)procedureName);
            if (resultSetMappings != null && resultSetMappings.length > 0) {
                QueryResultMetaData[] qrmds = new QueryResultMetaData[resultSetMappings.length];
                for (int i = 0; i < qrmds.length; ++i) {
                    qrmds[i] = this.om.getMetaDataManager().getMetaDataForQueryResult(resultSetMappings[i]);
                    if (qrmds[i] != null) continue;
                    throw new IllegalArgumentException(LOCALISER.msg("Query.ResultSetMappingNotFound", (Object)resultSetMappings[i]));
                }
                ((AbstractStoredProcedureQuery)internalQuery).setResultMetaData(qrmds);
            }
            return new JPAStoredProcedureQuery(this, internalQuery);
        }
        catch (NucleusException ne) {
            throw new IllegalArgumentException(ne.getMessage(), ne);
        }
    }

    public <T> TypedQuery<T> createQuery(String queryString, Class<T> resultClass) {
        return this.createQuery(queryString).setResultClass(resultClass);
    }

    public JPAQuery createQuery(String queryString) {
        this.assertIsOpen();
        try {
            org.datanucleus.store.query.Query internalQuery = this.om.getStoreManager().getQueryManager().newQuery(QueryLanguage.JPQL.toString(), (ExecutionContext)this.om, (Object)queryString);
            return new JPAQuery(this, internalQuery, QueryLanguage.JPQL.toString());
        }
        catch (NucleusException ne) {
            throw new IllegalArgumentException(ne.getMessage(), ne);
        }
    }

    public void setProperty(String propertyName, Object value) {
        try {
            this.om.setProperty(propertyName, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Property '" + propertyName + "' value=" + value + " invalid");
        }
    }

    public Map<String, Object> getProperties() {
        return this.om.getProperties();
    }

    public Set<String> getSupportedProperties() {
        return this.om.getSupportedProperties();
    }

    public Metamodel getMetamodel() {
        return this.emf.getMetamodel();
    }

    private void assertIsOpen() {
        if (this.om.isClosed()) {
            throw new IllegalStateException(LOCALISER.msg("EM.IsClosed"));
        }
    }

    private void assertIsActive() {
        if (!this.isTransactionActive()) {
            throw new TransactionRequiredException(LOCALISER.msg("EM.TransactionRequired"));
        }
    }

    private boolean isTransactionActive() {
        return this.tx != null && this.tx.isActive();
    }

    private void assertLockModeValid(LockModeType lock) {
        if (lock != null && lock != LockModeType.NONE && !this.isTransactionActive()) {
            throw new TransactionRequiredException(LOCALISER.msg("EM.TransactionRequired"));
        }
    }

    private void assertEntity(Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException(LOCALISER.msg("EM.EntityNotAnEntity", entity));
        }
        Class<?> cls = null;
        cls = entity instanceof Class ? (Class<?>)entity : entity.getClass();
        try {
            this.om.assertClassPersistable(cls);
        }
        catch (NucleusException ne) {
            throw new IllegalArgumentException(LOCALISER.msg("EM.EntityNotAnEntity", (Object)cls.getName()), ne);
        }
    }

    private void assertTransactionNotRequired() {
        if (this.persistenceContextType == PersistenceContextType.TRANSACTION && !this.isTransactionActive()) {
            throw new TransactionRequiredException(LOCALISER.msg("EM.TransactionRequired"));
        }
    }

    private Object throwException(RuntimeException re) {
        if (re instanceof PersistenceException) {
            boolean markForRollback;
            PersistenceConfiguration conf = this.om.getNucleusContext().getPersistenceConfiguration();
            if (this.tx.isActive() && (markForRollback = conf.getBooleanProperty("datanucleus.jpa.txnMarkForRollbackOnException"))) {
                this.getTransaction().setRollbackOnly();
            }
        }
        throw re;
    }

    public static short getLockTypeForJPALockModeType(LockModeType lock) {
        int lockModeType = 0;
        if (lock == LockModeType.OPTIMISTIC || lock == LockModeType.READ) {
            lockModeType = 1;
        } else if (lock == LockModeType.OPTIMISTIC_FORCE_INCREMENT || lock == LockModeType.WRITE) {
            lockModeType = 2;
        } else if (lock == LockModeType.PESSIMISTIC_READ) {
            lockModeType = 3;
        } else if (lock == LockModeType.PESSIMISTIC_FORCE_INCREMENT || lock == LockModeType.PESSIMISTIC_WRITE) {
            lockModeType = 4;
        }
        return (short)lockModeType;
    }

    public static LockModeType getJPALockModeTypeForLockType(short lockType) {
        if (lockType == 1) {
            return LockModeType.OPTIMISTIC;
        }
        if (lockType == 2) {
            return LockModeType.OPTIMISTIC_FORCE_INCREMENT;
        }
        if (lockType == 3) {
            return LockModeType.PESSIMISTIC_READ;
        }
        if (lockType == 4) {
            return LockModeType.PESSIMISTIC_WRITE;
        }
        return LockModeType.NONE;
    }
}

