/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.enhancement;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.datanucleus.api.jpa.enhancement.SingleFieldPK;

public class CharFieldPK
extends SingleFieldPK {
    private char key;

    public CharFieldPK(Class pcClass, char key) {
        super(pcClass);
        this.key = key;
        this.hashCode = this.hashClassName() ^ this.key;
    }

    public CharFieldPK(Class pcClass, Character key) {
        super(pcClass);
        this.setKeyAsObject(key);
        this.key = key.charValue();
        this.hashCode = this.hashClassName() ^ this.key;
    }

    public CharFieldPK(Class pcClass, String str) {
        super(pcClass);
        this.assertKeyNotNull(str);
        if (str.length() != 1) {
            throw new IllegalArgumentException("CharIdentity should have a value of length 1");
        }
        this.key = str.charAt(0);
        this.hashCode = this.hashClassName() ^ this.key;
    }

    public CharFieldPK() {
    }

    public char getKey() {
        return this.key;
    }

    public String toString() {
        return String.valueOf(this.key);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        CharFieldPK other = (CharFieldPK)obj;
        return this.key == other.key;
    }

    public int compareTo(Object o) {
        if (o instanceof CharFieldPK) {
            CharFieldPK other = (CharFieldPK)o;
            return this.key - other.key;
        }
        if (o == null) {
            throw new ClassCastException("object is null");
        }
        throw new ClassCastException(this.getClass().getName() + " != " + o.getClass().getName());
    }

    protected Object createKeyAsObject() {
        return Character.valueOf(this.key);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeChar(this.key);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.key = in.readChar();
    }
}

