/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.metamodel;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.jpa.metamodel.AttributeImpl;
import org.datanucleus.api.jpa.metamodel.CollectionAttributeImpl;
import org.datanucleus.api.jpa.metamodel.ListAttributeImpl;
import org.datanucleus.api.jpa.metamodel.MapAttributeImpl;
import org.datanucleus.api.jpa.metamodel.MetamodelImpl;
import org.datanucleus.api.jpa.metamodel.PluralAttributeImpl;
import org.datanucleus.api.jpa.metamodel.SetAttributeImpl;
import org.datanucleus.api.jpa.metamodel.SingularAttributeImpl;
import org.datanucleus.api.jpa.metamodel.TypeImpl;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedTypeImpl<X>
extends TypeImpl<X>
implements ManagedType<X> {
    protected AbstractClassMetaData cmd;
    protected MetamodelImpl model;
    protected Map<String, Attribute<X, ?>> attributes = new HashMap();

    protected ManagedTypeImpl(Class<X> cls, AbstractClassMetaData cmd, MetamodelImpl model) {
        super(cls);
        this.model = model;
        this.cmd = cmd;
        AbstractMemberMetaData[] mmds = cmd.getManagedMembers();
        ClassLoaderResolver clr = model.getClassLoaderResolver();
        for (int i = 0; i < mmds.length; ++i) {
            int relationType = mmds[i].getRelationType(clr);
            AttributeImpl attr = null;
            switch (relationType) {
                case 3: 
                case 4: {
                    if (mmds[i].hasCollection()) {
                        if (List.class.isAssignableFrom(mmds[i].getType())) {
                            attr = new ListAttributeImpl(mmds[i], this);
                            break;
                        }
                        if (Set.class.isAssignableFrom(mmds[i].getType())) {
                            attr = new SetAttributeImpl(mmds[i], this);
                            break;
                        }
                        attr = new CollectionAttributeImpl(mmds[i], this);
                        break;
                    }
                    if (mmds[i].hasMap()) {
                        attr = new MapAttributeImpl(mmds[i], this);
                        break;
                    }
                    if (!mmds[i].hasArray()) break;
                    attr = new CollectionAttributeImpl(mmds[i], this);
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    attr = new SingularAttributeImpl(mmds[i], this);
                    break;
                }
                case 5: {
                    attr = new CollectionAttributeImpl(mmds[i], this);
                    break;
                }
                default: {
                    attr = mmds[i].getType().isArray() ? new PluralAttributeImpl(mmds[i], this) : (Collection.class.isAssignableFrom(mmds[i].getType()) ? new CollectionAttributeImpl(mmds[i], this) : new SingularAttributeImpl(mmds[i], this));
                }
            }
            this.attributes.put(mmds[i].getName(), attr);
        }
    }

    public AbstractClassMetaData getMetadata() {
        return this.cmd;
    }

    public MetamodelImpl getModel() {
        return this.model;
    }

    public Attribute<? super X, ?> getAttribute(String attr) {
        AttributeImpl theAttr = (AttributeImpl)this.attributes.get(attr);
        if (theAttr == null) {
            if (this.cmd.getSuperAbstractClassMetaData() != null) {
                Class supercls = this.model.getClassLoaderResolver().classForName(this.cmd.getSuperAbstractClassMetaData().getFullClassName());
                ManagedType supertype = this.model.managedType(supercls);
                return supertype.getAttribute(attr);
            }
            throw new IllegalArgumentException("Attribute " + attr + " was not found in class");
        }
        return theAttr;
    }

    public Set<Attribute<? super X, ?>> getAttributes() {
        HashSet set = new HashSet();
        set.addAll(this.attributes.values());
        if (this.cmd.getSuperAbstractClassMetaData() != null) {
            Class supercls = this.model.getClassLoaderResolver().classForName(this.cmd.getSuperAbstractClassMetaData().getFullClassName());
            ManagedType supertype = this.model.managedType(supercls);
            Set superattrs = supertype.getAttributes();
            set.addAll(superattrs);
        }
        return set;
    }

    public Attribute<X, ?> getDeclaredAttribute(String attr) {
        AttributeImpl theAttr = (AttributeImpl)this.attributes.get(attr);
        if (theAttr == null) {
            throw new IllegalArgumentException("Attribute " + attr + " was not found in class");
        }
        AbstractMemberMetaData mmd = theAttr.getMetadata();
        Class thisCls = this.model.getClassLoaderResolver().classForName(this.cmd.getFullClassName());
        if (mmd.getMemberRepresented().getDeclaringClass() != thisCls) {
            throw new IllegalArgumentException("Attribute " + attr + " isn't defined in " + this.cmd.getFullClassName());
        }
        return theAttr;
    }

    public Set<Attribute<X, ?>> getDeclaredAttributes() {
        Class thisCls = this.model.getClassLoaderResolver().classForName(this.cmd.getFullClassName());
        HashSet attrs = new HashSet();
        for (Map.Entry<String, Attribute<X, ?>> entry : this.attributes.entrySet()) {
            AttributeImpl attr = (AttributeImpl)entry.getValue();
            AbstractMemberMetaData mmd = attr.getMetadata();
            if (mmd.getMemberRepresented().getDeclaringClass() != thisCls) continue;
            attrs.add(attr);
        }
        return attrs;
    }

    public <E> CollectionAttribute<? super X, E> getCollection(String attr, Class<E> elementType) {
        AttributeImpl theAttr = (AttributeImpl)this.attributes.get(attr);
        if (theAttr == null) {
            if (this.cmd.getSuperAbstractClassMetaData() != null) {
                Class supercls = this.model.getClassLoaderResolver().classForName(this.cmd.getSuperAbstractClassMetaData().getFullClassName());
                ManagedType supertype = this.model.managedType(supercls);
                return supertype.getCollection(attr, elementType);
            }
            throw new IllegalArgumentException("Attribute " + attr + " was not found in class");
        }
        AbstractMemberMetaData mmd = theAttr.getMetadata();
        if (!Collection.class.isAssignableFrom(mmd.getType())) {
            throw new IllegalArgumentException("Attribute " + attr + " isnt a collection");
        }
        Class elementCls = this.model.getClassLoaderResolver().classForName(mmd.getCollection().getElementType());
        if (!elementType.isAssignableFrom(elementCls)) {
            throw new IllegalArgumentException("Attribute " + attr + " doesn't have a collection with element of type " + elementType.getName());
        }
        return (CollectionAttribute)theAttr;
    }

    public CollectionAttribute<? super X, ?> getCollection(String attr) {
        AttributeImpl theAttr = (AttributeImpl)this.attributes.get(attr);
        if (theAttr == null) {
            if (this.cmd.getSuperAbstractClassMetaData() != null) {
                Class supercls = this.model.getClassLoaderResolver().classForName(this.cmd.getSuperAbstractClassMetaData().getFullClassName());
                ManagedType supertype = this.model.managedType(supercls);
                return supertype.getCollection(attr);
            }
            throw new IllegalArgumentException("Attribute " + attr + " was not found in class");
        }
        AbstractMemberMetaData mmd = theAttr.getMetadata();
        if (!Collection.class.isAssignableFrom(mmd.getType())) {
            throw new IllegalArgumentException("Attribute " + attr + " isnt a collection");
        }
        return (CollectionAttribute)theAttr;
    }

    public <E> CollectionAttribute<X, E> getDeclaredCollection(String attr, Class<E> elementType) {
        AttributeImpl theAttr = (AttributeImpl)this.attributes.get(attr);
        if (theAttr == null) {
            throw new IllegalArgumentException("Attribute " + attr + " was not found in class");
        }
        AbstractMemberMetaData mmd = theAttr.getMetadata();
        if (!Collection.class.isAssignableFrom(mmd.getType())) {
            throw new IllegalArgumentException("Attribute " + attr + " isnt a collection");
        }
        Class elementCls = this.model.getClassLoaderResolver().classForName(mmd.getCollection().getElementType());
        if (!elementType.isAssignableFrom(elementCls)) {
            throw new IllegalArgumentException("Attribute " + attr + " doesn't have a collection with element of type " + elementType.getName());
        }
        Class thisCls = this.model.getClassLoaderResolver().classForName(this.cmd.getFullClassName());
        if (mmd.getMemberRepresented().getDeclaringClass() != thisCls) {
            throw new IllegalArgumentException("Attribute " + attr + " isn't defined in " + this.cmd.getFullClassName());
        }
        return (CollectionAttribute)theAttr;
    }

    public CollectionAttribute<X, ?> getDeclaredCollection(String attr) {
        AttributeImpl theAttr = (AttributeImpl)this.attributes.get(attr);
        if (theAttr == null) {
            throw new IllegalArgumentException("Attribute " + attr + " was not found in class");
        }
        AbstractMemberMetaData mmd = theAttr.getMetadata();
        if (!Collection.class.isAssignableFrom(mmd.getType())) {
            throw new IllegalArgumentException("Attribute " + attr + " isnt a collection");
        }
        Class thisCls = this.model.getClassLoaderResolver().classForName(this.cmd.getFullClassName());
        if (mmd.getMemberRepresented().getDeclaringClass() != thisCls) {
            throw new IllegalArgumentException("Attribute " + attr + " isn't defined in " + this.cmd.getFullClassName());
        }
        return (CollectionAttribute)theAttr;
    }

    public <E> ListAttribute<? super X, E> getList(String attr, Class<E> elementType) {
        AttributeImpl theAttr = (AttributeImpl)this.attributes.get(attr);
        if (theAttr == null) {
            if (this.cmd.getSuperAbstractClassMetaData() != null) {
                Class supercls = this.model.getClassLoaderResolver().classForName(this.cmd.getSuperAbstractClassMetaData().getFullClassName());
                ManagedType supertype = this.model.managedType(supercls);
                return supertype.getList(attr, elementType);
            }
            throw new IllegalArgumentException("Attribute " + attr + " was not found in class");
        }
        AbstractMemberMetaData mmd = theAttr.getMetadata();
        if (!List.class.isAssignableFrom(mmd.getType())) {
            throw new IllegalArgumentException("Attribute " + attr + " isnt a List");
        }
        Class elementCls = this.model.getClassLoaderResolver().classForName(mmd.getCollection().getElementType());
        if (!elementType.isAssignableFrom(elementCls)) {
            throw new IllegalArgumentException("Attribute " + attr + " doesn't have a List with element of type " + elementType.getName());
        }
        return (ListAttribute)theAttr;
    }

    public ListAttribute<? super X, ?> getList(String attr) {
        AttributeImpl theAttr = (AttributeImpl)this.attributes.get(attr);
        if (theAttr == null) {
            if (this.cmd.getSuperAbstractClassMetaData() != null) {
                Class supercls = this.model.getClassLoaderResolver().classForName(this.cmd.getSuperAbstractClassMetaData().getFullClassName());
                ManagedType supertype = this.model.managedType(supercls);
                return supertype.getList(attr);
            }
            throw new IllegalArgumentException("Attribute " + attr + " was not found in class");
        }
        AbstractMemberMetaData mmd = theAttr.getMetadata();
        if (!List.class.isAssignableFrom(mmd.getType())) {
            throw new IllegalArgumentException("Attribute " + attr + " isnt a List");
        }
        return (ListAttribute)theAttr;
    }

    public <E> ListAttribute<X, E> getDeclaredList(String attr, Class<E> elementType) {
        AttributeImpl theAttr = (AttributeImpl)this.attributes.get(attr);
        if (theAttr == null) {
            throw new IllegalArgumentException("Attribute " + attr + " was not found in class");
        }
        AbstractMemberMetaData mmd = theAttr.getMetadata();
        if (!List.class.isAssignableFrom(mmd.getType())) {
            throw new IllegalArgumentException("Attribute " + attr + " isnt a List");
        }
        Class elementCls = this.model.getClassLoaderResolver().classForName(mmd.getCollection().getElementType());
        if (!elementType.isAssignableFrom(elementCls)) {
            throw new IllegalArgumentException("Attribute " + attr + " doesn't have a List with element of type " + elementType.getName());
        }
        Class thisCls = this.model.getClassLoaderResolver().classForName(this.cmd.getFullClassName());
        if (mmd.getMemberRepresented().getDeclaringClass() != thisCls) {
            throw new IllegalArgumentException("Attribute " + attr + " isn't defined in " + this.cmd.getFullClassName());
        }
        return (ListAttribute)theAttr;
    }

    public ListAttribute<X, ?> getDeclaredList(String attr) {
        AttributeImpl theAttr = (AttributeImpl)this.attributes.get(attr);
        if (theAttr == null) {
            throw new IllegalArgumentException("Attribute " + attr + " was not found in class");
        }
        AbstractMemberMetaData mmd = theAttr.getMetadata();
        if (!List.class.isAssignableFrom(mmd.getType())) {
            throw new IllegalArgumentException("Attribute " + attr + " isnt a List");
        }
        Class thisCls = this.model.getClassLoaderResolver().classForName(this.cmd.getFullClassName());
        if (mmd.getMemberRepresented().getDeclaringClass() != thisCls) {
            throw new IllegalArgumentException("Attribute " + attr + " isn't defined in " + this.cmd.getFullClassName());
        }
        return (ListAttribute)theAttr;
    }

    public <K, V> MapAttribute<? super X, K, V> getMap(String attr, Class<K> keyType, Class<V> valueType) {
        AttributeImpl theAttr = (AttributeImpl)this.attributes.get(attr);
        if (theAttr == null) {
            if (this.cmd.getSuperAbstractClassMetaData() != null) {
                Class supercls = this.model.getClassLoaderResolver().classForName(this.cmd.getSuperAbstractClassMetaData().getFullClassName());
                ManagedType supertype = this.model.managedType(supercls);
                return supertype.getMap(attr, keyType, valueType);
            }
            throw new IllegalArgumentException("Attribute " + attr + " was not found in class");
        }
        AbstractMemberMetaData mmd = theAttr.getMetadata();
        if (!Map.class.isAssignableFrom(mmd.getType())) {
            throw new IllegalArgumentException("Attribute " + attr + " isnt a Map");
        }
        Class keyCls = this.model.getClassLoaderResolver().classForName(mmd.getMap().getKeyType());
        if (!keyType.isAssignableFrom(keyCls)) {
            throw new IllegalArgumentException("Attribute " + attr + " doesn't have a Map with Key of type " + keyType.getName());
        }
        Class valueCls = this.model.getClassLoaderResolver().classForName(mmd.getMap().getValueType());
        if (!valueType.isAssignableFrom(valueCls)) {
            throw new IllegalArgumentException("Attribute " + attr + " doesn't have a Map with Value of type " + valueType.getName());
        }
        return (MapAttribute)theAttr;
    }

    public MapAttribute<? super X, ?, ?> getMap(String attr) {
        AttributeImpl theAttr = (AttributeImpl)this.attributes.get(attr);
        if (theAttr == null) {
            if (this.cmd.getSuperAbstractClassMetaData() != null) {
                Class supercls = this.model.getClassLoaderResolver().classForName(this.cmd.getSuperAbstractClassMetaData().getFullClassName());
                ManagedType supertype = this.model.managedType(supercls);
                return supertype.getMap(attr);
            }
            throw new IllegalArgumentException("Attribute " + attr + " was not found in class");
        }
        AbstractMemberMetaData mmd = theAttr.getMetadata();
        if (!Map.class.isAssignableFrom(mmd.getType())) {
            throw new IllegalArgumentException("Attribute " + attr + " isnt a Map");
        }
        return (MapAttribute)theAttr;
    }

    public <K, V> MapAttribute<X, K, V> getDeclaredMap(String attr, Class<K> keyType, Class<V> valueType) {
        AttributeImpl theAttr = (AttributeImpl)this.attributes.get(attr);
        if (theAttr == null) {
            throw new IllegalArgumentException("Attribute " + attr + " was not found in class");
        }
        AbstractMemberMetaData mmd = theAttr.getMetadata();
        if (!Map.class.isAssignableFrom(mmd.getType())) {
            throw new IllegalArgumentException("Attribute " + attr + " isnt a Map");
        }
        Class keyCls = this.model.getClassLoaderResolver().classForName(mmd.getMap().getKeyType());
        if (!keyType.isAssignableFrom(keyCls)) {
            throw new IllegalArgumentException("Attribute " + attr + " doesn't have a Map with Key of type " + keyType.getName());
        }
        Class valueCls = this.model.getClassLoaderResolver().classForName(mmd.getMap().getValueType());
        if (!valueType.isAssignableFrom(valueCls)) {
            throw new IllegalArgumentException("Attribute " + attr + " doesn't have a Map with Value of type " + valueType.getName());
        }
        Class thisCls = this.model.getClassLoaderResolver().classForName(this.cmd.getFullClassName());
        if (mmd.getMemberRepresented().getDeclaringClass() != thisCls) {
            throw new IllegalArgumentException("Attribute " + attr + " isn't defined in " + this.cmd.getFullClassName());
        }
        return (MapAttribute)theAttr;
    }

    public MapAttribute<X, ?, ?> getDeclaredMap(String attr) {
        AttributeImpl theAttr = (AttributeImpl)this.attributes.get(attr);
        if (theAttr == null) {
            throw new IllegalArgumentException("Attribute " + attr + " was not found in class");
        }
        AbstractMemberMetaData mmd = theAttr.getMetadata();
        if (!Map.class.isAssignableFrom(mmd.getType())) {
            throw new IllegalArgumentException("Attribute " + attr + " isnt a Map");
        }
        Class thisCls = this.model.getClassLoaderResolver().classForName(this.cmd.getFullClassName());
        if (mmd.getMemberRepresented().getDeclaringClass() != thisCls) {
            throw new IllegalArgumentException("Attribute " + attr + " isn't defined in " + this.cmd.getFullClassName());
        }
        return (MapAttribute)theAttr;
    }

    public <E> SetAttribute<? super X, E> getSet(String attr, Class<E> elementType) {
        AttributeImpl theAttr = (AttributeImpl)this.attributes.get(attr);
        if (theAttr == null) {
            if (this.cmd.getSuperAbstractClassMetaData() != null) {
                Class supercls = this.model.getClassLoaderResolver().classForName(this.cmd.getSuperAbstractClassMetaData().getFullClassName());
                ManagedType supertype = this.model.managedType(supercls);
                return supertype.getSet(attr, elementType);
            }
            throw new IllegalArgumentException("Attribute " + attr + " was not found in class");
        }
        AbstractMemberMetaData mmd = theAttr.getMetadata();
        if (!Set.class.isAssignableFrom(mmd.getType())) {
            throw new IllegalArgumentException("Attribute " + attr + " isnt a Set");
        }
        Class elementCls = this.model.getClassLoaderResolver().classForName(mmd.getCollection().getElementType());
        if (!elementType.isAssignableFrom(elementCls)) {
            throw new IllegalArgumentException("Attribute " + attr + " doesn't have a Set with element of type " + elementType.getName());
        }
        return (SetAttribute)theAttr;
    }

    public SetAttribute<? super X, ?> getSet(String attr) {
        AttributeImpl theAttr = (AttributeImpl)this.attributes.get(attr);
        if (theAttr == null) {
            if (this.cmd.getSuperAbstractClassMetaData() != null) {
                Class supercls = this.model.getClassLoaderResolver().classForName(this.cmd.getSuperAbstractClassMetaData().getFullClassName());
                ManagedType supertype = this.model.managedType(supercls);
                return supertype.getSet(attr);
            }
            throw new IllegalArgumentException("Attribute " + attr + " was not found in class");
        }
        AbstractMemberMetaData mmd = theAttr.getMetadata();
        if (!Set.class.isAssignableFrom(mmd.getType())) {
            throw new IllegalArgumentException("Attribute " + attr + " isnt a Set");
        }
        return (SetAttribute)theAttr;
    }

    public <E> SetAttribute<X, E> getDeclaredSet(String attr, Class<E> elementType) {
        AttributeImpl theAttr = (AttributeImpl)this.attributes.get(attr);
        if (theAttr == null) {
            throw new IllegalArgumentException("Attribute " + attr + " was not found in class");
        }
        AbstractMemberMetaData mmd = theAttr.getMetadata();
        if (!Set.class.isAssignableFrom(mmd.getType())) {
            throw new IllegalArgumentException("Attribute " + attr + " isnt a Set");
        }
        Class elementCls = this.model.getClassLoaderResolver().classForName(mmd.getCollection().getElementType());
        if (!elementType.isAssignableFrom(elementCls)) {
            throw new IllegalArgumentException("Attribute " + attr + " doesn't have a Set with element of type " + elementType.getName());
        }
        Class thisCls = this.model.getClassLoaderResolver().classForName(this.cmd.getFullClassName());
        if (mmd.getMemberRepresented().getDeclaringClass() != thisCls) {
            throw new IllegalArgumentException("Attribute " + attr + " isn't defined in " + this.cmd.getFullClassName());
        }
        return (SetAttribute)theAttr;
    }

    public SetAttribute<X, ?> getDeclaredSet(String attr) {
        AttributeImpl theAttr = (AttributeImpl)this.attributes.get(attr);
        if (theAttr == null) {
            throw new IllegalArgumentException("Attribute " + attr + " was not found in class");
        }
        AbstractMemberMetaData mmd = theAttr.getMetadata();
        if (!Set.class.isAssignableFrom(mmd.getType())) {
            throw new IllegalArgumentException("Attribute " + attr + " isnt a Set");
        }
        Class thisCls = this.model.getClassLoaderResolver().classForName(this.cmd.getFullClassName());
        if (mmd.getMemberRepresented().getDeclaringClass() != thisCls) {
            throw new IllegalArgumentException("Attribute " + attr + " isn't defined in " + this.cmd.getFullClassName());
        }
        return (SetAttribute)theAttr;
    }

    public <Y> SingularAttribute<? super X, Y> getSingularAttribute(String attr, Class<Y> type) {
        AttributeImpl theAttr = (AttributeImpl)this.attributes.get(attr);
        if (theAttr == null) {
            if (this.cmd.getSuperAbstractClassMetaData() != null) {
                Class supercls = this.model.getClassLoaderResolver().classForName(this.cmd.getSuperAbstractClassMetaData().getFullClassName());
                ManagedType supertype = this.model.managedType(supercls);
                return supertype.getSingularAttribute(attr, type);
            }
            throw new IllegalArgumentException("Attribute " + attr + " was not found in class");
        }
        AbstractMemberMetaData mmd = theAttr.getMetadata();
        if (!type.isAssignableFrom(mmd.getType())) {
            throw new IllegalArgumentException("Attribute " + attr + " isnt of type " + type.getName());
        }
        return (SingularAttribute)theAttr;
    }

    public SingularAttribute<? super X, ?> getSingularAttribute(String attr) {
        AttributeImpl theAttr = (AttributeImpl)this.attributes.get(attr);
        if (theAttr == null) {
            if (this.cmd.getSuperAbstractClassMetaData() != null) {
                Class supercls = this.model.getClassLoaderResolver().classForName(this.cmd.getSuperAbstractClassMetaData().getFullClassName());
                ManagedType supertype = this.model.managedType(supercls);
                return supertype.getSingularAttribute(attr);
            }
            throw new IllegalArgumentException("Attribute " + attr + " was not found in class");
        }
        return (SingularAttribute)theAttr;
    }

    public Set<SingularAttribute<? super X, ?>> getSingularAttributes() {
        HashSet attrs = new HashSet();
        for (Map.Entry<String, Attribute<X, ?>> entry : this.attributes.entrySet()) {
            AttributeImpl attr = (AttributeImpl)entry.getValue();
            if (!(attr instanceof SingularAttribute)) continue;
            attrs.add((SingularAttribute)attr);
        }
        if (this.cmd.getSuperAbstractClassMetaData() != null) {
            Class supercls = this.model.getClassLoaderResolver().classForName(this.cmd.getSuperAbstractClassMetaData().getFullClassName());
            ManagedType supertype = this.model.managedType(supercls);
            Set superattrs = supertype.getSingularAttributes();
            attrs.addAll(superattrs);
        }
        return attrs;
    }

    public <Y> SingularAttribute<X, Y> getDeclaredSingularAttribute(String attr, Class<Y> type) {
        AttributeImpl theAttr = (AttributeImpl)this.attributes.get(attr);
        if (theAttr == null) {
            throw new IllegalArgumentException("Attribute " + attr + " was not found in class");
        }
        AbstractMemberMetaData mmd = theAttr.getMetadata();
        if (!type.isAssignableFrom(mmd.getType())) {
            throw new IllegalArgumentException("Attribute " + attr + " isnt of type " + type.getName());
        }
        Class thisCls = this.model.getClassLoaderResolver().classForName(this.cmd.getFullClassName());
        if (mmd.getMemberRepresented().getDeclaringClass() != thisCls) {
            throw new IllegalArgumentException("Attribute " + attr + " isn't defined in " + this.cmd.getFullClassName());
        }
        return (SingularAttribute)theAttr;
    }

    public SingularAttribute<X, ?> getDeclaredSingularAttribute(String attr) {
        AttributeImpl theAttr = (AttributeImpl)this.attributes.get(attr);
        if (theAttr == null) {
            throw new IllegalArgumentException("Attribute " + attr + " was not found in class");
        }
        AbstractMemberMetaData mmd = theAttr.getMetadata();
        Class thisCls = this.model.getClassLoaderResolver().classForName(this.cmd.getFullClassName());
        if (mmd.getMemberRepresented().getDeclaringClass() != thisCls) {
            throw new IllegalArgumentException("Attribute " + attr + " isn't defined in " + this.cmd.getFullClassName());
        }
        return (SingularAttribute)theAttr;
    }

    public Set<SingularAttribute<X, ?>> getDeclaredSingularAttributes() {
        Class thisCls = this.model.getClassLoaderResolver().classForName(this.cmd.getFullClassName());
        HashSet attrs = new HashSet();
        for (Map.Entry<String, Attribute<X, ?>> entry : this.attributes.entrySet()) {
            AbstractMemberMetaData mmd;
            AttributeImpl attr = (AttributeImpl)entry.getValue();
            if (!(attr instanceof SingularAttribute) || (mmd = attr.getMetadata()).getMemberRepresented().getDeclaringClass() != thisCls) continue;
            attrs.add((SingularAttribute)attr);
        }
        return attrs;
    }

    public Set<PluralAttribute<? super X, ?, ?>> getPluralAttributes() {
        HashSet attrs = new HashSet();
        for (Map.Entry<String, Attribute<X, ?>> entry : this.attributes.entrySet()) {
            AttributeImpl attr = (AttributeImpl)entry.getValue();
            if (!(attr instanceof PluralAttribute)) continue;
            attrs.add((PluralAttribute)attr);
        }
        if (this.cmd.getSuperAbstractClassMetaData() != null) {
            Class supercls = this.model.getClassLoaderResolver().classForName(this.cmd.getSuperAbstractClassMetaData().getFullClassName());
            ManagedType supertype = this.model.managedType(supercls);
            Set superattrs = supertype.getPluralAttributes();
            attrs.addAll(superattrs);
        }
        return attrs;
    }

    public Set<PluralAttribute<X, ?, ?>> getDeclaredPluralAttributes() {
        Class thisCls = this.model.getClassLoaderResolver().classForName(this.cmd.getFullClassName());
        HashSet attrs = new HashSet();
        for (Map.Entry<String, Attribute<X, ?>> entry : this.attributes.entrySet()) {
            AbstractMemberMetaData mmd;
            AttributeImpl attr = (AttributeImpl)entry.getValue();
            if (!(attr instanceof PluralAttribute) || (mmd = attr.getMetadata()).getMemberRepresented().getDeclaringClass() != thisCls) continue;
            attrs.add((PluralAttribute)attr);
        }
        return attrs;
    }
}

