/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Parameter;
import javax.persistence.PersistenceException;
import javax.persistence.QueryTimeoutException;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import org.datanucleus.api.jpa.JPAQueryParameter;
import org.datanucleus.api.jpa.NucleusJPAHelper;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.store.query.NoQueryResultsException;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryInvalidParametersException;
import org.datanucleus.store.query.QueryNotUniqueException;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAQuery<X>
implements TypedQuery<X> {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.api.jpa.Localisation", (ClassLoader)NucleusJPAHelper.class.getClassLoader());
    EntityManager em;
    String language;
    Query query;
    FlushModeType flushMode = FlushModeType.AUTO;
    LockModeType lockMode = null;
    private long startPosition = 0L;
    private long maxResults = Long.MAX_VALUE;

    public JPAQuery(EntityManager em, Query query, String language) {
        this.em = em;
        this.query = query;
        this.language = language;
        this.flushMode = em.getFlushMode();
        this.query.setCacheResults(false);
    }

    public int executeUpdate() {
        if (this.query.getType() == 0) {
            throw new IllegalStateException(LOCALISER.msg("Query.ExecuteUpdateForSelectInvalid"));
        }
        try {
            Object result;
            if (this.flushMode == FlushModeType.AUTO && this.em.getTransaction().isActive()) {
                this.em.flush();
            }
            if (this.lockMode == LockModeType.PESSIMISTIC_READ || this.lockMode == LockModeType.PESSIMISTIC_WRITE) {
                this.query.setSerializeRead(Boolean.TRUE);
            }
            if ((result = this.query.executeWithMap(null)) != null) {
                return ((Long)result).intValue();
            }
            throw new NucleusException("Invalid return from query for an update/delete. Expected Long");
        }
        catch (NoQueryResultsException nqre) {
            return 0;
        }
        catch (QueryInvalidParametersException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
        catch (org.datanucleus.store.query.QueryTimeoutException qte) {
            throw new QueryTimeoutException();
        }
        catch (NucleusException jpe) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(jpe);
        }
    }

    public List getResultList() {
        if (this.query.getType() != 0) {
            throw new IllegalStateException(LOCALISER.msg("Query.GetResultForUpdateInvalid"));
        }
        try {
            if (this.flushMode == FlushModeType.AUTO && this.em.getTransaction().isActive()) {
                this.em.flush();
            }
            if (this.lockMode == LockModeType.PESSIMISTIC_READ || this.lockMode == LockModeType.PESSIMISTIC_WRITE) {
                this.query.setSerializeRead(Boolean.TRUE);
            }
            if (QueryUtils.queryReturnsSingleRow((Query)this.query)) {
                Object res = this.query.executeWithMap(null);
                ArrayList<Object> l = new ArrayList<Object>();
                l.add(res);
                return l;
            }
            return (List)this.query.executeWithMap(null);
        }
        catch (NoQueryResultsException nqre) {
            return null;
        }
        catch (QueryInvalidParametersException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
        catch (org.datanucleus.store.query.QueryTimeoutException qte) {
            throw new QueryTimeoutException();
        }
        catch (NucleusException jpe) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(jpe);
        }
    }

    public X getSingleResult() {
        if (this.query.getType() != 0) {
            throw new IllegalStateException(LOCALISER.msg("Query.GetResultForUpdateInvalid"));
        }
        try {
            if (this.flushMode == FlushModeType.AUTO && this.em.getTransaction().isActive()) {
                this.em.flush();
            }
            this.query.setUnique(true);
            if (this.lockMode == LockModeType.PESSIMISTIC_READ || this.lockMode == LockModeType.PESSIMISTIC_WRITE) {
                this.query.setSerializeRead(Boolean.TRUE);
            }
            return (X)this.query.executeWithMap(null);
        }
        catch (NoQueryResultsException nqre) {
            throw new NoResultException("No results for query: " + this.query.toString());
        }
        catch (QueryNotUniqueException ex) {
            throw new NonUniqueResultException("Expected a single result for query: " + this.query.toString() + " : " + StringUtils.getStringFromStackTrace((Throwable)ex));
        }
        catch (QueryInvalidParametersException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
        catch (org.datanucleus.store.query.QueryTimeoutException qte) {
            throw new QueryTimeoutException();
        }
        catch (NucleusException jpe) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(jpe);
        }
    }

    public JPAQuery<X> setFirstResult(int startPosition) {
        if (startPosition < 0) {
            throw new IllegalArgumentException(LOCALISER.msg("Query.StartPositionInvalid"));
        }
        this.startPosition = startPosition;
        if (this.maxResults == Long.MAX_VALUE) {
            this.query.setRange(this.startPosition, Long.MAX_VALUE);
        } else {
            this.query.setRange(this.startPosition, this.startPosition + this.maxResults);
        }
        return this;
    }

    public JPAQuery<X> setMaxResults(int max) {
        if (max < 0) {
            throw new IllegalArgumentException(LOCALISER.msg("Query.MaxResultsInvalid"));
        }
        this.maxResults = max;
        this.query.setRange(this.startPosition, this.startPosition + (long)max);
        return this;
    }

    public int getMaxResults() {
        long queryMin = this.query.getRangeFromIncl();
        long queryMax = this.query.getRangeToExcl();
        long max = queryMax - queryMin;
        if (max > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)max;
    }

    public int getFirstResult() {
        return (int)this.query.getRangeFromIncl();
    }

    public JPAQuery<X> setFlushMode(FlushModeType mode) {
        this.flushMode = mode;
        return this;
    }

    public FlushModeType getFlushMode() {
        return this.flushMode;
    }

    public JPAQuery<X> setHint(String hintName, Object value) {
        if (hintName != null && hintName.equalsIgnoreCase("javax.persistence.query.timeout")) {
            this.query.setDatastoreReadTimeoutMillis((Integer)value);
        }
        if (hintName != null && hintName.equalsIgnoreCase("datanucleus.query.fetchSize")) {
            if (value instanceof Integer) {
                this.query.getFetchPlan().setFetchSize(((Integer)value).intValue());
            } else if (value instanceof Long) {
                this.query.getFetchPlan().setFetchSize(((Long)value).intValue());
            }
        }
        this.query.addExtension(hintName, value);
        return this;
    }

    public Map getHints() {
        Map extensions = this.query.getExtensions();
        HashMap map = new HashMap();
        if (extensions != null && extensions.size() > 0) {
            map.putAll(extensions);
        }
        return map;
    }

    public Set<String> getSupportedHints() {
        return this.query.getSupportedExtensions();
    }

    public <T> JPAQuery<X> setParameter(Parameter<T> param, T value) {
        if (param.getName() != null) {
            this.setParameter(param.getName(), value);
        } else {
            this.setParameter(param.getPosition(), value);
        }
        return this;
    }

    public JPAQuery<X> setParameter(String name, Object value) {
        try {
            this.query.setImplicitParameter(name, value);
        }
        catch (QueryInvalidParametersException ipe) {
            throw new IllegalArgumentException(ipe.getMessage(), ipe);
        }
        return this;
    }

    public JPAQuery<X> setParameter(int position, Object value) {
        try {
            this.query.setImplicitParameter(position, value);
        }
        catch (QueryInvalidParametersException ipe) {
            throw new IllegalArgumentException(ipe.getMessage(), ipe);
        }
        return this;
    }

    public JPAQuery<X> setParameter(String name, Date value, TemporalType temporalType) {
        Date paramValue = value;
        if (temporalType == TemporalType.TIME && !(value instanceof Time)) {
            paramValue = new Time(value.getTime());
        } else if (temporalType == TemporalType.TIMESTAMP && !(value instanceof Timestamp)) {
            paramValue = new Timestamp(value.getTime());
        }
        try {
            this.query.setImplicitParameter(name, (Object)paramValue);
        }
        catch (QueryInvalidParametersException ipe) {
            throw new IllegalArgumentException(ipe.getMessage());
        }
        return this;
    }

    public JPAQuery<X> setParameter(String name, Calendar value, TemporalType temporalType) {
        Comparable<Calendar> paramValue = value;
        if (temporalType == TemporalType.DATE) {
            paramValue = value.getTime();
        } else if (temporalType == TemporalType.TIME) {
            paramValue = new Time(value.getTime().getTime());
        } else if (temporalType == TemporalType.TIMESTAMP) {
            paramValue = new Timestamp(value.getTime().getTime());
        }
        try {
            this.query.setImplicitParameter(name, (Object)paramValue);
        }
        catch (QueryInvalidParametersException ipe) {
            throw new IllegalArgumentException(ipe.getMessage());
        }
        return this;
    }

    public JPAQuery<X> setParameter(int position, Date value, TemporalType temporalType) {
        Date paramValue = value;
        if (temporalType == TemporalType.TIME && !(value instanceof Time)) {
            paramValue = new Time(value.getTime());
        } else if (temporalType == TemporalType.TIMESTAMP && !(value instanceof Timestamp)) {
            paramValue = new Timestamp(value.getTime());
        }
        try {
            this.query.setImplicitParameter(position, (Object)paramValue);
        }
        catch (QueryInvalidParametersException ipe) {
            throw new IllegalArgumentException(ipe.getMessage());
        }
        return this;
    }

    public JPAQuery<X> setParameter(int position, Calendar value, TemporalType temporalType) {
        Comparable<Calendar> paramValue = value;
        if (temporalType == TemporalType.DATE) {
            paramValue = value.getTime();
        } else if (temporalType == TemporalType.TIME) {
            paramValue = new Time(value.getTime().getTime());
        } else if (temporalType == TemporalType.TIMESTAMP) {
            paramValue = new Timestamp(value.getTime().getTime());
        }
        try {
            this.query.setImplicitParameter(position, (Object)paramValue);
        }
        catch (QueryInvalidParametersException ipe) {
            throw new IllegalArgumentException(ipe.getMessage());
        }
        return this;
    }

    public JPAQuery<X> setParameter(Parameter<Calendar> param, Calendar cal, TemporalType type) {
        if (param.getName() != null) {
            this.setParameter(param.getName(), cal, type);
        } else {
            this.setParameter((int)param.getPosition(), cal, type);
        }
        return this;
    }

    public JPAQuery<X> setParameter(Parameter<Date> param, Date date, TemporalType type) {
        if (param.getName() != null) {
            this.setParameter(param.getName(), date, type);
        } else {
            this.setParameter((int)param.getPosition(), date, type);
        }
        return this;
    }

    public Query getInternalQuery() {
        return this.query;
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls == Query.class) {
            return (T)this.query;
        }
        throw new PersistenceException("Not supported unwrapping of query to " + cls.getName());
    }

    public String getLanguage() {
        return this.language;
    }

    public Set<Parameter<?>> getParameters() {
        Set paramKeys = this.query.getImplicitParameters().keySet();
        HashSet parameters = new HashSet();
        for (Object paramKey : paramKeys) {
            Object value = this.query.getImplicitParameters().get(paramKey);
            if (paramKey instanceof String) {
                parameters.add(new JPAQueryParameter((String)paramKey, value != null ? value.getClass() : null));
                continue;
            }
            if (!(paramKey instanceof Integer)) continue;
            parameters.add(new JPAQueryParameter((Integer)paramKey, value != null ? value.getClass() : null));
        }
        return parameters;
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        Set paramKeys = this.query.getImplicitParameters().keySet();
        for (Object paramKey : paramKeys) {
            Object value;
            if (!(paramKey instanceof String) || !((String)paramKey).equals(name) || (value = this.query.getImplicitParameters().get(paramKey)) == null || !type.isAssignableFrom(value.getClass())) continue;
            return new JPAQueryParameter<T>((String)paramKey, type);
        }
        throw new IllegalArgumentException("No parameter with name " + name + " and type=" + type.getName());
    }

    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        Set paramKeys = this.query.getImplicitParameters().keySet();
        for (Object paramKey : paramKeys) {
            Object value;
            if (!(paramKey instanceof Integer) || (Integer)paramKey != position || (value = this.query.getImplicitParameters().get(paramKey)) == null || !type.isAssignableFrom(value.getClass())) continue;
            return new JPAQueryParameter<T>((Integer)paramKey, type);
        }
        throw new IllegalArgumentException("No parameter at position=" + position + " and type=" + type.getName());
    }

    public Parameter<?> getParameter(int position) {
        Set paramKeys = this.query.getImplicitParameters().keySet();
        for (Object paramKey : paramKeys) {
            if (!(paramKey instanceof Integer) || (Integer)paramKey != position) continue;
            Object value = this.query.getImplicitParameters().get(paramKey);
            return new JPAQueryParameter((Integer)paramKey, value != null ? value.getClass() : null);
        }
        throw new IllegalArgumentException("No parameter at position=" + position);
    }

    public Parameter<?> getParameter(String name) {
        Set paramKeys = this.query.getImplicitParameters().keySet();
        for (Object paramKey : paramKeys) {
            if (!(paramKey instanceof String) || !((String)paramKey).equals(name)) continue;
            Object value = this.query.getImplicitParameters().get(paramKey);
            return new JPAQueryParameter((String)paramKey, value != null ? value.getClass() : null);
        }
        throw new IllegalArgumentException("No parameter with name " + name);
    }

    public <T> T getParameterValue(Parameter<T> param) {
        if (param.getName() != null) {
            if (this.query.getImplicitParameters().containsKey(param.getName())) {
                return (T)this.query.getImplicitParameters().get(param.getName());
            }
        } else if (this.query.getImplicitParameters().containsKey(param.getPosition())) {
            return (T)this.query.getImplicitParameters().get(param.getPosition());
        }
        throw new IllegalStateException("No parameter matching " + param + " bound to this query");
    }

    public Object getParameterValue(int position) {
        if (this.query.getImplicitParameters().containsKey(position)) {
            return this.query.getImplicitParameters().get(position);
        }
        return null;
    }

    public Object getParameterValue(String name) {
        if (this.query.getImplicitParameters().containsKey(name)) {
            return this.query.getImplicitParameters().get(name);
        }
        return null;
    }

    public boolean isBound(Parameter<?> param) {
        return param.getName() != null ? this.query.getImplicitParameters().containsKey(param.getName()) : this.query.getImplicitParameters().containsKey(param.getPosition());
    }

    public LockModeType getLockMode() {
        if (this.query.getType() != 0 || !this.query.getLanguage().equals("JPQL")) {
            throw new IllegalStateException("Query has to be a SELECT JPQL query to allow locking");
        }
        return this.lockMode;
    }

    public JPAQuery<X> setLockMode(LockModeType lock) {
        if (this.query.getType() != 0 || !this.query.getLanguage().equals("JPQL")) {
            throw new IllegalStateException("Query has to be a SELECT JPQL query to allow locking");
        }
        this.lockMode = lock;
        return this;
    }

    JPAQuery<X> setResultClass(Class resultClass) {
        this.query.setResultClass(resultClass);
        return this;
    }

    public String toString() {
        return this.query.toString();
    }
}

