/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo.state;

import org.datanucleus.FetchPlan;
import org.datanucleus.api.jdo.exceptions.TransactionNotReadableException;
import org.datanucleus.api.jdo.exceptions.TransactionNotWritableException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.state.IllegalStateTransitionException;
import org.datanucleus.state.LifeCycleState;
import org.datanucleus.transaction.Transaction;
import org.datanucleus.util.Localiser;

class Hollow
extends LifeCycleState {
    protected Hollow() {
        this.isPersistent = true;
        this.isDirty = false;
        this.isNew = false;
        this.isDeleted = false;
        this.isTransactional = false;
        this.stateType = 4;
    }

    public LifeCycleState transitionDeletePersistent(DNStateManager sm) {
        sm.clearLoadedFlags();
        return this.changeState(sm, 8);
    }

    public LifeCycleState transitionMakeTransactional(DNStateManager sm, boolean refreshFields) {
        if (refreshFields) {
            sm.refreshLoadedFields();
        }
        return this.changeState(sm, 2);
    }

    public LifeCycleState transitionMakeTransient(DNStateManager sm, boolean useFetchPlan, boolean detachAllOnCommit) {
        if (useFetchPlan) {
            sm.loadUnloadedFieldsInFetchPlan();
        }
        return this.changeState(sm, 0);
    }

    public LifeCycleState transitionCommit(DNStateManager sm, Transaction tx) {
        throw new IllegalStateTransitionException((LifeCycleState)this, "commit", sm);
    }

    public LifeCycleState transitionRollback(DNStateManager sm, Transaction tx) {
        throw new IllegalStateTransitionException((LifeCycleState)this, "rollback", sm);
    }

    public LifeCycleState transitionReadField(DNStateManager sm, boolean isLoaded) {
        Transaction tx = sm.getExecutionContext().getTransaction();
        if (!tx.isActive() && !tx.getNontransactionalRead()) {
            throw new TransactionNotReadableException(Localiser.msg((String)"027000"), sm.getInternalObjectId());
        }
        if (!tx.isActive() && sm.getClassMetaData().getIdentityType() == IdentityType.NONDURABLE && !isLoaded) {
            throw new NucleusUserException("Not able to read fields of nondurable object when in HOLLOW state");
        }
        if (!tx.getOptimistic() && tx.isActive()) {
            return this.changeState(sm, 2);
        }
        return this.changeState(sm, 9);
    }

    public LifeCycleState transitionWriteField(DNStateManager sm) {
        Transaction tx = sm.getExecutionContext().getTransaction();
        if (!tx.isActive() && !tx.getNontransactionalWrite()) {
            throw new TransactionNotWritableException(Localiser.msg((String)"027001"), sm.getInternalObjectId());
        }
        return this.changeState(sm, tx.isActive() ? 3 : 9);
    }

    public LifeCycleState transitionRetrieve(DNStateManager sm, boolean fgOnly) {
        if (fgOnly) {
            sm.loadUnloadedFieldsInFetchPlan();
        } else {
            sm.loadUnloadedFields();
        }
        Transaction tx = sm.getExecutionContext().getTransaction();
        if (!tx.getOptimistic() && tx.isActive()) {
            return this.changeState(sm, 2);
        }
        if (tx.getOptimistic()) {
            return this.changeState(sm, 9);
        }
        return super.transitionRetrieve(sm, fgOnly);
    }

    public LifeCycleState transitionRetrieve(DNStateManager sm, FetchPlan fetchPlan) {
        sm.loadUnloadedFieldsOfClassInFetchPlan(fetchPlan);
        Transaction tx = sm.getExecutionContext().getTransaction();
        if (!tx.getOptimistic() && tx.isActive()) {
            return this.changeState(sm, 2);
        }
        if (tx.getOptimistic()) {
            return this.changeState(sm, 9);
        }
        return super.transitionRetrieve(sm, fetchPlan);
    }

    public LifeCycleState transitionRefresh(DNStateManager sm) {
        sm.clearSavedFields();
        sm.refreshFieldsInFetchPlan();
        sm.unloadNonFetchPlanFields();
        return this;
    }

    public LifeCycleState transitionDetach(DNStateManager sm) {
        return this.changeState(sm, 11);
    }

    public LifeCycleState transitionSerialize(DNStateManager sm) {
        Transaction tx = sm.getExecutionContext().getTransaction();
        if (tx.isActive() && !tx.getOptimistic()) {
            return this.changeState(sm, 2);
        }
        return this;
    }

    public String toString() {
        return "HOLLOW";
    }
}

