/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.jdo.JDOCanRetryException;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalDataStoreException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOHelper;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.JDOOptimisticVerificationException;
import javax.jdo.JDOQueryInterruptedException;
import javax.jdo.JDOUnsupportedOptionException;
import javax.jdo.JDOUserException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.api.jdo.JDOPersistenceManager;
import org.datanucleus.api.jdo.exceptions.ClassNotPersistenceCapableException;
import org.datanucleus.api.jdo.exceptions.NoPersistenceInformationException;
import org.datanucleus.api.jdo.exceptions.TransactionNotActiveException;
import org.datanucleus.api.jdo.exceptions.TransactionNotReadableException;
import org.datanucleus.api.jdo.exceptions.TransactionNotWritableException;
import org.datanucleus.api.jdo.metadata.JDOXmlMetaDataHelper;
import org.datanucleus.api.jdo.state.LifeCycleStateFactory;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.exceptions.ClassNotPersistableException;
import org.datanucleus.exceptions.DatastoreReadOnlyException;
import org.datanucleus.exceptions.NucleusCanRetryException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUnsupportedOptionException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InvalidPrimaryKeyException;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.state.LifeCycleState;
import org.datanucleus.store.query.QueryInterruptedException;
import org.datanucleus.store.query.QueryTimeoutException;
import org.datanucleus.transaction.HeuristicRollbackException;
import org.datanucleus.util.ClassUtils;

public class JDOAdapter
implements ApiAdapter {
    private static final long serialVersionUID = 4135712868062532386L;
    protected static final Set<String> defaultPersistentTypeNames = new HashSet<String>();

    public String getName() {
        return "JDO";
    }

    public boolean isMemberDefaultPersistent(Class type) {
        String typeName = type.getName();
        if (defaultPersistentTypeNames.contains(typeName)) {
            return true;
        }
        if (Enum.class.isAssignableFrom(type) || Serializable.class.isAssignableFrom(type)) {
            return true;
        }
        return this.isPersistable(type);
    }

    public String getXMLMetaDataForClass(AbstractClassMetaData cmd, String prefix, String indent) {
        return new JDOXmlMetaDataHelper().getXMLForMetaData(cmd, prefix, indent);
    }

    public String getDefaultMappingFileLocation() {
        return null;
    }

    public ExecutionContext getExecutionContext(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Persistable) {
            return (ExecutionContext)((Persistable)obj).dnGetExecutionContext();
        }
        if (obj instanceof JDOPersistenceManager) {
            return ((JDOPersistenceManager)obj).getExecutionContext();
        }
        return null;
    }

    public LifeCycleState getLifeCycleState(int stateType) {
        return LifeCycleStateFactory.getLifeCycleState(stateType);
    }

    public String getObjectState(Object obj) {
        if (obj == null) {
            return null;
        }
        return JDOHelper.getObjectState((Object)obj).toString();
    }

    public boolean isValidPrimaryKeyClass(Class pkClass, AbstractClassMetaData cmd, ClassLoaderResolver clr, int noOfPkFields, MetaDataManager mmgr) {
        if (ClassUtils.isInnerClass((String)pkClass.getName()) && !Modifier.isStatic(pkClass.getModifiers())) {
            throw new InvalidPrimaryKeyException("019000", new Object[]{cmd.getFullClassName(), pkClass.getName()});
        }
        if (!Modifier.isPublic(pkClass.getModifiers())) {
            throw new InvalidPrimaryKeyException("019001", new Object[]{cmd.getFullClassName(), pkClass.getName()});
        }
        if (!Serializable.class.isAssignableFrom(pkClass)) {
            throw new InvalidPrimaryKeyException("019002", new Object[]{cmd.getFullClassName(), pkClass.getName()});
        }
        if (IdentityUtils.isSingleFieldIdentityClass((String)pkClass.getName())) {
            if (noOfPkFields != 1) {
                throw new InvalidPrimaryKeyException("019003", new Object[]{cmd.getFullClassName()});
            }
        } else {
            Method method2;
            Constructor constructor;
            try {
                constructor = pkClass.getConstructor(new Class[0]);
                if (constructor == null || !Modifier.isPublic(constructor.getModifiers())) {
                    throw new InvalidPrimaryKeyException("019004", new Object[]{cmd.getFullClassName(), pkClass.getName()});
                }
            }
            catch (NoSuchMethodException ex) {
                throw new InvalidPrimaryKeyException("019004", new Object[]{cmd.getFullClassName(), pkClass.getName()});
            }
            try {
                constructor = pkClass.getConstructor(String.class);
                if (constructor == null || !Modifier.isPublic(constructor.getModifiers())) {
                    throw new InvalidPrimaryKeyException("019005", new Object[]{cmd.getFullClassName(), pkClass.getName()});
                }
            }
            catch (NoSuchMethodException constructor2) {
                // empty catch block
            }
            try {
                method2 = pkClass.getMethod("toString", new Class[0]);
                if (method2 == null || !Modifier.isPublic(method2.getModifiers()) || method2.getDeclaringClass().equals(Object.class)) {
                    throw new InvalidPrimaryKeyException("019006", new Object[]{cmd.getFullClassName(), pkClass.getName()});
                }
            }
            catch (NoSuchMethodException method2) {
                // empty catch block
            }
            try {
                method2 = pkClass.getMethod("hashCode", new Class[0]);
                if (method2 == null || method2.getDeclaringClass().equals(Object.class)) {
                    throw new InvalidPrimaryKeyException("019007", new Object[]{cmd.getFullClassName(), pkClass.getName()});
                }
            }
            catch (NoSuchMethodException method3) {
                // empty catch block
            }
            try {
                method2 = pkClass.getMethod("equals", Object.class);
                if (method2 == null || method2.getDeclaringClass().equals(Object.class)) {
                    throw new InvalidPrimaryKeyException("019008", new Object[]{cmd.getFullClassName(), pkClass.getName()});
                }
            }
            catch (NoSuchMethodException method4) {
                // empty catch block
            }
            int noPkFields = this.processPrimaryKeyClass(pkClass, cmd, clr, mmgr);
            for (Class supercls : ClassUtils.getSuperclasses((Class)pkClass)) {
                noPkFields += this.processPrimaryKeyClass(supercls, cmd, clr, mmgr);
            }
            if (noOfPkFields != noPkFields && cmd.getIdentityType() == IdentityType.APPLICATION) {
                throw new InvalidPrimaryKeyException("019015", new Object[]{cmd.getFullClassName(), pkClass.getName(), "" + noOfPkFields, "" + noPkFields});
            }
        }
        return true;
    }

    private int processPrimaryKeyClass(Class pkClass, AbstractClassMetaData cmd, ClassLoaderResolver clr, MetaDataManager mmgr) {
        int noOfPkFields = 0;
        Field[] fieldsInPkClass = pkClass.getDeclaredFields();
        for (int i = 0; i < fieldsInPkClass.length; ++i) {
            if (Modifier.isStatic(fieldsInPkClass[i].getModifiers())) continue;
            if (!fieldsInPkClass[i].getType().isPrimitive() && !Serializable.class.isAssignableFrom(fieldsInPkClass[i].getType())) {
                throw new InvalidPrimaryKeyException("019009", new Object[]{cmd.getFullClassName(), pkClass.getName(), fieldsInPkClass[i].getName()});
            }
            if (!Modifier.isPublic(fieldsInPkClass[i].getModifiers())) {
                throw new InvalidPrimaryKeyException("019010", new Object[]{cmd.getFullClassName(), pkClass.getName(), fieldsInPkClass[i].getName()});
            }
            if (fieldsInPkClass[i].getName().equals("targetClassName")) continue;
            AbstractMemberMetaData fieldInPcClass = cmd.getMetaDataForMember(fieldsInPkClass[i].getName());
            boolean foundField = false;
            if (fieldInPcClass == null) {
                throw new InvalidPrimaryKeyException("019011", new Object[]{cmd.getFullClassName(), pkClass.getName(), fieldsInPkClass[i].getName()});
            }
            if (fieldInPcClass.getTypeName().equals(fieldsInPkClass[i].getType().getName())) {
                foundField = true;
            }
            if (!foundField) {
                String fieldTypePkClass = fieldsInPkClass[i].getType().getName();
                AbstractClassMetaData refCmd = mmgr.getMetaDataForClassInternal(fieldInPcClass.getType(), clr);
                if (refCmd == null) {
                    throw new InvalidPrimaryKeyException("019012", new Object[]{cmd.getFullClassName(), pkClass.getName(), fieldsInPkClass[i].getName(), fieldInPcClass.getType().getName()});
                }
                if (refCmd.getObjectidClass() == null && IdentityUtils.isSingleFieldIdentityClass((String)fieldTypePkClass)) {
                    throw new InvalidPrimaryKeyException("019014", new Object[]{cmd.getFullClassName(), pkClass.getName(), fieldsInPkClass[i].getName(), fieldTypePkClass, refCmd.getFullClassName()});
                }
                if (!fieldTypePkClass.equals(refCmd.getObjectidClass())) {
                    throw new InvalidPrimaryKeyException("019013", new Object[]{cmd.getFullClassName(), pkClass.getName(), fieldsInPkClass[i].getName(), fieldTypePkClass, refCmd.getObjectidClass()});
                }
                foundField = true;
            }
            if (!foundField) {
                throw new InvalidPrimaryKeyException("019012", new Object[]{cmd.getFullClassName(), pkClass.getName(), fieldsInPkClass[i].getName(), fieldInPcClass.getType().getName()});
            }
            ++noOfPkFields;
        }
        return noOfPkFields;
    }

    public boolean allowPersistOfDeletedObject() {
        return false;
    }

    public boolean allowDeleteOfNonPersistentObject() {
        return false;
    }

    public boolean allowReadFieldOfDeletedObject() {
        return false;
    }

    public boolean clearLoadedFlagsOnDeleteObject() {
        return true;
    }

    public boolean getDefaultCascadePersistForField() {
        return true;
    }

    public boolean getDefaultCascadeUpdateForField() {
        return true;
    }

    public boolean getDefaultCascadeDeleteForField() {
        return false;
    }

    public boolean getDefaultCascadeDetachForField() {
        return true;
    }

    public boolean getDefaultCascadeRefreshForField() {
        return false;
    }

    public boolean getDefaultDFGForPersistableField() {
        return false;
    }

    public Map getDefaultFactoryProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("datanucleus.DetachAllOnCommit", "false");
        props.put("datanucleus.CopyOnAttach", "true");
        props.put("datanucleus.identifierFactory", "datanucleus2");
        props.put("datanucleus.persistenceByReachabilityAtCommit", "true");
        props.put("datanucleus.query.sql.allowAll", "false");
        props.put("datanucleus.validation.mode", "none");
        props.put("datanucleus.executionContext.closeActiveTxAction", "rollback");
        return props;
    }

    public boolean getDefaultPersistentPropertyWhenNotSpecified() {
        return false;
    }

    public RuntimeException getUserExceptionForException(String msg, Exception e) {
        return new JDOUserException(msg, (Throwable)e);
    }

    public RuntimeException getDataStoreExceptionForException(String msg, Exception e) {
        return new JDODataStoreException(msg, (Throwable)e);
    }

    public RuntimeException getApiExceptionForNucleusException(NucleusException ne) {
        return JDOAdapter.getJDOExceptionForNucleusException(ne);
    }

    public static JDOException getJDOExceptionForNucleusException(NucleusException ne) {
        if (ne instanceof ClassNotPersistableException) {
            return new ClassNotPersistenceCapableException(ne.getMessage(), (Exception)((Object)ne));
        }
        if (ne instanceof org.datanucleus.exceptions.NoPersistenceInformationException) {
            return new NoPersistenceInformationException(ne.getMessage(), (Exception)((Object)ne));
        }
        if (ne instanceof org.datanucleus.exceptions.TransactionNotReadableException) {
            return new TransactionNotReadableException(ne.getMessage(), ne.getCause());
        }
        if (ne instanceof org.datanucleus.exceptions.TransactionNotWritableException) {
            return new TransactionNotWritableException(ne.getMessage(), ne.getCause());
        }
        if (ne instanceof org.datanucleus.exceptions.TransactionNotActiveException) {
            return new TransactionNotActiveException(ne.getMessage(), (Object)ne);
        }
        if (ne instanceof QueryInterruptedException) {
            return new JDOQueryInterruptedException(ne.getMessage());
        }
        if (ne instanceof QueryTimeoutException) {
            return new JDODataStoreException(ne.getMessage(), (Throwable)ne);
        }
        if (ne instanceof NucleusUnsupportedOptionException) {
            return new JDOUnsupportedOptionException(ne.getMessage(), (Throwable)ne);
        }
        if (ne instanceof DatastoreReadOnlyException) {
            ClassLoaderResolver clr = ((DatastoreReadOnlyException)ne).getClassLoaderResolver();
            try {
                Class cls = clr.classForName("javax.jdo.JDOReadOnlyException");
                throw (JDOUserException)ClassUtils.newInstance((Class)cls, (Class[])new Class[]{String.class}, (Object[])new Object[]{ne.getMessage()});
            }
            catch (NucleusException ne2) {
                throw new JDOUserException(ne2.getMessage());
            }
        }
        if (ne instanceof NucleusDataStoreException) {
            if (ne.isFatal()) {
                if (ne.getFailedObject() != null) {
                    return new JDOFatalDataStoreException(ne.getMessage(), ne.getFailedObject());
                }
                if (ne.getNestedExceptions() != null) {
                    return new JDOFatalDataStoreException(ne.getMessage(), ne.getNestedExceptions());
                }
                return new JDOFatalDataStoreException(ne.getMessage(), (Throwable)ne);
            }
            if (ne.getNestedExceptions() != null) {
                if (ne.getFailedObject() != null) {
                    return new JDODataStoreException(ne.getMessage(), ne.getNestedExceptions(), ne.getFailedObject());
                }
                return new JDODataStoreException(ne.getMessage(), ne.getNestedExceptions());
            }
            if (ne.getFailedObject() != null) {
                JDOPersistenceManager.LOGGER.info((Object)"Exception thrown", (Throwable)ne);
                return new JDODataStoreException(ne.getMessage(), ne.getFailedObject());
            }
            JDOPersistenceManager.LOGGER.info((Object)"Exception thrown", (Throwable)ne);
            return new JDODataStoreException(ne.getMessage(), (Throwable)ne);
        }
        if (ne instanceof NucleusObjectNotFoundException) {
            if (ne.getFailedObject() != null) {
                if (ne.getNestedExceptions() != null) {
                    return new JDOObjectNotFoundException(ne.getMessage(), ne.getNestedExceptions(), ne.getFailedObject());
                }
                return new JDOObjectNotFoundException(ne.getMessage(), (Throwable)ne, ne.getFailedObject());
            }
            if (ne.getNestedExceptions() != null) {
                return new JDOObjectNotFoundException(ne.getMessage(), ne.getNestedExceptions());
            }
            return new JDOObjectNotFoundException(ne.getMessage(), new Throwable[]{ne});
        }
        if (ne instanceof NucleusCanRetryException) {
            if (ne.getNestedExceptions() != null) {
                if (ne.getFailedObject() != null) {
                    return new JDOCanRetryException(ne.getMessage(), ne.getNestedExceptions(), ne.getFailedObject());
                }
                return new JDOCanRetryException(ne.getMessage(), ne.getNestedExceptions());
            }
            if (ne.getFailedObject() != null) {
                JDOPersistenceManager.LOGGER.info((Object)"Exception thrown", (Throwable)ne);
                return new JDOCanRetryException(ne.getMessage(), ne.getFailedObject());
            }
            JDOPersistenceManager.LOGGER.info((Object)"Exception thrown", (Throwable)ne);
            return new JDOCanRetryException(ne.getMessage(), (Throwable)ne);
        }
        if (ne instanceof NucleusUserException) {
            if (ne.isFatal()) {
                if (ne.getNestedExceptions() != null) {
                    if (ne.getFailedObject() != null) {
                        return new JDOFatalUserException(ne.getMessage(), ne.getNestedExceptions(), ne.getFailedObject());
                    }
                    return new JDOFatalUserException(ne.getMessage(), ne.getNestedExceptions());
                }
                if (ne.getFailedObject() != null) {
                    JDOPersistenceManager.LOGGER.info((Object)"Exception thrown", (Throwable)ne);
                    return new JDOFatalUserException(ne.getMessage(), ne.getFailedObject());
                }
                JDOPersistenceManager.LOGGER.info((Object)"Exception thrown", (Throwable)ne);
                return new JDOFatalUserException(ne.getMessage(), (Throwable)ne);
            }
            if (ne.getNestedExceptions() != null) {
                if (ne.getFailedObject() != null) {
                    return new JDOUserException(ne.getMessage(), ne.getNestedExceptions(), ne.getFailedObject());
                }
                return new JDOUserException(ne.getMessage(), ne.getNestedExceptions());
            }
            if (ne.getFailedObject() != null) {
                JDOPersistenceManager.LOGGER.info((Object)"Exception thrown", (Throwable)ne);
                return new JDOUserException(ne.getMessage(), ne.getFailedObject());
            }
            JDOPersistenceManager.LOGGER.info((Object)"Exception thrown", (Throwable)ne);
            return new JDOUserException(ne.getMessage(), (Throwable)ne);
        }
        if (ne instanceof NucleusOptimisticException) {
            if (ne.getFailedObject() != null) {
                return new JDOOptimisticVerificationException(ne.getMessage(), ne.getFailedObject());
            }
            if (ne.getNestedExceptions() != null) {
                return new JDOOptimisticVerificationException(ne.getMessage(), ne.getNestedExceptions());
            }
            return new JDOOptimisticVerificationException(ne.getMessage(), (Object)ne);
        }
        if (ne instanceof HeuristicRollbackException && ne.getNestedExceptions().length == 1 && ne.getNestedExceptions()[0].getCause() instanceof SQLException) {
            return new JDODataStoreException(ne.getMessage(), ne.getNestedExceptions()[0].getCause());
        }
        if (ne instanceof HeuristicRollbackException && ne.getNestedExceptions().length == 1 && ne.getNestedExceptions()[0] instanceof NucleusDataStoreException) {
            return new JDODataStoreException(ne.getMessage(), ne.getNestedExceptions()[0].getCause());
        }
        if (ne.isFatal()) {
            if (ne.getNestedExceptions() != null) {
                return new JDOFatalInternalException(ne.getMessage(), ne.getNestedExceptions());
            }
            return new JDOFatalInternalException(ne.getMessage(), (Throwable)ne);
        }
        if (ne.getNestedExceptions() != null) {
            return new JDOException(ne.getMessage(), ne.getNestedExceptions());
        }
        return new JDOException(ne.getMessage(), (Throwable)ne);
    }

    static {
        defaultPersistentTypeNames.add(ClassNameConstants.BOOLEAN);
        defaultPersistentTypeNames.add(ClassNameConstants.BYTE);
        defaultPersistentTypeNames.add(ClassNameConstants.CHAR);
        defaultPersistentTypeNames.add(ClassNameConstants.DOUBLE);
        defaultPersistentTypeNames.add(ClassNameConstants.FLOAT);
        defaultPersistentTypeNames.add(ClassNameConstants.INT);
        defaultPersistentTypeNames.add(ClassNameConstants.LONG);
        defaultPersistentTypeNames.add(ClassNameConstants.SHORT);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_BOOLEAN);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_BYTE);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_CHARACTER);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_DOUBLE);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_FLOAT);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_INTEGER);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_LONG);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_SHORT);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_STRING);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_UTIL_DATE);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_SQL_DATE);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_SQL_TIME);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_SQL_TIMESTAMP);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_MATH_BIGDECIMAL);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_MATH_BIGINTEGER);
        defaultPersistentTypeNames.add(Locale.class.getName());
        defaultPersistentTypeNames.add(Currency.class.getName());
        defaultPersistentTypeNames.add(ClassNameConstants.BOOLEAN_ARRAY);
        defaultPersistentTypeNames.add(ClassNameConstants.BYTE_ARRAY);
        defaultPersistentTypeNames.add(ClassNameConstants.CHAR_ARRAY);
        defaultPersistentTypeNames.add(ClassNameConstants.DOUBLE_ARRAY);
        defaultPersistentTypeNames.add(ClassNameConstants.FLOAT_ARRAY);
        defaultPersistentTypeNames.add(ClassNameConstants.INT_ARRAY);
        defaultPersistentTypeNames.add(ClassNameConstants.LONG_ARRAY);
        defaultPersistentTypeNames.add(ClassNameConstants.SHORT_ARRAY);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_BOOLEAN_ARRAY);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_BYTE_ARRAY);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_CHARACTER_ARRAY);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_DOUBLE_ARRAY);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_FLOAT_ARRAY);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_INTEGER_ARRAY);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_LONG_ARRAY);
        defaultPersistentTypeNames.add(ClassNameConstants.JAVA_LANG_SHORT_ARRAY);
    }
}

