/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.client.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XML {
    private static final Map<String, String> defaultOutputProps = new HashMap<String, String>();

    public static Document getXml(String xml, String encoding) {
        try {
            return XML.getXml(new ByteArrayInputStream(xml.getBytes(encoding)), encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Document getXml(String xml) {
        return XML.getXml(xml, "utf-8");
    }

    public static Document getXml(InputStream in) {
        return XML.getXml(in, "utf-8");
    }

    public static Document getXml(InputStream in, String encoding) {
        DocumentBuilderFactory factory = null;
        DocumentBuilder builder = null;
        Document ret = null;
        try {
            factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        try {
            InputSource is = new InputSource(in);
            is.setEncoding(encoding);
            ret = builder.parse(is);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    public static String toString(Node xml) {
        return XML.toString(xml, defaultOutputProps);
    }

    public static String toString(Node xml, Map<String, String> outputProps) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            for (String k : outputProps.keySet()) {
                transformer.setOutputProperty(k, outputProps.get(k));
            }
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(xml);
            transformer.transform(source, result);
            return result.getWriter().toString();
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void appendChildAcrossDocuments(Element parent, Node child) {
        if (child instanceof Document) {
            child = ((Document)child).getDocumentElement();
        }
        parent.appendChild(parent.getOwnerDocument().importNode(child, true));
    }

    static {
        defaultOutputProps.put("indent", "yes");
    }
}

